/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.Workload;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;
import org.scaledl.usageevolution.Usage;
import org.scaledl.usageevolution.UsageEvolution;
import org.scaledl.usageevolution.WorkParameterEvolution;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.ModelEvaluator;

public abstract class PeriodicallyTriggeredUsageEvolver
extends PeriodicallyTriggeredSimulationEntity {
    static final Logger LOGGER = Logger.getLogger(PeriodicallyTriggeredUsageEvolver.class);
    protected SimuLizarRuntimeState rtState;
    protected final String evolvedScenarioId;
    protected final double deltaTime;
    private final Map<Usage, ModelEvaluator> cachedLoadEvaluators = new HashMap<Usage, ModelEvaluator>();
    private final Map<Usage, Map<VariableCharacterisation, ModelEvaluator>> cachedWorkEvaluators = new HashMap<Usage, Map<VariableCharacterisation, ModelEvaluator>>();

    public PeriodicallyTriggeredUsageEvolver(SimuLizarRuntimeState rtState, double firstOccurrence, double delay, UsageScenario evolvedScenario) {
        super(rtState.getModel(), firstOccurrence, delay);
        this.deltaTime = delay;
        this.evolvedScenarioId = evolvedScenario.getId();
        this.rtState = rtState;
    }

    protected ModelEvaluator getLoadEvaluator() {
        Sequence loadEvolutionSequence;
        Usage usage = this.getCorrespondingUsage();
        ModelEvaluator evaluator = this.cachedLoadEvaluators.get(usage);
        if (evaluator == null && (loadEvolutionSequence = usage.getLoadEvolution()) != null) {
            evaluator = new ModelEvaluator(loadEvolutionSequence);
            this.cachedLoadEvaluators.put(usage, evaluator);
        }
        return evaluator;
    }

    protected Usage getCorrespondingUsage() {
        UsageEvolution usageEvolution = this.rtState.getModelAccess().getUsageEvolutionModel();
        for (Usage usage : usageEvolution.getUsages()) {
            if (!usage.getScenario().getId().equals(this.evolvedScenarioId)) continue;
            return usage;
        }
        return null;
    }

    protected Map<VariableCharacterisation, ModelEvaluator> getWorkEvaluators() {
        Usage usage = this.getCorrespondingUsage();
        Map<Object, Object> workEvaluators = this.cachedWorkEvaluators.get(usage);
        if (workEvaluators == null) {
            if (usage != null && usage.getWorkEvolutions() != null && usage.getWorkEvolutions().size() > 0) {
                workEvaluators = new HashMap<VariableCharacterisation, ModelEvaluator>();
                for (WorkParameterEvolution workParam : usage.getWorkEvolutions()) {
                    VariableCharacterisation varChar = workParam.getVariableCharacterisation();
                    Sequence paramSequence = workParam.getEvolution();
                    if (varChar == null) {
                        LOGGER.error((Object)"Skipping evolution of unspecified work parameter");
                        continue;
                    }
                    if (paramSequence == null) {
                        LOGGER.error((Object)("Skipping unspecified evolution for work parameter " + varChar));
                        continue;
                    }
                    workEvaluators.put(varChar, new ModelEvaluator(paramSequence));
                }
                this.cachedWorkEvaluators.put(usage, workEvaluators);
            } else {
                workEvaluators = Collections.emptyMap();
            }
        }
        return workEvaluators;
    }

    @Override
    protected void triggerInternal() {
        ModelEvaluator loadEvaluator = this.getLoadEvaluator();
        if (loadEvaluator != null) {
            this.evolveLoad(loadEvaluator);
        }
        Map<VariableCharacterisation, ModelEvaluator> workEvaluators = this.getWorkEvaluators();
        for (VariableCharacterisation workParam : workEvaluators.keySet()) {
            VariableCharacterisation globalWorkParam = this.getGlobalWorkParameter(workParam);
            this.evolveWork(globalWorkParam, workEvaluators.get(workParam));
        }
    }

    private VariableCharacterisation getGlobalWorkParameter(VariableCharacterisation workParam) {
        VariableCharacterisation globalWorkParam = (VariableCharacterisation)this.rtState.getModelAccess().getGlobalPCMModel().getResourceSet().getEObject(EcoreUtil.getURI((EObject)workParam), false);
        return globalWorkParam;
    }

    protected double getDLIMFinalDuration() {
        return this.getCorrespondingUsage().getLoadEvolution().getFinalDuration();
    }

    protected double getCurrentTime() {
        return this.getModel().getSimulationControl().getCurrentSimulationTime();
    }

    protected void evolveLoad(ModelEvaluator loadEvaluator) {
        double newRate = this.getNewRate(loadEvaluator);
        Workload wl = this.getCorrespondingUsage().getScenario().getWorkload_UsageScenario();
        if (wl != null) {
            if (wl instanceof OpenWorkload) {
                PCMRandomVariable openwl = ((OpenWorkload)wl).getInterArrivalTime_OpenWorkload();
                String newRateStr = Double.toString(newRate = newRate != 0.0 ? 1.0 / newRate : 2.147483647E9);
                if (newRateStr.equals(openwl.getSpecification())) {
                    LOGGER.debug((Object)("Inter arrival time is still: " + newRateStr));
                } else {
                    LOGGER.debug((Object)("Changing inter arrival time from: " + openwl.getSpecification() + " to :" + newRateStr));
                    openwl.setSpecification(newRateStr);
                }
            } else if (wl instanceof ClosedWorkload) {
                int oldRate;
                int newRateInt = (int)Math.round(newRate);
                if (newRateInt == (oldRate = ((ClosedWorkload)wl).getPopulation())) {
                    LOGGER.debug((Object)("Closed workload population is still: " + newRateInt));
                } else {
                    LOGGER.debug((Object)("Changing closed workload population from: " + oldRate + " to " + newRateInt));
                    ((ClosedWorkload)wl).setPopulation(newRateInt);
                }
            }
        }
    }

    protected abstract double getNewRate(ModelEvaluator var1);

    protected void evolveWork(VariableCharacterisation workParameter, ModelEvaluator evaluator) {
        if (evaluator == null) {
            return;
        }
        long newRate = Math.round(this.getNewRate(evaluator));
        String newRateStr = Long.toString(newRate);
        LOGGER.debug((Object)("Changing work from " + workParameter.getSpecification_VariableCharacterisation().getSpecification() + " to " + newRateStr));
        workParameter.getSpecification_VariableCharacterisation().setSpecification(newRateStr);
    }
}

