/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;

public class FileUtil {
    public static File getFolder(String path) {
        String filePath = path;
        File folder = null;
        if (!path.startsWith("platform:")) {
            filePath = "file:///" + filePath;
            URI folderURI = URI.createURI((String)filePath);
            folder = new File(folderURI.toFileString());
        } else {
            try {
                URL pathURL = FileLocator.resolve((URL)new URL(path));
                String folderString = pathURL.toExternalForm().replace("file:", "");
                folder = new File(folderString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return folder;
    }

    public static File[] getFiles(File folder, final String fileExtension) {
        if (folder == null || !folder.exists()) {
            return new File[0];
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(fileExtension);
            }
        });
        return files;
    }
}

