/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utils;

import de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.VariableReference;
import de.uka.ipd.sdq.stoex.analyser.visitors.StoExPrettyPrintVisitor;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;

public final class SimulatedStackHelper {
    private static final Logger LOGGER = Logger.getLogger(SimulatedStackHelper.class);

    public static final void addParameterToStackFrame(SimulatedStackframe<Object> contextStackFrame, EList<VariableUsage> parameter, SimulatedStackframe<Object> targetStackFrame) {
        for (VariableUsage variableUsage : parameter) {
            for (VariableCharacterisation variableCharacterisation : variableUsage.getVariableCharacterisation_VariableUsage()) {
                PCMRandomVariable randomVariable = variableCharacterisation.getSpecification_VariableCharacterisation();
                AbstractNamedReference namedReference = variableCharacterisation.getVariableUsage_VariableCharacterisation().getNamedReference__VariableUsage();
                String id = String.valueOf(((StringBuilder)new StoExPrettyPrintVisitor().doSwitch((EObject)namedReference)).toString()) + "." + variableCharacterisation.getType().getLiteral();
                if (SimulatedStackHelper.isInnerReference(namedReference)) {
                    targetStackFrame.addValue(id, (Object)new EvaluationProxy(randomVariable.getSpecification(), contextStackFrame.copyFrame()));
                } else {
                    targetStackFrame.addValue(id, StackContext.evaluateStatic((String)randomVariable.getSpecification(), contextStackFrame));
                }
                if (!LOGGER.isDebugEnabled()) continue;
                try {
                    LOGGER.debug((Object)("Added value " + targetStackFrame.getValue(id) + " for id " + id + " to stackframe " + targetStackFrame));
                }
                catch (ValueNotInFrameException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static boolean isInnerReference(AbstractNamedReference reference) {
        return (Boolean)new StoexSwitch<Boolean>(){

            public Boolean caseVariableReference(VariableReference object) {
                return object.getReferenceName().equals("INNER");
            }

            public Boolean caseNamespaceReference(NamespaceReference object) {
                if (!object.getReferenceName().equals("INNER") && !((Boolean)this.doSwitch((EObject)object.getInnerReference_NamespaceReference())).booleanValue()) {
                    return false;
                }
                return true;
            }
        }.doSwitch((EObject)reference);
    }

    public static final SimulatedStackframe<Object> createAndPushNewStackFrame(SimulatedStack<Object> stack, EList<VariableUsage> parameter) {
        return SimulatedStackHelper.createAndPushNewStackFrame(stack, parameter, null);
    }

    public static final SimulatedStackframe<Object> createAndPushNewStackFrame(SimulatedStack<Object> stack, EList<VariableUsage> parameter, SimulatedStackframe<Object> parent) {
        SimulatedStackframe stackFrame = parent == null ? new SimulatedStackframe() : new SimulatedStackframe(parent);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added new stack frame: " + stackFrame));
        }
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe<Object>)(stack.size() == 0 ? null : stack.currentStackFrame()), parameter, (SimulatedStackframe<Object>)stackFrame);
        stack.pushStackFrame(stackFrame);
        return stackFrame;
    }
}

