/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.interpreter;

import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.OpenWorkloadUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.simulizar.action.core.AbstractAdaptationBehavior;
import org.palladiosimulator.simulizar.action.core.AdaptationAction;
import org.palladiosimulator.simulizar.action.core.AdaptationBehavior;
import org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository;
import org.palladiosimulator.simulizar.action.core.ControllerCall;
import org.palladiosimulator.simulizar.action.core.EnactAdaptationAction;
import org.palladiosimulator.simulizar.action.core.GuardedAction;
import org.palladiosimulator.simulizar.action.core.GuardedTransition;
import org.palladiosimulator.simulizar.action.core.NestedAdaptationBehavior;
import org.palladiosimulator.simulizar.action.core.ResourceDemandingAction;
import org.palladiosimulator.simulizar.action.core.StateTransformingAction;
import org.palladiosimulator.simulizar.action.core.util.CoreSwitch;
import org.palladiosimulator.simulizar.action.instance.RoleSet;
import org.palladiosimulator.simulizar.action.interpreter.AbstractStateTransformation;
import org.palladiosimulator.simulizar.action.interpreter.TransientEffectQVTOExecutor;
import org.palladiosimulator.simulizar.action.interpreter.TransientEffectQVTOExecutorUtil;
import org.palladiosimulator.simulizar.action.interpreter.notifications.AdaptationActionExecutedNotification;
import org.palladiosimulator.simulizar.action.interpreter.notifications.AdaptationBehaviorExecutedNotification;
import org.palladiosimulator.simulizar.action.mapping.ControllerMapping;
import org.palladiosimulator.simulizar.action.mapping.Mapping;
import org.palladiosimulator.simulizar.action.parameter.ControllerCallInputVariableUsage;
import org.palladiosimulator.simulizar.action.parameter.ControllerCallInputVariableUsageCollection;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.UsageScenarioSwitch;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcess;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class TransientEffectInterpreter
extends CoreSwitch<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(TransientEffectInterpreter.class);
    private static final String STATE_TRANSFORMING_EXT_POINT_ID = "org.palladiosimulator.simulizar.action.stratetransformation";
    private static final String STATE_TRANSFORMING_CLASS_NAME = "class";
    private final SimuLizarRuntimeState state;
    private final ReconfigurationProcess associatedReconfigurationProcess;
    private final RoleSet roleSet;
    private final Map<ControllerCall, List<VariableUsage>> inputVariableUsagesPerControllerCall;
    private final TransientEffectQVTOExecutor qvtoExecutor;
    private final QVToModelCache availableModels;
    private final boolean isAsync;
    private SimuComSimProcess executingProcess;

    TransientEffectInterpreter(SimuLizarRuntimeState state, RoleSet set, ControllerCallInputVariableUsageCollection controllerCallsInputVariableUsages, AdaptationBehaviorRepository repository, boolean executeAsync) {
        this.state = state;
        this.associatedReconfigurationProcess = this.state.getReconfigurator().getReconfigurationProcess();
        this.roleSet = set;
        this.isAsync = executeAsync;
        this.inputVariableUsagesPerControllerCall = controllerCallsInputVariableUsages.getControllerCallInputVariableUsages().stream().collect(Collectors.groupingBy(ControllerCallInputVariableUsage::getCorrespondingControllerCall, Collectors.mapping(ControllerCallInputVariableUsage::getVariableUsage, Collectors.toList())));
        this.availableModels = new QVToModelCache(Objects.requireNonNull(this.state.getModelAccess()));
        this.availableModels.storeModel((EObject)this.roleSet);
        this.qvtoExecutor = new TransientEffectQVTOExecutor(this.availableModels.snapshot());
        this.executingProcess = this.associatedReconfigurationProcess;
    }

    private void spawnAsyncInterpreterProcess(final AdaptationBehavior behaviorToInterpret) {
        SimuComSimProcess asyncInterpreter = new SimuComSimProcess(this.state.getModel(), "Async Transient Effect Interpreter", this.associatedReconfigurationProcess.getRequestContext()){

            protected void internalLifeCycle() {
                LOGGER.info((Object)"Async execution of adaptation behavior is taking place.");
                TransientEffectInterpreter.this.executingProcess = this;
                TransientEffectInterpreter.this.executeAdaptationActions(behaviorToInterpret.getAdaptationActions());
                LOGGER.info((Object)"Async execution of adaptation behavior done.");
                TransientEffectInterpreter.this.executingProcess = (SimuComSimProcess)TransientEffectInterpreter.this.associatedReconfigurationProcess;
            }
        };
        asyncInterpreter.scheduleAt(0.0);
    }

    @Override
    public Boolean caseAdaptationBehavior(AdaptationBehavior adaptationBehavior) {
        boolean successful = true;
        if (this.isAsync) {
            this.spawnAsyncInterpreterProcess(adaptationBehavior);
            LOGGER.info((Object)"Spawned and scheduled process for async interpretation of adaptation behavior.");
        } else {
            successful = this.executeAdaptationActions((Collection<AdaptationAction>)adaptationBehavior.getAdaptationActions());
            if (successful) {
                this.forwardReconfigurationNotification((Notification)new AdaptationBehaviorExecutedNotification(adaptationBehavior));
            }
        }
        return successful;
    }

    @Override
    public Boolean caseNestedAdaptationBehavior(NestedAdaptationBehavior nestedAdaptationBehavior) {
        return this.executeAdaptationActions((Collection<AdaptationAction>)nestedAdaptationBehavior.getAdaptationActions());
    }

    private Boolean executeAdaptationActions(Collection<AdaptationAction> adaptationActions) {
        assert (adaptationActions != null);
        return adaptationActions.stream().reduce(true, (result, action) -> (Boolean)this.doSwitch((EObject)action), Boolean::logicalAnd);
    }

    @Override
    public Boolean caseGuardedTransition(GuardedTransition guardedTransition) {
        this.qvtoExecutor.enableForTransformationExecution(guardedTransition);
        TransientEffectQVTOExecutorUtil.validateGuardedTransition(this.qvtoExecutor, guardedTransition);
        return this.qvtoExecutor.executeGuardedTransition(guardedTransition);
    }

    @Override
    public Boolean caseGuardedAction(GuardedAction guardedAction) {
        Optional<NestedAdaptationBehavior> branchToExecute = guardedAction.getGuardedTransitions().stream().filter(this::caseGuardedTransition).findFirst().map(GuardedTransition::getNestedAdaptationBehavior);
        return branchToExecute.map(arg_0 -> ((TransientEffectInterpreter)this).doSwitch(arg_0)).orElse(false);
    }

    @Override
    public Boolean caseStateTransformingAction(StateTransformingAction stateTransformingAction) {
        this.qvtoExecutor.enableForTransformationExecution(stateTransformingAction);
        String extensionId = stateTransformingAction.getId();
        AbstractStateTransformation transformation = TransientEffectInterpreter.getStateTransformation(extensionId);
        transformation.setSimulationState(this.state);
        return transformation.execute(this.roleSet);
    }

    private static AbstractStateTransformation getStateTransformation(String extensionId) {
        Optional<IExtension> stateTransformingExtension = Arrays.stream(Platform.getExtensionRegistry().getExtensionPoint(STATE_TRANSFORMING_EXT_POINT_ID).getExtensions()).filter(extension -> extension.getUniqueIdentifier().equals(extensionId)).findAny();
        IExtension extension2 = stateTransformingExtension.orElseThrow(() -> new IllegalStateException("No state transformation registered for State Transforming Step " + extensionId));
        IConfigurationElement[] iConfigurationElementArray = extension2.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                return (AbstractStateTransformation)element.createExecutableExtension(STATE_TRANSFORMING_CLASS_NAME);
            }
            catch (CoreException e) {
                LOGGER.error((Object)e.getStackTrace());
                ++n2;
            }
        }
        throw new IllegalStateException("No state transformation registered for State Transforming Step " + extensionId);
    }

    @Override
    public Boolean caseAbstractAdaptationBehavior(AbstractAdaptationBehavior abstractAdaptationBehavior) {
        throw new AssertionError((Object)"AbstractAdaptationBehavior is abstract, this case should not be reached at all!");
    }

    @Override
    public Boolean caseAdaptationAction(AdaptationAction step) {
        throw new AssertionError((Object)"AdaptationAction is abstract, this case should not be reached at all!");
    }

    @Override
    public Boolean caseResourceDemandingAction(ResourceDemandingAction resourceDemandingAction) {
        this.qvtoExecutor.enableForTransformationExecution(resourceDemandingAction);
        Mapping mapping = this.executeResourceDemandingAction(resourceDemandingAction).orElseThrow(() -> new RuntimeException("Controller Completion transformation failed!"));
        LinkedList<OpenWorkloadUser> users = new LinkedList<OpenWorkloadUser>();
        SimuComModel model = this.state.getMainContext().getModel();
        for (ControllerMapping controllerMapping : mapping.getControllerMappings()) {
            ControllerCall call = controllerMapping.getMappedCall();
            List<Probe> usageStartStopProbes = Collections.unmodifiableList(Arrays.asList(new TakeCurrentSimulationTimeProbe(model.getSimulationControl()), new TakeCurrentSimulationTimeProbe(model.getSimulationControl())));
            OpenWorkloadUser user = new OpenWorkloadUser(model, String.valueOf(resourceDemandingAction.getEntityName()) + " " + call.getEntityName(), this.createAndScheduleControllerScenarioRunner(controllerMapping), usageStartStopProbes);
            users.add(user);
            user.startUserLife();
        }
        while (this.checkIfUsersRun(users)) {
            this.executingProcess.passivate();
        }
        return true;
    }

    @Override
    public Boolean caseEnactAdaptationAction(EnactAdaptationAction enactAdaptationAction) {
        this.qvtoExecutor.enableForTransformationExecution(enactAdaptationAction);
        TransientEffectQVTOExecutorUtil.validateEnactAdaptationStep(this.qvtoExecutor, enactAdaptationAction);
        boolean result = this.qvtoExecutor.executeTransformation(enactAdaptationAction.getAdaptationStepURI());
        if (result && !this.isAsync) {
            this.forwardReconfigurationNotification((Notification)new AdaptationActionExecutedNotification(enactAdaptationAction));
        }
        return result;
    }

    private IScenarioRunner createAndScheduleControllerScenarioRunner(ControllerMapping controllerMapping) {
        ControllerCall mappedCall = controllerMapping.getMappedCall();
        Collection variableUsages = this.inputVariableUsagesPerControllerCall.getOrDefault(mappedCall, Collections.emptyList());
        return process -> {
            LOGGER.info((Object)("Start executing the controller scenario ('" + mappedCall.getEntityName() + "')!"));
            InterpreterDefaultContext newContext = new InterpreterDefaultContext(this.state.getMainContext(), process);
            UsageScenario usageScenario = UsagemodelFactory.eINSTANCE.createUsageScenario();
            ScenarioBehaviour behaviour = UsagemodelFactory.eINSTANCE.createScenarioBehaviour();
            usageScenario.setScenarioBehaviour_UsageScenario(behaviour);
            EList actions = behaviour.getActions_ScenarioBehaviour();
            Start start = UsagemodelFactory.eINSTANCE.createStart();
            EntryLevelSystemCall sysCall = UsagemodelFactory.eINSTANCE.createEntryLevelSystemCall();
            Stop stop = UsagemodelFactory.eINSTANCE.createStop();
            actions.add(start);
            actions.add(sysCall);
            actions.add(stop);
            sysCall.setOperationSignature__EntryLevelSystemCall(mappedCall.getCalledSignature());
            sysCall.setProvidedRole_EntryLevelSystemCall(controllerMapping.getControllerRole());
            sysCall.getInputParameterUsages_EntryLevelSystemCall().addAll(variableUsages);
            start.setSuccessor((AbstractUserAction)sysCall);
            sysCall.setSuccessor((AbstractUserAction)stop);
            new UsageScenarioSwitch(newContext).doSwitch((EObject)usageScenario);
            this.executingProcess.scheduleAt(0.0);
            LOGGER.info((Object)("Execution of the controller scenario ('" + mappedCall.getEntityName() + "') finished!"));
        };
    }

    private boolean checkIfUsersRun(Collection<OpenWorkloadUser> users) {
        return users.stream().anyMatch(u -> !u.isTerminated());
    }

    private Optional<Mapping> executeResourceDemandingAction(ResourceDemandingAction resourceDemandingAction) {
        assert (resourceDemandingAction != null);
        Repository repository = ((ControllerCall)resourceDemandingAction.getControllerCalls().get(0)).getComponent().getRepository__RepositoryComponent();
        TransientEffectQVTOExecutorUtil.validateResourceDemandingAction(this.qvtoExecutor, resourceDemandingAction);
        return this.qvtoExecutor.executeControllerCompletion(repository, resourceDemandingAction.getControllerCompletionURI());
    }

    private void forwardReconfigurationNotification(Notification notification) {
        this.associatedReconfigurationProcess.appendReconfigurationNotification(notification);
    }
}

