/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.simulizar.action.core.EnactAdaptationAction;
import org.palladiosimulator.simulizar.action.core.GuardedTransition;
import org.palladiosimulator.simulizar.action.core.ResourceDemandingAction;
import org.palladiosimulator.simulizar.action.core.StateTransformingAction;
import org.palladiosimulator.simulizar.action.mapping.Mapping;
import org.palladiosimulator.simulizar.action.mapping.MappingPackage;
import org.palladiosimulator.simulizar.reconfiguration.qvto.AbstractQVTOExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationData;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.TransformationParameterInformation;

class TransientEffectQVTOExecutor
extends AbstractQVTOExecutor {
    private static final EPackage MAPPING_EPACKAGE = MappingPackage.Literals.MAPPING.getEPackage();
    private static final EPackage REPOSITORY_EPACKAGE = RepositoryPackage.Literals.REPOSITORY.getEPackage();
    private final Collection<ModelExtent> currentPureOutParams = new ArrayList<ModelExtent>();

    protected TransientEffectQVTOExecutor(QVToModelCache availableModels) {
        super(new TransformationCache(new URI[0]), Objects.requireNonNull(availableModels));
    }

    boolean executeTransformation(String uriString) {
        return this.executeTransformation(URI.createURI((String)Objects.requireNonNull(uriString)));
    }

    Optional<Mapping> executeControllerCompletion(Repository controllerCompletionRepository, String controllerCompletionPath) {
        Optional<EObject> cachedRepo = this.getModelByType(REPOSITORY_EPACKAGE);
        this.storeModel((EObject)controllerCompletionRepository);
        URI controllerCompletionUri = URI.createURI((String)controllerCompletionPath);
        boolean result = this.executeTransformation(controllerCompletionUri);
        cachedRepo.ifPresent(repoInCache -> this.storeModel((EObject)repoInCache));
        if (result) {
            return this.getModelByType(MAPPING_EPACKAGE).map(obj -> (Mapping)obj);
        }
        return Optional.empty();
    }

    boolean executeGuardedTransition(GuardedTransition guardedTransition) {
        return this.executeTransformation(Objects.requireNonNull(guardedTransition).getConditionURI());
    }

    private void storeModel(EObject model) {
        this.getAvailableModels().storeModel(model);
    }

    private void prepareTransformation(String transformationUri) {
        assert (transformationUri != null);
        URI uri = URI.createURI((String)Objects.requireNonNull(transformationUri));
        if (!this.getAvailableTransformations().contains(uri)) {
            this.getAvailableTransformations().store(new URI[]{uri});
        }
    }

    void enableForTransformationExecution(EnactAdaptationAction enactAdaptationAction) {
        this.storeModel(Objects.requireNonNull(enactAdaptationAction));
        this.prepareTransformation(enactAdaptationAction.getAdaptationStepURI());
    }

    void enableForTransformationExecution(ResourceDemandingAction resourceDemandingAction) {
        this.storeModel(Objects.requireNonNull(resourceDemandingAction));
        this.prepareTransformation(resourceDemandingAction.getControllerCompletionURI());
    }

    void enableForTransformationExecution(StateTransformingAction stateTransformingAction) {
        this.storeModel(Objects.requireNonNull(stateTransformingAction));
    }

    void enableForTransformationExecution(GuardedTransition guardedTransition) {
        this.prepareTransformation(Objects.requireNonNull(guardedTransition).getConditionURI());
    }

    Optional<TransformationData> getTransformationByUri(URI transformationId) {
        return this.getAvailableTransformations().get(Objects.requireNonNull(transformationId));
    }

    Optional<EObject> getModelByType(EPackage modelType) {
        return this.getAvailableModels().getModelByType(Objects.requireNonNull(modelType));
    }

    protected boolean handleExecutionResult(ExecutionDiagnostic executionResult) {
        boolean result = super.handleExecutionResult(executionResult);
        if (result) {
            this.currentPureOutParams.stream().map(ModelExtent::getContents).filter(contents -> !contents.isEmpty()).map(contents -> (EObject)contents.get(0)).forEach(arg_0 -> ((QVToModelCache)this.getAvailableModels()).storeModel(arg_0));
        }
        return result;
    }

    protected ModelExtent[] setupModelExtents(TransformationData data) {
        this.currentPureOutParams.clear();
        ModelExtent[] result = super.setupModelExtents(data);
        data.getPureOutParameters().stream().mapToInt(TransformationParameterInformation::getParameterIndex).mapToObj(index -> result[index]).forEach(this.currentPureOutParams::add);
        return result;
    }
}

