/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.henshin;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.henshin.modelaccess.HenshinModelAccess;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class HenshinReconfigurator
extends AbstractReconfigurator {
    private HenshinModelAccess modelAccess;
    private List<Module> modules;
    private SimuLizarWorkflowConfiguration configuration;
    private static final Logger LOGGER = Logger.getLogger(HenshinReconfigurator.class);

    public void setModelAccess(IModelAccess modelAccess) {
        this.modelAccess = new HenshinModelAccess(modelAccess, this.configuration);
        this.modules = this.modelAccess.getHenshinRules();
    }

    public void setConfiguration(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    private boolean executeReconfiguration(UnitApplication app, Module module) {
        LOGGER.info((Object)"Called Henshin reconfiguration engine.");
        EGraphImpl graph = new EGraphImpl((EObject)this.modelAccess.getGlobalPCMModel().getAllocation());
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("execute"));
        if (app.execute(null)) {
            LOGGER.debug((Object)"Successfully executed Henshin rule.");
            return true;
        }
        LOGGER.debug((Object)"Executing Henshin rule failed.");
        return false;
    }

    private boolean analyzeReconfiguration(UnitApplication app, Module module) {
        EGraphImpl graph = new EGraphImpl((EObject)this.modelAccess.getRuntimeMeasurementModel());
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("analyze"));
        if (app.execute(null)) {
            LOGGER.debug((Object)"Found matching Henshin rule.");
            return true;
        }
        LOGGER.debug((Object)"No matching Henshin rule found.");
        return false;
    }

    public boolean checkAndExecute(EObject measuringPoint) {
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine);
        boolean result = false;
        if (!this.modules.isEmpty()) {
            for (Module module : this.modules) {
                if (!this.analyzeReconfiguration((UnitApplication)app, module)) continue;
                result |= this.executeReconfiguration((UnitApplication)app, module);
            }
        }
        return result;
    }
}

