/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.henshin.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.simulizar.reconfiguration.henshin.modelaccess.HenshinResourceSetPartition;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.utils.FileUtil;

public class LoadHenshinModelsIntoBlackboardJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final String HENSHIN_FILE_EXTENSION = ".henshin";
    public static final String HENSHIN_MODEL_PARTITION_ID = "org.palladiosimulator.simulizar.reconfiguration.henshin";
    private static final Logger LOGGER = Logger.getLogger(LoadHenshinModelsIntoBlackboardJob.class);
    private MDSDBlackboard blackboard;
    private final String path;

    public LoadHenshinModelsIntoBlackboardJob(SimuLizarWorkflowConfiguration configuration, MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
        this.path = configuration.getReconfigurationRulesFolder();
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    private MDSDBlackboard getBlackboard() {
        return this.blackboard;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        HenshinResourceSetPartition henshinPartition = new HenshinResourceSetPartition();
        this.getBlackboard().addPartition(HENSHIN_MODEL_PARTITION_ID, (Object)henshinPartition);
        if (this.path != null && !this.path.equals("")) {
            String filePath = this.path;
            File folder = null;
            if (!this.path.startsWith("platform:")) {
                filePath = "file:///" + filePath;
                URI pathToSDM = URI.createURI((String)filePath);
                folder = new File(pathToSDM.toFileString());
            } else {
                String folderString = "";
                try {
                    URL pathURL = FileLocator.resolve((URL)new URL(this.path));
                    folderString = pathURL.toExternalForm().replace("file:", "");
                    folder = new File(folderString);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Folder " + folderString + " cannot be accessed."), (Throwable)e);
                    return;
                }
            }
            if (!folder.exists()) {
                LOGGER.warn((Object)("Folder " + folder + " does not exist. No reconfiguration rules will be loaded."));
                return;
            }
            File[] files = FileUtil.getFiles((File)folder, (String)HENSHIN_FILE_EXTENSION);
            if (files != null && files.length > 0) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    henshinPartition.loadModel(URI.createFileURI((String)file.getPath()));
                    ++n2;
                }
            } else {
                LOGGER.info((Object)"No Henshin reconfiguration rules found. Henshin reconfiguration engine disabled.");
            }
        }
    }

    public String getName() {
        return "Load Henshin reconfiguration rules";
    }
}

