/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.henshin.modelaccess;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.model.Module;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.henshin.jobs.LoadHenshinModelsIntoBlackboardJob;
import org.palladiosimulator.simulizar.reconfiguration.henshin.modelaccess.HenshinResourceSetPartition;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.scaledl.usageevolution.UsageEvolution;

public class HenshinModelAccess
implements IModelAccess {
    private static final Logger LOGGER = Logger.getLogger(HenshinModelAccess.class);
    private final HenshinResourceSetPartition henshinPartition;
    private final IModelAccess modelAccess;

    public HenshinModelAccess(IModelAccess modelAccess, SimuLizarWorkflowConfiguration configuration) {
        this.modelAccess = modelAccess;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            new LoadHenshinModelsIntoBlackboardJob(configuration, modelAccess.getBlackboard()).execute((IProgressMonitor)monitor);
        }
        catch (JobFailedException e) {
            LOGGER.error((Object)"Failed loading StoryDiagram reconfiguration rules into Blackboard.", (Throwable)e);
        }
        catch (UserCanceledException e) {
            LOGGER.error((Object)"Loading StoryDiagram reconfiguration rules into Blackboard was aborted.", (Throwable)e);
        }
        this.henshinPartition = (HenshinResourceSetPartition)((Object)this.getResourceSetPartition(modelAccess.getBlackboard(), "org.palladiosimulator.simulizar.reconfiguration.henshin"));
    }

    public List<Module> getHenshinRules() {
        if (this.henshinPartition != null) {
            return this.henshinPartition.getModules();
        }
        return new LinkedList<Module>();
    }

    private <T extends ResourceSetPartition> T getResourceSetPartition(MDSDBlackboard blackboard, String id) {
        return (T)((ResourceSetPartition)blackboard.getPartition(id));
    }

    public boolean sdmModelsExists() {
        return this.henshinPartition.getResourceSet().getResources().size() > 0;
    }

    public PCMResourceSetPartition getLocalPCMModel() {
        return this.modelAccess.getLocalPCMModel();
    }

    public PCMResourceSetPartition getGlobalPCMModel() {
        return this.modelAccess.getGlobalPCMModel();
    }

    public MonitorRepository getMonitorRepositoryModel() {
        return this.modelAccess.getMonitorRepositoryModel();
    }

    public RuntimeMeasurementModel getRuntimeMeasurementModel() {
        return this.modelAccess.getRuntimeMeasurementModel();
    }

    public UsageEvolution getUsageEvolutionModel() {
        return this.modelAccess.getUsageEvolutionModel();
    }

    public IModelAccess clone() {
        return this.modelAccess.clone();
    }

    public MDSDBlackboard getBlackboard() {
        return this.modelAccess.getBlackboard();
    }
}

