/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.tests;

import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.monitorrepository.StatisticalCharacterizationEnum;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.util.AllocationResourceFactoryImpl;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.util.RepositoryResourceFactoryImpl;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.util.ResourceenvironmentResourceFactoryImpl;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.system.util.SystemResourceFactoryImpl;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurement;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementFactory;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.access.ModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurator;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class QVToReconfigurationTest {
    private static final String REPOSITORY_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.repository";
    private static final String RESOURCE_ENVIRONMENT_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.resourceenvironment";
    private static final String SYSTEM_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.system";
    private static final String ALLOCATION_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.allocation";
    private static final String PMS_MODEL_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.pms";
    private static final String TRANSFORMATION_RULES_ADD_DUPLICATED_SERVER_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/rules/addClonedServer";
    private static final String TRANSFORMATION_RULES_ADD_SERVER_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/rules/addNewServer";
    private static final String TRANSFORMATION_RULES_OUTSOURCE_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/rules/outsource";
    private static final String TRANSFORMATION_RULES_SCALE_UP_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/rules/scaleUp";
    private static final String ALLOCATION_FILE_CONFIGURATION_KEY = "allocationFile";
    private static final String REPOSITORY_EXTENSION = "repository";
    private static final String RESOURCE_ENVIRONMENT_EXTENSION = "resourceenvironment";
    private static final String SYSTEM_EXTENSION = "system";
    private static final String ALLOCATION_EXTENSION = "allocation";
    private static final String BRANCH_2_ENTITY_NAME = "branch2";
    private static final double BRANCH_2_EXPECTED_VALUE_AFTER_OUTSOURCING = 0.1;
    private static final double BRANCH_2_EXPECTED_VALUE_BEFORE_OUTSOURCING = 0.0;
    private static final double MEASUREMENT_BELOW_THRESHOLD = 1.0;
    private static final double MEASUREMENT_OVER_THRESHOLD = 5.0;
    private static final String SERVER_RESOURCE_CONTAINER_NAME = "server";
    private static final double SERVER_EXPECTED_PROCESSING_RATE_AFTER_SCALING = 1100.0;
    private static final double SERVER_EXPECTED_PROCESSING_RATE_BEFORE_SCALING = 1000.0;
    private static final int EXPECTED_NUMBER_OF_SERVERS_BEFORE_ADDING = 1;
    private static final int EXPECTED_NUMBER_OF_SERVERS_AFTER_ADDING = 2;
    private static URI systemURI;
    private static URI resourceEnvironmentURI;
    private static URI repositoryURI;
    private static URI allocationURI;
    private static URI pmsURI;

    @BeforeClass
    public static void setUpBeforeClass() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(REPOSITORY_EXTENSION, new RepositoryResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(RESOURCE_ENVIRONMENT_EXTENSION, new ResourceenvironmentResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(SYSTEM_EXTENSION, new SystemResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(ALLOCATION_EXTENSION, new AllocationResourceFactoryImpl());
        Map uriMap = URIConverter.URI_MAP;
        uriMap.put(URI.createURI((String)" pathmap://METRIC_SPEC_MODELS/commonMetrics.metricspec"), URI.createURI((String)"platform:/plugin/org.palladiosimulator.metricspec.resources/commonMetrics.metricspec"));
        repositoryURI = URI.createPlatformPluginURI((String)REPOSITORY_PATH, (boolean)true);
        repositoryURI = CommonPlugin.resolve((URI)repositoryURI);
        resourceEnvironmentURI = URI.createPlatformPluginURI((String)RESOURCE_ENVIRONMENT_PATH, (boolean)true);
        resourceEnvironmentURI = CommonPlugin.resolve((URI)resourceEnvironmentURI);
        systemURI = URI.createPlatformPluginURI((String)SYSTEM_PATH, (boolean)true);
        systemURI = CommonPlugin.resolve((URI)systemURI);
        allocationURI = URI.createPlatformPluginURI((String)ALLOCATION_PATH, (boolean)true);
        allocationURI = CommonPlugin.resolve((URI)allocationURI);
        pmsURI = URI.createPlatformPluginURI((String)PMS_MODEL_PATH, (boolean)true);
        pmsURI = CommonPlugin.resolve((URI)pmsURI);
    }

    @Test
    public void test() {
        this.reconfigurationTests();
    }

    private void reconfigurationTests() {
        Assert.assertEquals((String)"The branch probability was not changed as expected!", (double)0.1, (double)this.outsource(5.0), (double)0.0);
        Assert.assertEquals((String)"The branch probability has not remained as it was expected!", (double)0.0, (double)this.outsource(1.0), (double)0.0);
        Assert.assertEquals((String)"Processing resources have not scaled as expected!", (double)1100.0, (double)this.scaleUp(5.0), (double)0.0);
        Assert.assertEquals((String)"Processing resources have not remained as it was expected!", (double)1000.0, (double)this.scaleUp(1.0), (double)0.0);
        Assert.assertEquals((String)"The server was not added!", (double)2.0, (double)this.addNewServer(5.0), (double)0.0);
        Assert.assertEquals((String)"The number of servers is not as expected!", (double)1.0, (double)this.addNewServer(1.0), (double)0.0);
        Assert.assertEquals((String)"The server was not added!", (double)2.0, (double)this.addClonedServer(5.0), (double)0.0);
        Assert.assertEquals((String)"The number of servers is not as expected!", (double)1.0, (double)this.addClonedServer(1.0), (double)0.0);
    }

    private int addNewServer(double m) {
        PCMResourceSetPartition pcmResourceSet = this.readPcmModelAndApplyTransformationRules(m, TRANSFORMATION_RULES_ADD_SERVER_PATH);
        Allocation allocation = pcmResourceSet.getAllocation();
        int numOfServer1Client = 0;
        int numOfServer2Client = 0;
        for (Connector connector : allocation.getSystem_Allocation().getConnectors__ComposedStructure()) {
            if (!(connector instanceof AssemblyConnector)) continue;
            AssemblyConnector assemblyConnector = (AssemblyConnector)connector;
            AssemblyContext assemblyContextProviding = assemblyConnector.getProvidingAssemblyContext_AssemblyConnector();
            AssemblyContext assemblyContextRequiring = assemblyConnector.getRequiringAssemblyContext_AssemblyConnector();
            if (assemblyContextProviding.getEncapsulatedComponent__AssemblyContext().getEntityName().equals("server1") && assemblyContextRequiring.getEncapsulatedComponent__AssemblyContext().getEntityName().equals("client")) {
                ++numOfServer1Client;
            }
            if (!assemblyContextProviding.getEncapsulatedComponent__AssemblyContext().getEntityName().equals("server2") || !assemblyContextRequiring.getEncapsulatedComponent__AssemblyContext().getEntityName().equals("client")) continue;
            ++numOfServer2Client;
        }
        return numOfServer1Client + numOfServer2Client;
    }

    private int addClonedServer(double m) {
        PCMResourceSetPartition pcmResourceSet = this.readPcmModelAndApplyTransformationRules(m, TRANSFORMATION_RULES_ADD_DUPLICATED_SERVER_PATH);
        Allocation allocation = pcmResourceSet.getAllocation();
        int numOfIServerProviders = 0;
        for (Connector connector : allocation.getSystem_Allocation().getConnectors__ComposedStructure()) {
            if (!(connector instanceof AssemblyConnector)) continue;
            AssemblyConnector assemblyConnector = (AssemblyConnector)connector;
            AssemblyContext assemblyContextProviding = assemblyConnector.getProvidingAssemblyContext_AssemblyConnector();
            AssemblyContext assemblyContextRequiring = assemblyConnector.getRequiringAssemblyContext_AssemblyConnector();
            if (!assemblyContextProviding.getEncapsulatedComponent__AssemblyContext().getEntityName().equals("server1") || !assemblyContextRequiring.getEncapsulatedComponent__AssemblyContext().getEntityName().equals("client")) continue;
            ++numOfIServerProviders;
        }
        return numOfIServerProviders;
    }

    private double scaleUp(double m) {
        PCMResourceSetPartition pcmResourceSet = this.readPcmModelAndApplyTransformationRules(m, TRANSFORMATION_RULES_SCALE_UP_PATH);
        Allocation allocation = pcmResourceSet.getAllocation();
        ResourceEnvironment resourceEnvironment = allocation.getTargetResourceEnvironment_Allocation();
        for (ResourceContainer resourceContainer : resourceEnvironment.getResourceContainer_ResourceEnvironment()) {
            Iterator iteratorProcessingResourceSpecification;
            if (!resourceContainer.getEntityName().equals(SERVER_RESOURCE_CONTAINER_NAME) || !(iteratorProcessingResourceSpecification = resourceContainer.getActiveResourceSpecifications_ResourceContainer().iterator()).hasNext()) continue;
            ProcessingResourceSpecification processingResourceSpecification = (ProcessingResourceSpecification)iteratorProcessingResourceSpecification.next();
            return Double.parseDouble(processingResourceSpecification.getProcessingRate_ProcessingResourceSpecification().getSpecification());
        }
        Assert.assertTrue((String)"The test reached the end!", (boolean)false);
        return Double.NaN;
    }

    private double outsource(double m) {
        PCMResourceSetPartition pcmResourceSet = this.readPcmModelAndApplyTransformationRules(m, TRANSFORMATION_RULES_OUTSOURCE_PATH);
        TreeIterator pcmModelIterator = pcmResourceSet.getAllocation().eAllContents();
        while (pcmModelIterator.hasNext()) {
            AllocationContext serverAllocationContext;
            AssemblyContext serverAssemblyContext;
            EObject root = (EObject)pcmModelIterator.next();
            if (!(root instanceof AllocationContext) || !((serverAssemblyContext = (serverAllocationContext = (AllocationContext)root).getAssemblyContext_AllocationContext()).getEncapsulatedComponent__AssemblyContext() instanceof BasicComponent)) continue;
            BasicComponent serverBasicComponent = (BasicComponent)serverAssemblyContext.getEncapsulatedComponent__AssemblyContext();
            EList serverSeffs = serverBasicComponent.getServiceEffectSpecifications__BasicComponent();
            for (ServiceEffectSpecification seff : serverSeffs) {
                if (!(seff instanceof ResourceDemandingSEFF)) continue;
                TreeIterator seffIterator = seff.eAllContents();
                while (seffIterator.hasNext()) {
                    ProbabilisticBranchTransition branchTransition;
                    EObject seffObject = (EObject)seffIterator.next();
                    if (!(seffObject instanceof ProbabilisticBranchTransition) || !(branchTransition = (ProbabilisticBranchTransition)seffObject).getEntityName().equals(BRANCH_2_ENTITY_NAME)) continue;
                    return branchTransition.getBranchProbability();
                }
            }
        }
        Assert.assertTrue((String)"The test reached the end!", (boolean)false);
        return Double.NaN;
    }

    private PCMResourceSetPartition readPcmModelAndApplyTransformationRules(double m, String reconfigurationRulesFolderPath) {
        MeasurementSpecification measurementSpecification = MonitorRepositoryFactory.eINSTANCE.createMeasurementSpecification();
        measurementSpecification.setId("_sEx-cMLAEeSZr8oGpigbHA");
        measurementSpecification.setMetricDescription((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC);
        measurementSpecification.setStatisticalCharacterization(StatisticalCharacterizationEnum.ARITHMETIC_MEAN);
        measurementSpecification.setTemporalRestriction(null);
        RuntimeMeasurement responeTimeRuntimeMeasuremnt = RuntimeMeasurementFactory.eINSTANCE.createRuntimeMeasurement();
        responeTimeRuntimeMeasuremnt.setId("");
        responeTimeRuntimeMeasuremnt.setMeasuringValue(m);
        responeTimeRuntimeMeasuremnt.setMeasurementSpecification(measurementSpecification);
        URI reconfRulesURI = URI.createPlatformPluginURI((String)reconfigurationRulesFolderPath, (boolean)false);
        PCMResourceSetPartition pcmResourceSet = new PCMResourceSetPartition();
        pcmResourceSet.loadModel(repositoryURI);
        pcmResourceSet.loadModel(resourceEnvironmentURI);
        pcmResourceSet.loadModel(systemURI);
        pcmResourceSet.loadModel(allocationURI);
        TreeIterator pcmModelIterator = ((Repository)pcmResourceSet.getRepositories().get(0)).eAllContents();
        EObject monitoredElement = null;
        while (pcmModelIterator.hasNext()) {
            EAttribute id;
            EObject element = (EObject)pcmModelIterator.next();
            Object idAttribute = element.eGet((EStructuralFeature)(id = element.eClass().getEIDAttribute()));
            if (!idAttribute.toString().equals("_1P7G0LwGEeSxGbiYbg6Waw")) continue;
            monitoredElement = element;
        }
        MDSDBlackboard blackboard = new MDSDBlackboard();
        blackboard.addPartition("org.palladiosimulator.pcmmodels.partition", (Object)pcmResourceSet);
        ModelAccess modelAccess = new ModelAccess(blackboard);
        modelAccess.getRuntimeMeasurementModel().getMeasurements().add((Object)responeTimeRuntimeMeasuremnt);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put(ALLOCATION_FILE_CONFIGURATION_KEY, Paths.get(allocationURI.path(), new String[0]).toAbsolutePath().toString());
        SimuLizarWorkflowConfiguration swfc = new SimuLizarWorkflowConfiguration(configuration);
        swfc.setMonitorRepositoryFile(Paths.get(pmsURI.path(), new String[0]).toAbsolutePath().toString());
        swfc.setReconfigurationRulesFolder(reconfRulesURI.toString());
        QVTOReconfigurator reconfigurator = new QVTOReconfigurator((IModelAccess)modelAccess, swfc);
        reconfigurator.setConfiguration(swfc);
        reconfigurator.setModelAccess((IModelAccess)modelAccess);
        boolean checkedAndExceuted = reconfigurator.checkAndExecute(monitoredElement);
        Assert.assertTrue((String)"Reconfiguration was not executed!", (boolean)checkedAndExceuted);
        return pcmResourceSet;
    }
}

