/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.tests;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.repository.local.LocalDirectoryRepositoryHelper;
import org.palladiosimulator.pcm.allocation.util.AllocationResourceFactoryImpl;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.repository.util.RepositoryResourceFactoryImpl;
import org.palladiosimulator.pcm.resourceenvironment.util.ResourceenvironmentResourceFactoryImpl;
import org.palladiosimulator.pcm.resourcetype.ResourcetypePackage;
import org.palladiosimulator.pcm.resourcetype.util.ResourcetypeResourceFactoryImpl;
import org.palladiosimulator.pcm.system.util.SystemResourceFactoryImpl;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelResourceFactoryImpl;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.tests.jobs.MinimalPCMInterpreterRootCompositeJob;

public class SimulizarRunConfigTest {
    private static final String MODEL_FOLDER = "/org.palladiosimulator.simulizar.tests/testmodel";
    private static final String ALLOCATION_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.allocation";
    private static final String USAGE_MODEL_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/server.usagemodel";
    private static final String MONITOR_REPO_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/monitors/server.monitorrepository";
    private static final String RECONFIGURATION_RULES_FOLDER = "/org.palladiosimulator.simulizar.tests/testmodel/rules/";
    private static final String USAGE_EVOLUTION_MODEL_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/usageevolution/server.usageevolution";
    private static final String EMPTY_USAGE_EVOLUTION_MODEL_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/usageevolution/empty.usageevolution";
    private static final String SLO_REPO_PATH = "/org.palladiosimulator.simulizar.tests/testmodel/slo/server.slo";
    private static final String REPOSITORY_EXTENSION = "repository";
    private static final String RESOURCE_ENVIRONMENT_EXTENSION = "resourceenvironment";
    private static final String SYSTEM_EXTENSION = "system";
    private static final String ALLOCATION_EXTENSION = "allocation";
    private static final String RESOURCETYPE_EXTENSION = "resourcetype";
    private static final String USAGEMODEL_EXTENSION = "usagemodel";
    private static final String PALLADIO_RESOURCETYPES_PATHMAP = "pathmap://PCM_MODELS/Palladio.resourcetype";
    private static final String PALLADIO_RESOURCETYPES_PATHMAP_TARGET = "platform:/plugin/org.palladiosimulator.pcm.resources/defaultModels/Palladio.resourcetype";
    private static final String PRIMITIVE_TYPES_REPO_PATHMAP = "pathmap://PCM_MODELS/PrimitiveTypes.repository";
    private static final String PRIMITIVE_TYPES_REPO_PATHMAP_TARGET = "platform:/plugin/org.palladiosimulator.pcm.resources/defaultModels/PrimitiveTypes.repository";
    private SimuLizarWorkflowConfiguration simulizarConfiguration;
    private SequentialBlackboardInteractingJob<MDSDBlackboard> simulizarJob;
    private Repository repo = null;
    private static URI allocationUri;
    private static URI usageModelUri;
    private static URI monitorRepoUri;
    private static URI reconfigurationRulesUri;
    private static URI usageEvolutionModelUri;
    private static URI emptyUsageEvolutionModelUri;
    private static URI sloRepoUri;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @BeforeClass
    public static void setUpBeforeClass() {
        EPackage.Registry.INSTANCE.put((Object)"http://palladiosimulator.org/PalladioComponentModel/Repository/5.1", (Object)RepositoryPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://palladiosimulator.org/PalladioComponentModel/ResourceType/5.1", (Object)ResourcetypePackage.eINSTANCE);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(REPOSITORY_EXTENSION, new RepositoryResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(RESOURCE_ENVIRONMENT_EXTENSION, new ResourceenvironmentResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(SYSTEM_EXTENSION, new SystemResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(ALLOCATION_EXTENSION, new AllocationResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(RESOURCETYPE_EXTENSION, new ResourcetypeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(USAGEMODEL_EXTENSION, new UsagemodelResourceFactoryImpl());
        Map uriMap = URIConverter.URI_MAP;
        uriMap.put(URI.createURI((String)PALLADIO_RESOURCETYPES_PATHMAP), URI.createURI((String)PALLADIO_RESOURCETYPES_PATHMAP_TARGET));
        uriMap.put(URI.createURI((String)PRIMITIVE_TYPES_REPO_PATHMAP), URI.createURI((String)PRIMITIVE_TYPES_REPO_PATHMAP_TARGET));
        allocationUri = URI.createPlatformPluginURI((String)ALLOCATION_PATH, (boolean)true);
        usageModelUri = URI.createPlatformPluginURI((String)USAGE_MODEL_PATH, (boolean)true);
        monitorRepoUri = URI.createPlatformPluginURI((String)MONITOR_REPO_PATH, (boolean)true);
        reconfigurationRulesUri = URI.createPlatformPluginURI((String)RECONFIGURATION_RULES_FOLDER, (boolean)true);
        usageEvolutionModelUri = URI.createPlatformPluginURI((String)USAGE_EVOLUTION_MODEL_PATH, (boolean)true);
        emptyUsageEvolutionModelUri = URI.createPlatformPluginURI((String)EMPTY_USAGE_EVOLUTION_MODEL_PATH, (boolean)true);
        sloRepoUri = URI.createPlatformPluginURI((String)SLO_REPO_PATH, (boolean)true);
    }

    @Before
    public void setUp() throws IOException {
        this.repo = LocalDirectoryRepositoryHelper.initializeLocalDirectoryRepository((File)this.tempFolder.newFolder("testRepo"));
        RepositoryManager.addRepository((Repositories)RepositoryManager.getCentralRepository(), (Repository)this.repo);
        Map<String, Object> properties = this.createSimulationProperties();
        this.simulizarConfiguration = new SimuLizarWorkflowConfiguration(properties);
        this.simulizarConfiguration.setAllocationFiles(Arrays.asList(allocationUri.toString()));
        this.simulizarConfiguration.setUsageModelFile(usageModelUri.toString());
        this.simulizarConfiguration.setMonitorRepositoryFile("");
        this.simulizarConfiguration.setServiceLevelObjectivesFile("");
        this.simulizarConfiguration.setUsageEvolutionFile("");
        this.simulizarConfiguration.setSimuComConfiguration(new SimuComConfig(properties, false));
        MDSDBlackboard blackboard = new MDSDBlackboard();
        this.simulizarJob = new MinimalPCMInterpreterRootCompositeJob(this.simulizarConfiguration, blackboard);
    }

    @After
    public void tearDown() {
        RepositoryManager.removeRepository((Repositories)RepositoryManager.getCentralRepository(), (Repository)this.repo);
    }

    @Test
    public void testSuccessfulSimulationRunWithoutOptionalArguments() {
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithSLO() {
        this.simulizarConfiguration.setServiceLevelObjectivesFile(sloRepoUri.toString());
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithReconfigurationFolder() {
        this.simulizarConfiguration.setReconfigurationRulesFolder(reconfigurationRulesUri.toString());
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithEmptyReconfigurationFolder() throws IOException {
        File emptyRulesFolder = this.tempFolder.newFolder();
        this.simulizarConfiguration.setReconfigurationRulesFolder(emptyRulesFolder.toPath().normalize().toAbsolutePath().toString());
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithUsageEvolution() {
        this.simulizarConfiguration.setUsageEvolutionFile(usageEvolutionModelUri.toString());
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithUsageEvolutionNoParamEvolution() {
        this.simulizarConfiguration.setUsageEvolutionFile(emptyUsageEvolutionModelUri.toString());
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithMonitorRepository() {
        this.simulizarConfiguration.setMonitorRepositoryFile(monitorRepoUri.toString());
        this.runSuccessfulSimulation();
    }

    @Test
    public void testSuccessfulSimulationRunWithMonitorRepositoryAndReconfigurationFolder() {
        this.simulizarConfiguration.setReconfigurationRulesFolder(reconfigurationRulesUri.toString());
        this.simulizarConfiguration.setMonitorRepositoryFile(monitorRepoUri.toString());
        this.runSuccessfulSimulation();
    }

    private Map<String, Object> createSimulationProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("simulateFailures", false);
        properties.put("simulateLinkingResources", false);
        properties.put("useFixedSeed", false);
        properties.put("persistenceFramework", "Experiment Data Persistency & Presentation (EDP2)");
        properties.put("EDP2RepositoryID", this.repo.getId());
        properties.put("simulatorId", "de.uka.ipd.sdq.codegen.simucontroller.simulizar");
        properties.put("experimentRun", "MyRun");
        properties.put("simTime", "2000");
        properties.put("maximumMeasurementCount", "10000");
        properties.put("verboseLogging", false);
        properties.put("variationId", "Default Variation");
        properties.put("reconfigurationRulesFolder", "");
        properties.put("de.uka.ipd.sdq.workflowengine.debuglevel", "1");
        return properties;
    }

    private void runSuccessfulSimulation() {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        try {
            this.simulizarJob.execute((IProgressMonitor)progressMonitor);
        }
        catch (Throwable anyException) {
            SimulizarRunConfigTest.failDueToException(anyException);
        }
    }

    private static void failDueToException(Throwable unexpectedException) {
        Assert.fail((String)("Unexpected exception thrown by test case:\n---------------------\nType: " + unexpectedException + "\nStack Trace: " + SimulizarRunConfigTest.stacktraceToString(unexpectedException) + "\n---------------------"));
    }

    private static String stacktraceToString(Throwable exception) {
        StringBuilder result = new StringBuilder();
        if (exception.getStackTrace() != null) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                result.append(String.valueOf(element.toString()) + "\n");
                ++n2;
            }
        }
        return result.toString().trim();
    }
}

