/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.simulizar.interpreter.listener.EventType;
import org.palladiosimulator.simulizar.interpreter.listener.IInterpreterListener;
import org.palladiosimulator.simulizar.interpreter.listener.ModelElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.RDSEFFElementPassedEvent;

public class EventNotificationHelper
extends AbstractObservable<IInterpreterListener> {
    <T extends EObject> void firePassedEvent(ModelElementPassedEvent<T> event) {
        for (IInterpreterListener singleListener : this.getObservers()) {
            switch (event.getModelElement().eClass().getClassifierID()) {
                case 1: {
                    if (event.getEventType() == EventType.BEGIN) {
                        singleListener.beginUsageScenarioInterpretation(event);
                        break;
                    }
                    singleListener.endUsageScenarioInterpretation(event);
                    break;
                }
                case 4: {
                    if (event.getEventType() == EventType.BEGIN) {
                        singleListener.beginEntryLevelSystemCallInterpretation(event);
                        break;
                    }
                    singleListener.endEntryLevelSystemCallInterpretation(event);
                    break;
                }
                case 18: {
                    if (event.getEventType() == EventType.BEGIN) {
                        singleListener.beginSystemOperationCallInterpretation(event);
                        break;
                    }
                    singleListener.endSystemOperationCallInterpretation(event);
                    break;
                }
                case 17: {
                    if (event.getEventType() == EventType.BEGIN) {
                        singleListener.beginExternalCallInterpretation((RDSEFFElementPassedEvent)event);
                        break;
                    }
                    singleListener.endExternalCallInterpretation((RDSEFFElementPassedEvent)event);
                    break;
                }
                default: {
                    if (event.getEventType() == EventType.BEGIN) {
                        singleListener.beginUnknownElementInterpretation(event);
                        break;
                    }
                    singleListener.endUnknownElementInterpretation(event);
                }
            }
        }
    }

    public void removeAllListener() {
        this.removeAllObserver();
    }
}

