/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Stack;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class InterpreterDefaultContext
extends Context {
    private static final long serialVersionUID = -5027373777424401211L;
    private final Stack<AssemblyContext> assemblyContextStack = new Stack();
    private final SimuLizarRuntimeState runtimeState;
    private final IModelAccess modelAccess;

    public InterpreterDefaultContext(SimuLizarRuntimeState simulizarModel) {
        super(simulizarModel.getModel());
        this.stack = new SimulatedStack();
        this.runtimeState = simulizarModel;
        this.modelAccess = this.runtimeState.getModelAccess();
    }

    InterpreterDefaultContext(Context context, SimuLizarRuntimeState runtimeState, boolean copyStack) {
        super(context.getModel());
        this.modelAccess = runtimeState.getModelAccess().clone();
        this.setEvaluationMode(context.getEvaluationMode());
        this.setSimProcess(context.getThread());
        this.stack = new SimulatedStack();
        this.runtimeState = runtimeState;
        if (copyStack && context.getStack().size() > 0) {
            this.stack.pushStackFrame(context.getStack().currentStackFrame().copyFrame());
        } else {
            this.stack.pushStackFrame(new SimulatedStackframe());
        }
    }

    public InterpreterDefaultContext(InterpreterDefaultContext context, SimuComSimProcess thread) {
        this(context, context.getRuntimeState(), true);
        this.setSimProcess(thread);
    }

    public SimuLizarRuntimeState getRuntimeState() {
        return this.runtimeState;
    }

    protected void initialiseAssemblyContextLookup() {
    }

    public Stack<AssemblyContext> getAssemblyContextStack() {
        return this.assemblyContextStack;
    }

    public IModelAccess getModelAccess() {
        return this.modelAccess;
    }
}

