/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import de.uka.ipd.sdq.simucomframework.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.fork.ForkExecutor;
import de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.completions.DelegatingExternalCallAction;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.simulizar.exceptions.PCMModelAccessException;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.exceptions.SimulatedStackAccessException;
import org.palladiosimulator.simulizar.interpreter.ComposedStructureInnerSwitch;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.listener.EventType;
import org.palladiosimulator.simulizar.interpreter.listener.RDSEFFElementPassedEvent;
import org.palladiosimulator.simulizar.runtimestate.SimulatedBasicComponentInstance;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;
import org.palladiosimulator.simulizar.utils.TransitionDeterminer;

class RDSeffSwitch
extends SeffSwitch<Object> {
    private static final Boolean SUCCESS = true;
    private static final Logger LOGGER = Logger.getLogger(RDSeffSwitch.class);
    private final TransitionDeterminer transitionDeterminer;
    private final InterpreterDefaultContext context;
    private final Allocation allocation;
    private final SimulatedStackframe<Object> resultStackFrame;
    private final SimulatedBasicComponentInstance basicComponentInstance;

    public RDSeffSwitch(InterpreterDefaultContext context, SimulatedBasicComponentInstance basicComponentInstance) {
        this.context = context;
        this.allocation = context.getModelAccess().getLocalPCMModel().getAllocation();
        this.transitionDeterminer = new TransitionDeterminer(context);
        this.resultStackFrame = new SimulatedStackframe();
        this.basicComponentInstance = basicComponentInstance;
    }

    /*
     * Unable to fully structure code
     */
    public Object caseResourceDemandingBehaviour(ResourceDemandingBehaviour object) {
        stacksize = this.context.getStack().size();
        currentAction = null;
        for (AbstractAction abstractAction : object.getSteps_Behaviour()) {
            if (abstractAction.eClass() != SeffPackage.eINSTANCE.getStartAction()) continue;
            this.firePassedEvent(abstractAction, EventType.BEGIN);
            currentAction = abstractAction.getSuccessor_AbstractAction();
            this.firePassedEvent(abstractAction, EventType.END);
            break;
        }
        if (currentAction != null) ** GOTO lbl18
        throw new PCMModelInterpreterException("RDSEFF is invalid, it misses a start action");
lbl-1000:
        // 1 sources

        {
            if (RDSeffSwitch.LOGGER.isDebugEnabled()) {
                RDSeffSwitch.LOGGER.debug((Object)("Interpret " + currentAction.eClass().getName() + ": " + currentAction));
            }
            this.firePassedEvent(currentAction, EventType.BEGIN);
            this.doSwitch((EObject)currentAction);
            this.firePassedEvent(currentAction, EventType.END);
            currentAction = currentAction.getSuccessor_AbstractAction();
lbl18:
            // 2 sources

            ** while (currentAction.eClass() != SeffPackage.eINSTANCE.getStopAction())
        }
lbl19:
        // 1 sources

        if (this.context.getStack().size() != stacksize) {
            throw new PCMModelInterpreterException("Interpreter did not pop all pushed stackframes");
        }
        return this.resultStackFrame;
    }

    public SimulatedStackframe<Object> caseAbstractAction(AbstractAction object) {
        throw new UnsupportedOperationException("SEFF Interpreter tried to interpret unsupported action type: " + object.eClass().getName());
    }

    public Object caseInternalAction(InternalAction internalAction) {
        if (internalAction.getResourceDemand_Action().size() > 0) {
            this.interpretResourceDemands(internalAction);
        }
        if (internalAction.getInfrastructureCall__Action().size() > 0) {
            for (InfrastructureCall infrastructureCall : internalAction.getInfrastructureCall__Action()) {
                SimulatedStackframe currentStackFrame = this.context.getStack().currentStackFrame();
                int repetitions = (Integer)StackContext.evaluateStatic((String)infrastructureCall.getNumberOfCalls__InfrastructureCall().getSpecification(), Integer.class, (SimulatedStackframe)currentStackFrame);
                int i = 0;
                while (i < repetitions) {
                    ComposedStructureInnerSwitch composedStructureSwitch = new ComposedStructureInnerSwitch(this.context, (Signature)infrastructureCall.getSignature__InfrastructureCall(), (RequiredRole)infrastructureCall.getRequiredRole__InfrastructureCall());
                    SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)infrastructureCall.getInputVariableUsages__CallAction());
                    AssemblyContext myContext = this.context.getAssemblyContextStack().pop();
                    composedStructureSwitch.doSwitch((EObject)myContext);
                    this.context.getAssemblyContextStack().push(myContext);
                    this.context.getStack().removeStackFrame();
                    ++i;
                }
            }
        }
        if (internalAction.getInternalFailureOccurrenceDescriptions__InternalAction().size() > 0) {
            throw new UnsupportedOperationException("Simulation of failures not yet supported by Simulizar");
        }
        return SUCCESS;
    }

    public Object caseExternalCallAction(ExternalCallAction externalCall) {
        ComposedStructureInnerSwitch composedStructureSwitch = new ComposedStructureInnerSwitch(this.context, (Signature)externalCall.getCalledService_ExternalService(), (RequiredRole)externalCall.getRole_ExternalService());
        if (externalCall instanceof DelegatingExternalCallAction) {
            SimulatedStackframe currentFrame = this.context.getStack().currentStackFrame();
            SimulatedStackframe<Object> callFrame = SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)externalCall.getInputVariableUsages__CallAction(), (SimulatedStackframe<Object>)currentFrame);
            callFrame.addVariables(this.resultStackFrame);
        } else {
            SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)externalCall.getInputVariableUsages__CallAction());
        }
        AssemblyContext myContext = this.context.getAssemblyContextStack().pop();
        SimulatedStackframe outputFrame = (SimulatedStackframe)composedStructureSwitch.doSwitch((EObject)myContext);
        this.context.getAssemblyContextStack().push(myContext);
        this.context.getStack().removeStackFrame();
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe<Object>)outputFrame, (EList<VariableUsage>)externalCall.getReturnVariableUsage__CallReturnAction(), (SimulatedStackframe<Object>)this.context.getStack().currentStackFrame());
        return SUCCESS;
    }

    public Object caseBranchAction(BranchAction object) {
        AbstractBranchTransition branchTransition;
        EList abstractBranchTransitions = object.getBranches_Branch();
        if (abstractBranchTransitions.isEmpty()) {
            throw new PCMModelInterpreterException("Empty branch action is not allowed");
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Branch \"");
            sb.append(object.getEntityName());
            sb.append("\" [ID: ");
            sb.append(object.getId());
            sb.append("\"] with ");
            sb.append(object.getBranches_Branch().size());
            sb.append(" branches.");
            LOGGER.debug((Object)sb.toString());
        }
        if ((branchTransition = this.transitionDeterminer.determineTransition((EList<AbstractBranchTransition>)abstractBranchTransitions)) == null) {
            LOGGER.error((Object)("No branch's condition evaluated to true, no branch selected: " + object));
            throw new PCMModelInterpreterException("No branch transition was active. This is not allowed.");
        }
        this.doSwitch((EObject)branchTransition.getBranchBehaviour_BranchTransition());
        return SUCCESS;
    }

    public Object caseCollectionIteratorAction(CollectionIteratorAction object) {
        this.iterateOverCollection(object, object.getParameter_CollectionIteratorAction());
        return SUCCESS;
    }

    public Object caseForkAction(ForkAction object) {
        List<ForkedBehaviourProcess> asyncProcesses = this.getProcesses((List<ForkedBehaviour>)object.getAsynchronousForkedBehaviours_ForkAction(), true);
        List<ForkedBehaviourProcess> syncProcesses = this.determineSyncedProcesses(object);
        List<ForkedBehaviourProcess> combinedProcesses = this.combineProcesses(asyncProcesses, syncProcesses);
        ForkExecutor forkExecutor = new ForkExecutor(this.context.getThread(), combinedProcesses.toArray(new ForkedBehaviourProcess[0]));
        forkExecutor.run();
        return SUCCESS;
    }

    public Object caseLoopAction(LoopAction object) {
        PCMRandomVariable iterationCount = object.getIterationCount_LoopAction();
        String stoex = iterationCount.getSpecification();
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)stoex, Integer.class, (SimulatedStackframe)this.context.getStack().currentStackFrame());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Determined number of loops: " + numberOfLoops + " " + object));
        }
        this.interpretLoop(object, numberOfLoops);
        return SUCCESS;
    }

    public Object caseSetVariableAction(SetVariableAction object) {
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe<Object>)this.context.getStack().currentStackFrame(), (EList<VariableUsage>)object.getLocalVariableUsages_SetVariableAction(), this.resultStackFrame);
        return SUCCESS;
    }

    public Object caseAcquireAction(AcquireAction acquireAction) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process " + this.context.getThread().getId() + " tries to acquire " + acquireAction.getPassiveresource_AcquireAction().getEntityName()));
        }
        this.basicComponentInstance.acquirePassiveResource(acquireAction.getPassiveresource_AcquireAction(), this.context, this.context.getModel().getConfiguration().getSimulateFailures(), acquireAction.getTimeoutValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process " + this.context.getThread().getId() + " successfully acquired " + acquireAction.getPassiveresource_AcquireAction().getEntityName()));
        }
        return SUCCESS;
    }

    public Object caseReleaseAction(ReleaseAction releaseAction) {
        this.basicComponentInstance.releasePassiveResource(releaseAction.getPassiveResource_ReleaseAction(), this.context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process " + this.context.getThread().getId() + " released " + releaseAction.getPassiveResource_ReleaseAction().getEntityName()));
        }
        return SUCCESS;
    }

    private <T extends AbstractAction> void firePassedEvent(T abstractAction, EventType eventType) {
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new RDSEFFElementPassedEvent<T>(abstractAction, eventType, this.context.getThread(), this.context.getAssemblyContextStack().peek()));
    }

    private List<ForkedBehaviourProcess> combineProcesses(List<ForkedBehaviourProcess> asyncProcesses, List<ForkedBehaviourProcess> syncProcesses) {
        LinkedList<ForkedBehaviourProcess> combinedProcesses = new LinkedList<ForkedBehaviourProcess>();
        combinedProcesses.addAll(asyncProcesses);
        combinedProcesses.addAll(syncProcesses);
        return Collections.synchronizedList(combinedProcesses);
    }

    private List<ForkedBehaviourProcess> determineSyncedProcesses(ForkAction object) {
        List<ForkedBehaviourProcess> syncProcesses = new ArrayList<ForkedBehaviourProcess>();
        if (object.getSynchronisingBehaviours_ForkAction() != null) {
            syncProcesses = this.getProcesses((List<ForkedBehaviour>)object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint(), false);
        }
        return syncProcesses;
    }

    private List<ForkedBehaviourProcess> getProcesses(List<ForkedBehaviour> forkedBehaviours, boolean isAsync) {
        LinkedList<ForkedBehaviourProcess> processes = new LinkedList<ForkedBehaviourProcess>();
        for (final ForkedBehaviour forkedBehaviour : forkedBehaviours) {
            final Stack parentAssemblyContextStack = (Stack)this.context.getAssemblyContextStack().clone();
            processes.add(new ForkedBehaviourProcess(this.context, this.context.getAssemblyContextStack().peek().getId(), isAsync){

                protected void executeBehaviour() {
                    InterpreterDefaultContext seffContext = new InterpreterDefaultContext(this.myContext, RDSeffSwitch.this.context.getRuntimeState(), true);
                    seffContext.getAssemblyContextStack().addAll(parentAssemblyContextStack);
                    RDSeffSwitch seffInterpreter = new RDSeffSwitch(seffContext, RDSeffSwitch.this.basicComponentInstance);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Created new RDSeff interpreter for " + (this.isAsync() ? "asynced" : "synced") + " forked baviour: " + (Object)((Object)this)));
                    }
                    seffInterpreter.doSwitch((EObject)forkedBehaviour);
                }
            });
        }
        return processes;
    }

    private void interpretLoop(LoopAction object, int numberOfLoops) {
        int i = 0;
        while (i < numberOfLoops) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Interpret loop number " + i + ": " + object));
            }
            this.doSwitch((EObject)object.getBodyBehaviour_Loop());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Finished loop number " + i + ": " + object));
            }
            ++i;
        }
    }

    private void iterateOverCollection(CollectionIteratorAction object, Parameter parameter) {
        String idNumberOfLoops = String.valueOf(parameter.getParameterName()) + ".NUMBER_OF_ELEMENTS";
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)idNumberOfLoops, Integer.class, (SimulatedStackframe)this.context.getStack().currentStackFrame());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Determined number of loops: " + numberOfLoops + " " + object));
        }
        int i = 0;
        while (i < numberOfLoops) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Interpret loop number " + i + ": " + object));
            }
            SimulatedStackframe innerVariableStackFrame = this.context.getStack().createAndPushNewStackFrame(this.context.getStack().currentStackFrame());
            this.context.evaluateInner(innerVariableStackFrame, String.valueOf(parameter.getParameterName()) + ".");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Created new stackframe with evaluated inner collection variables: " + innerVariableStackFrame));
            }
            this.doSwitch((EObject)object.getBodyBehaviour_Loop());
            if (this.context.getStack().currentStackFrame() != innerVariableStackFrame) {
                throw new SimulatedStackAccessException("Inner value characterisations of inner collection variable expected");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Remove stack frame: " + innerVariableStackFrame));
            }
            this.context.getStack().removeStackFrame();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Finished loop number " + i + ": " + object));
            }
            ++i;
        }
    }

    private void interpretResourceDemands(InternalAction internalAction) {
        AllocationContext allocationContext = this.getAllocationContext(this.allocation);
        ResourceContainer resourceContainer = allocationContext.getResourceContainer_AllocationContext();
        for (ParametricResourceDemand parametricResourceDemand : internalAction.getResourceDemand_Action()) {
            ResourceRegistry resourceRegistry = this.context.getModel().getResourceRegistry();
            String idRequiredResourceType = parametricResourceDemand.getRequiredResource_ParametricResourceDemand().getId();
            String specification = parametricResourceDemand.getSpecification_ParametericResourceDemand().getSpecification();
            SimulatedStackframe currentStackFrame = this.context.getStack().currentStackFrame();
            Double value = (Double)StackContext.evaluateStatic((String)specification, Double.class, (SimulatedStackframe)currentStackFrame);
            resourceRegistry.getResourceContainer(resourceContainer.getId()).loadActiveResource(this.context.getThread(), idRequiredResourceType, value.doubleValue());
        }
    }

    private AllocationContext getAllocationContext(Allocation allocation) {
        for (AllocationContext allocationContext : allocation.getAllocationContexts_Allocation()) {
            ListIterator iterator = this.context.getAssemblyContextStack().listIterator(this.context.getAssemblyContextStack().size());
            while (iterator.hasPrevious()) {
                if (!allocationContext.getAssemblyContext_AllocationContext().getId().equals(((AssemblyContext)iterator.previous()).getId())) continue;
                return allocationContext;
            }
        }
        throw new PCMModelAccessException("No AllocationContext in Allocation " + allocation + " for AssemblyContext " + this.context.getAssemblyContextStack().peek() + " or its parents.");
    }
}

