/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.core.entity.EntityPackage;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.util.RepositorySwitch;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RDSeffSwitch;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.runtimestate.SimulatedBasicComponentInstance;
import org.palladiosimulator.simulizar.runtimestate.SimulatedCompositeComponentInstance;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;

class RepositoryComponentSwitch
extends RepositorySwitch<SimulatedStackframe<Object>> {
    private static final Logger LOGGER = Logger.getLogger(RepositoryComponentSwitch.class);
    public static final AssemblyContext SYSTEM_ASSEMBLY_CONTEXT = CompositionFactory.eINSTANCE.createAssemblyContext();
    private final Signature signature;
    private final ProvidedRole providedRole;
    private final InterpreterDefaultContext context;
    private final AssemblyContext instanceAssemblyContext;

    public RepositoryComponentSwitch(InterpreterDefaultContext context, AssemblyContext assemblyContext, Signature signature, ProvidedRole providedRole) {
        this.context = context;
        this.instanceAssemblyContext = assemblyContext;
        this.signature = signature;
        this.providedRole = providedRole;
    }

    public SimulatedStackframe<Object> caseBasicComponent(BasicComponent basicComponent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entering BasicComponent: " + basicComponent));
        }
        SimulatedStack stack = this.context.getStack();
        SimulatedStackframe<Object> componentParameterStackFrame = SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)stack, (EList<VariableUsage>)basicComponent.getComponentParameterUsage_ImplementationComponentType(), (SimulatedStackframe<Object>)stack.currentStackFrame());
        SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)stack, (EList<VariableUsage>)this.instanceAssemblyContext.getConfigParameterUsages__AssemblyContext(), componentParameterStackFrame);
        FQComponentID fqID = this.computeFQComponentID();
        if (!this.context.getRuntimeState().getComponentInstanceRegistry().hasComponentInstance(fqID)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Found new basic component component instance, registering it: " + basicComponent));
                LOGGER.debug((Object)("FQComponentID is " + fqID));
            }
            this.context.getRuntimeState().getComponentInstanceRegistry().addComponentInstance(new SimulatedBasicComponentInstance(this.context, fqID, (List<PassiveResource>)basicComponent.getPassiveResource_BasicComponent()));
        }
        List<ServiceEffectSpecification> calledSeffs = this.getSeffsForCall((EList<ServiceEffectSpecification>)basicComponent.getServiceEffectSpecifications__BasicComponent(), this.signature);
        SimulatedStackframe<Object> result = this.interpretSeffs(calledSeffs);
        stack.removeStackFrame();
        stack.removeStackFrame();
        return result;
    }

    public SimulatedStackframe<Object> caseComposedProvidingRequiringEntity(ComposedProvidingRequiringEntity entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entering ComposedProvidingRequiringEntity: " + entity));
        }
        FQComponentID fqID = this.computeFQComponentID();
        if (!this.context.getRuntimeState().getComponentInstanceRegistry().hasComponentInstance(fqID)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Found new composed component instance, registering it: " + entity));
                LOGGER.debug((Object)("FQComponentID is " + fqID));
            }
            this.context.getRuntimeState().getComponentInstanceRegistry().addComponentInstance(new SimulatedCompositeComponentInstance(this.context.getRuntimeState(), fqID));
        }
        if (entity != this.providedRole.getProvidingEntity_ProvidedRole()) {
            throw new PCMModelInterpreterException("Interpret entity of provided role only");
        }
        ProvidedDelegationConnector connectedProvidedDelegationConnector = RepositoryComponentSwitch.getConnectedProvidedDelegationConnector(this.providedRole);
        RepositoryComponentSwitch repositoryComponentSwitch = new RepositoryComponentSwitch(this.context, connectedProvidedDelegationConnector.getAssemblyContext_ProvidedDelegationConnector(), this.signature, (ProvidedRole)connectedProvidedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector());
        return (SimulatedStackframe)repositoryComponentSwitch.doSwitch((EObject)connectedProvidedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector());
    }

    public SimulatedStackframe<Object> caseProvidedRole(ProvidedRole providedRole) {
        this.context.getAssemblyContextStack().push(this.instanceAssemblyContext == SYSTEM_ASSEMBLY_CONTEXT ? this.generateSystemAssemblyContext(providedRole) : this.instanceAssemblyContext);
        SimulatedStackframe result = (SimulatedStackframe)this.doSwitch((EObject)providedRole.getProvidingEntity_ProvidedRole());
        this.context.getAssemblyContextStack().pop();
        return result;
    }

    private AssemblyContext generateSystemAssemblyContext(ProvidedRole providedRole2) {
        AssemblyContext result = CompositionFactory.eINSTANCE.createAssemblyContext();
        result.setEntityName(this.providedRole.getProvidingEntity_ProvidedRole().getEntityName());
        result.setId(SYSTEM_ASSEMBLY_CONTEXT.getId());
        return result;
    }

    private List<ServiceEffectSpecification> getSeffsForCall(EList<ServiceEffectSpecification> serviceEffectSpecifications, Signature operationSignature) {
        assert (serviceEffectSpecifications != null && operationSignature != null);
        return serviceEffectSpecifications.stream().filter(seff -> seff.getDescribedService__SEFF().getId().equals(operationSignature.getId())).collect(Collectors.toList());
    }

    private SimulatedStackframe<Object> interpretSeffs(List<ServiceEffectSpecification> calledSeffs) {
        if (calledSeffs.size() != 1) {
            throw new PCMModelInterpreterException("Only exactly one SEFF is currently supported.");
        }
        if (!(calledSeffs.get(0) instanceof ResourceDemandingSEFF)) {
            throw new PCMModelInterpreterException("Only ResourceDemandingSEFFs are currently supported.");
        }
        FQComponentID componentID = this.computeFQComponentID();
        SimulatedBasicComponentInstance basicComponentInstance = (SimulatedBasicComponentInstance)this.context.getRuntimeState().getComponentInstanceRegistry().getComponentInstance(componentID);
        RDSeffSwitch rdSeffInterpreter = new RDSeffSwitch(this.context, basicComponentInstance);
        return (SimulatedStackframe)rdSeffInterpreter.doSwitch((EObject)calledSeffs.get(0));
    }

    private FQComponentID computeFQComponentID() {
        return new FQComponentID(this.computeAssemblyContextPath());
    }

    private List<AssemblyContext> computeAssemblyContextPath() {
        Stack<AssemblyContext> stack = this.context.getAssemblyContextStack();
        ArrayList<AssemblyContext> result = new ArrayList<AssemblyContext>(stack.size());
        int i = 0;
        while (i < stack.size()) {
            result.add((AssemblyContext)stack.get(i));
            ++i;
        }
        return result;
    }

    private static ProvidedDelegationConnector getConnectedProvidedDelegationConnector(ProvidedRole providedRole) {
        InterfaceProvidingEntity implementingEntity = providedRole.getProvidingEntity_ProvidedRole();
        if (!CompositionPackage.eINSTANCE.getComposedStructure().isSuperTypeOf(implementingEntity.eClass())) {
            throw new PCMModelInterpreterException("Structure used for connector search must be a composed structure");
        }
        for (Connector connector : ((ComposedStructure)implementingEntity).getConnectors__ComposedStructure()) {
            if (connector.eClass() != CompositionPackage.eINSTANCE.getProvidedDelegationConnector() || !((ProvidedDelegationConnector)connector).getOuterProvidedRole_ProvidedDelegationConnector().equals(providedRole)) continue;
            return (ProvidedDelegationConnector)connector;
        }
        throw new PCMModelInterpreterException("Found unbound provided role. PCM model is invalid.");
    }

    protected SimulatedStackframe<Object> doSwitch(EClass theEClass, EObject theEObject) {
        if (EntityPackage.eINSTANCE.getComposedProvidingRequiringEntity().isSuperTypeOf(theEClass)) {
            return this.caseComposedProvidingRequiringEntity((ComposedProvidingRequiringEntity)theEObject);
        }
        return (SimulatedStackframe)super.doSwitch(theEClass, theEObject);
    }
}

