/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.listener;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.resources.CalculatorHelper;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.PredicateUtils;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.StatisticalCharacterizationEnum;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractInterpreterListener;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractRecordingProbeFrameworkListenerDecorator;
import org.palladiosimulator.simulizar.interpreter.listener.ModelElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.RDSEFFElementPassedEvent;
import org.palladiosimulator.simulizar.metrics.aggregators.ResponseTimeAggregator;
import org.palladiosimulator.simulizar.reconfiguration.Reconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.probes.TakeReconfigurationDurationProbe;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public class ProbeFrameworkListener
extends AbstractInterpreterListener {
    private static final Logger LOGGER = Logger.getLogger(ProbeFrameworkListener.class);
    private static final int START_PROBE_INDEX = 0;
    private static final int STOP_PROBE_INDEX = 1;
    private final SimuComModel simuComModel;
    private final ICalculatorFactory calculatorFactory;
    private final Reconfigurator reconfigurator;
    private final IModelAccess modelAccess;
    private final Map<String, List<TriggeredProbe>> currentTimeProbes = new HashMap<String, List<TriggeredProbe>>();

    public ProbeFrameworkListener(IModelAccess modelAccess, SimuComModel simuComModel, Reconfigurator reconfigurator) {
        this.modelAccess = modelAccess;
        this.calculatorFactory = simuComModel.getProbeFrameworkContext().getCalculatorFactory();
        this.simuComModel = simuComModel;
        this.reconfigurator = reconfigurator;
        this.initResponseTimeMeasurement();
        this.initReconfigurationTimeMeasurement();
        this.initExtensionMeasurements();
    }

    private void initExtensionMeasurements() {
        List extensions = ExtensionHelper.getExecutableExtensions((String)"org.palladiosimulator.simulizar.interpreter.listener.probeframework", (String)"decorator");
        for (AbstractRecordingProbeFrameworkListenerDecorator decorator : extensions) {
            decorator.setProbeFrameworkListener(this);
            decorator.registerMeasurements();
        }
    }

    @Override
    public void beginUsageScenarioInterpretation(ModelElementPassedEvent<UsageScenario> event) {
        this.startMeasurement(event);
    }

    @Override
    public void endUsageScenarioInterpretation(ModelElementPassedEvent<UsageScenario> event) {
        this.endMeasurement(event);
    }

    @Override
    public void beginEntryLevelSystemCallInterpretation(ModelElementPassedEvent<EntryLevelSystemCall> event) {
        this.startMeasurement(event);
    }

    @Override
    public void endEntryLevelSystemCallInterpretation(ModelElementPassedEvent<EntryLevelSystemCall> event) {
        this.endMeasurement(event);
    }

    @Override
    public void beginExternalCallInterpretation(RDSEFFElementPassedEvent<ExternalCallAction> event) {
        this.startMeasurement(event);
    }

    @Override
    public void endExternalCallInterpretation(RDSEFFElementPassedEvent<ExternalCallAction> event) {
        this.endMeasurement(event);
    }

    @Override
    public <T extends EObject> void beginUnknownElementInterpretation(ModelElementPassedEvent<T> event) {
    }

    @Override
    public <T extends EObject> void endUnknownElementInterpretation(ModelElementPassedEvent<T> event) {
    }

    public SimuComModel getSimuComModel() {
        return this.simuComModel;
    }

    public IModelAccess getModelAccess() {
        return this.modelAccess;
    }

    public RuntimeMeasurementModel getRuntimeMeasurementModel() {
        return this.modelAccess.getRuntimeMeasurementModel();
    }

    public ICalculatorFactory getCalculatorFactory() {
        return this.calculatorFactory;
    }

    public Collection<MeasurementSpecification> getMeasurementSpecificationsForMetricDescription(final MetricDescription soughtFor) {
        assert (soughtFor != null);
        MonitorRepository monitorRepositoryModel = this.modelAccess.getMonitorRepositoryModel();
        if (monitorRepositoryModel != null) {
            Transformer<Monitor, MeasurementSpecification> transformer = new Transformer<Monitor, MeasurementSpecification>(){

                public MeasurementSpecification transform(Monitor monitor) {
                    for (MeasurementSpecification m : monitor.getMeasurementSpecifications()) {
                        if (!MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)m.getMetricDescription(), (MetricDescription)soughtFor)) continue;
                        return m;
                    }
                    return null;
                }
            };
            return Collections.unmodifiableCollection(CollectionUtils.select((Collection)CollectionUtils.collect((Collection)monitorRepositoryModel.getMonitors(), (Transformer)transformer), (Predicate)PredicateUtils.notNullPredicate()));
        }
        return Collections.emptyList();
    }

    private void initResponseTimeMeasurement() {
        for (MeasurementSpecification responseTimeMeasurementSpec : this.getMeasurementSpecificationsForMetricDescription((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC)) {
            MeasuringPoint measuringPoint = responseTimeMeasurementSpec.getMonitor().getMeasuringPoint();
            List<Probe> probeList = this.createStartAndStopProbe(measuringPoint, this.simuComModel);
            Calculator calculator = this.calculatorFactory.buildResponseTimeCalculator(measuringPoint, probeList);
            if (responseTimeMeasurementSpec.getStatisticalCharacterization() == StatisticalCharacterizationEnum.NONE) continue;
            try {
                ResponseTimeAggregator aggregator = new ResponseTimeAggregator(this.simuComModel, this.getRuntimeMeasurementModel(), responseTimeMeasurementSpec, measuringPoint);
                calculator.addObserver((IMeasurementSourceListener)aggregator);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.error((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected List<Probe> createStartAndStopProbe(MeasuringPoint measuringPoint, SimuComModel simuComModel) {
        ArrayList<Probe> probeList = new ArrayList<Probe>(2);
        probeList.add((Probe)new TakeCurrentSimulationTimeProbe(simuComModel.getSimulationControl()));
        probeList.add((Probe)new TakeCurrentSimulationTimeProbe(simuComModel.getSimulationControl()));
        EObject modelElement = MonitorRepositoryUtil.getMonitoredElement(measuringPoint);
        this.currentTimeProbes.put(((Entity)modelElement).getId(), Collections.unmodifiableList(probeList));
        return probeList;
    }

    protected boolean entityIsAlreadyInstrumented(EObject modelElement) {
        return this.currentTimeProbes.containsKey(((Entity)modelElement).getId());
    }

    private <T extends Entity> void startMeasurement(ModelElementPassedEvent<T> event) {
        if (this.currentTimeProbes.containsKey(((Entity)event.getModelElement()).getId()) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(((Entity)event.getModelElement()).getId()).get(0).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    private <T extends Entity> void endMeasurement(ModelElementPassedEvent<T> event) {
        if (this.currentTimeProbes.containsKey(((Entity)event.getModelElement()).getId()) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(((Entity)event.getModelElement()).getId()).get(1).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    @Override
    public void beginSystemOperationCallInterpretation(ModelElementPassedEvent<OperationSignature> event) {
        if (this.currentTimeProbes.containsKey(((Entity)event.getModelElement()).getId()) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(((Entity)event.getModelElement()).getId()).get(0).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    @Override
    public void endSystemOperationCallInterpretation(ModelElementPassedEvent<OperationSignature> event) {
        if (this.currentTimeProbes.containsKey(((Entity)event.getModelElement()).getId()) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(((Entity)event.getModelElement()).getId()).get(1).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    private void initReconfigurationTimeMeasurement() {
        for (MeasurementSpecification reconfigurationTimeMeasurementSpec : this.getMeasurementSpecificationsForMetricDescription((MetricDescription)MetricDescriptionConstants.RECONFIGURATION_TIME_METRIC)) {
            MeasuringPoint measuringPoint = reconfigurationTimeMeasurementSpec.getMonitor().getMeasuringPoint();
            LOGGER.info((Object)"Created Reconfiguration Time Measuring Point");
            EventProbeList probe = CalculatorHelper.getEventProbeSetWithCurrentTime((MetricSetDescription)MetricDescriptionConstants.RECONFIGURATION_TIME_METRIC_TUPLE, (ISimulationControl)this.simuComModel.getSimulationControl(), (EventProbe)new TakeReconfigurationDurationProbe(this.reconfigurator));
            this.calculatorFactory.buildReconfigurationTimeCalculator(measuringPoint, (Probe)probe);
        }
    }

    private boolean simulationIsRunning() {
        return this.simuComModel.getSimulationControl().isRunning();
    }
}

