/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.LoadPCMModelsJob;

public class LoadPCMModelsInterpreterJob
extends LoadPCMModelsJob {
    private static final Logger LOGGER = Logger.getLogger(LoadPCMModelsJob.class);
    private MDSDBlackboard blackboard;
    private final AbstractPCMWorkflowRunConfiguration configuration;

    public LoadPCMModelsInterpreterJob(AbstractPCMWorkflowRunConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition pcmPartition = (ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        PCMResourceSetPartition pcmOriginalPartition = new PCMResourceSetPartition();
        this.blackboard.addPartition("org.palladiosimulator.analyzed.partition", (Object)pcmOriginalPartition);
        LOGGER.info((Object)"Loading PCM Model Files");
        for (String modelFile : this.configuration.getPCMModelFiles()) {
            pcmPartition.loadModel(URI.createURI((String)modelFile));
            pcmOriginalPartition.loadModel(URI.createURI((String)modelFile));
        }
        pcmPartition.resolveAllProxies();
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        super.setBlackboard(blackboard);
        this.blackboard = blackboard;
    }
}

