/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.metrics;

import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.TemporalCharacterization;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurement;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementFactory;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;

public abstract class PRMRecorder {
    private final RuntimeMeasurement measurement = RuntimeMeasurementFactory.eINSTANCE.createRuntimeMeasurement();
    private final RuntimeMeasurementModel prmAccess;

    public PRMRecorder(RuntimeMeasurementModel prmAccess, MeasurementSpecification measurementSpecification, MeasuringPoint measuringPoint) {
        this.measurement.setMeasuringPoint(measuringPoint);
        this.measurement.setMeasurementSpecification(measurementSpecification);
        this.prmAccess = prmAccess;
        this.attachToPRM();
    }

    private void attachToPRM() {
        if (!this.prmAccess.getMeasurements().contains((Object)this.measurement)) {
            this.prmAccess.getMeasurements().add((Object)this.measurement);
        }
    }

    protected final void detachFromPRM() {
        if (this.prmAccess.getMeasurements().contains((Object)this.measurement)) {
            this.prmAccess.getMeasurements().remove((Object)this.measurement);
        }
    }

    protected void updateMeasurementValue(double value) {
        this.measurement.setMeasuringValue(value);
    }

    protected MeasurementSpecification getMeasurementSpecification() {
        return this.measurement.getMeasurementSpecification();
    }

    protected final RuntimeMeasurement getPRMMeasurement() {
        return this.measurement;
    }

    protected RuntimeMeasurementModel getPrmModel() {
        return this.prmAccess;
    }

    protected TemporalCharacterization getTemporalCharacterization() {
        return this.getMeasurementSpecification().getTemporalRestriction();
    }
}

