/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration;

import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.simulizar.interpreter.listener.BeginReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EndReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EventResult;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.Reconfigurator;

public class ReconfigurationProcess
extends SimuComSimProcess {
    private EObject monitoredElement;
    private final Iterable<IReconfigurator> reconfigurators;
    private final ISimulationControl simControl;
    private final List<Notification> currentReconfigNotifications;
    private final Reconfigurator reconfigurator;
    private volatile boolean terminationRequested = false;

    protected ReconfigurationProcess(SimuComModel model, Iterable<IReconfigurator> reconfigurators, Reconfigurator reconfigurator) {
        super(model, "Reconfiguration Process");
        this.reconfigurators = Objects.requireNonNull(reconfigurators, "reconfigurators must not be null");
        this.reconfigurator = Objects.requireNonNull(reconfigurator, "reconfigurator must not be null");
        this.simControl = Objects.requireNonNull(model, "Passed SimuComModel must not be null").getSimulationControl();
        this.currentReconfigNotifications = new ArrayList<Notification>();
    }

    public void appendReconfigurationNotification(Notification notification) {
        if (notification != null) {
            this.currentReconfigNotifications.add(notification);
        }
    }

    private void fireBeginReconfigurationEvent(BeginReconfigurationEvent event) {
        this.reconfigurator.fireReconfigurationEvent(event);
    }

    private void fireEndReconfigurationEvent(EndReconfigurationEvent event) {
        this.reconfigurator.fireReconfigurationEvent(event);
    }

    private void fireReconfigurationExecutedEvent(BeginReconfigurationEvent beginEvent, EndReconfigurationEvent endEvent) {
        this.reconfigurator.fireReconfigurationEvent(new ReconfigurationExecutedEvent(beginEvent, endEvent, this.currentReconfigNotifications));
    }

    private void setMonitoredElement(EObject monitoredElement) {
        this.monitoredElement = monitoredElement;
    }

    private EObject getMonitoredElement() {
        return this.monitoredElement;
    }

    private void clearNotifications() {
        this.currentReconfigNotifications.clear();
    }

    public void activate() {
        throw new UnsupportedOperationException("The reconfiguration process is not supposed to be activated manually.Use executeReconfigurations(EObject) instead.");
    }

    public void reschedule(double d) {
        throw new UnsupportedOperationException("The reconfiguration process is not supposed to be scheduled manually.Use executeReconfigurations(EObject) instead.");
    }

    boolean isTerminationRequested() {
        return this.terminationRequested;
    }

    void requestTermination() {
        if (!this.terminationRequested) {
            this.terminationRequested = true;
        }
    }

    void executeReconfigurations(EObject monitoredElement) {
        if (this.isScheduled()) {
            throw new IllegalStateException("Reconfigurations are already taking place.");
        }
        if (this.isFinished()) {
            throw new IllegalStateException("Reconfiguration process has already terminated.");
        }
        this.setMonitoredElement(Objects.requireNonNull(monitoredElement, "Monitored element must not be null."));
        this.scheduleAt(0.0);
    }

    private Consumer<IReconfigurator> doReconfiguration(double currentSimulationTime, EObject monitoredElement) {
        return r -> {
            BeginReconfigurationEvent beginReconfigurationEvent = new BeginReconfigurationEvent(currentSimulationTime);
            this.fireBeginReconfigurationEvent(beginReconfigurationEvent);
            boolean reconfigResult = r.checkAndExecute(monitoredElement);
            EndReconfigurationEvent endReconfigurationEvent = new EndReconfigurationEvent(EventResult.fromBoolean(reconfigResult), this.simControl.getCurrentSimulationTime());
            this.fireEndReconfigurationEvent(endReconfigurationEvent);
            if (reconfigResult) {
                LOGGER.debug((Object)"Successfully executed reconfiguration.");
                this.fireReconfigurationExecutedEvent(beginReconfigurationEvent, endReconfigurationEvent);
            }
            this.clearNotifications();
        };
    }

    protected void internalLifeCycle() {
        while (!this.isTerminationRequested()) {
            EObject monitoredElement = this.getMonitoredElement();
            if (monitoredElement == null) continue;
            this.reconfigurators.forEach(this.doReconfiguration(this.simControl.getCurrentSimulationTime(), monitoredElement));
            this.passivate();
        }
    }
}

