/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurement;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.util.RuntimeMeasurementSwitch;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.interpreter.listener.BeginReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EndReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcess;

public class Reconfigurator
extends AbstractObservable<IReconfigurationListener> {
    private static final Logger LOGGER = Logger.getLogger(Reconfigurator.class);
    private final Adapter runtimeMeasurementListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Reconfigurator.this.checkAndExecuteReconfigurations(notification);
        }
    };
    private final RuntimeMeasurementModel runtimeMeasurementModel;
    private final List<IReconfigurator> reconfigurators;
    private final SimuComModel model;
    private ReconfigurationProcess reconfigurationProcess;
    private double lastReconfigurationTime = 0.0;
    private static final RuntimeMeasurementSwitch<MeasuringPoint> MONITORED_ELEMENT_RETRIEVER = new RuntimeMeasurementSwitch<MeasuringPoint>(){

        public MeasuringPoint caseRuntimeMeasurement(RuntimeMeasurement object) {
            return object.getMeasuringPoint();
        }
    };

    public Reconfigurator(SimuComModel model, IModelAccess modelAccessFactory, ISimulationControl simulationcontrol, List<IReconfigurator> reconfigurators) {
        this.model = model;
        this.runtimeMeasurementModel = modelAccessFactory.getRuntimeMeasurementModel();
        this.reconfigurators = reconfigurators;
    }

    public void startListening() {
        this.runtimeMeasurementModel.eAdapters().add((Object)this.runtimeMeasurementListener);
    }

    public void cleanUp() {
        this.runtimeMeasurementModel.eAdapters().remove((Object)this.runtimeMeasurementListener);
        if (this.reconfigurationProcess != null) {
            this.reconfigurationProcess.requestTermination();
        }
    }

    protected void checkAndExecuteReconfigurations(Notification notification) {
        EObject monitoredElement = this.getMonitoredElement(notification);
        if (this.isNotificationNewMeasurement(monitoredElement) && this.model.getSimulationControl().getCurrentSimulationTime() > this.lastReconfigurationTime && (this.reconfigurationProcess == null || !this.reconfigurationProcess.isScheduled())) {
            if (this.reconfigurationProcess == null) {
                this.reconfigurationProcess = new ReconfigurationProcess(this.model, this.reconfigurators, this);
            }
            this.reconfigurationProcess.executeReconfigurations((EObject)this.runtimeMeasurementModel);
            this.lastReconfigurationTime = this.model.getSimulationControl().getCurrentSimulationTime();
        }
    }

    private boolean isNotificationNewMeasurement(EObject monitoredElement) {
        return monitoredElement != null;
    }

    void fireReconfigurationEvent(EndReconfigurationEvent endReconfigurationEvent) {
        ((IReconfigurationListener)this.getEventDispatcher()).endReconfigurationEvent(endReconfigurationEvent);
    }

    void fireReconfigurationEvent(BeginReconfigurationEvent beginReconfigurationEvent) {
        ((IReconfigurationListener)this.getEventDispatcher()).beginReconfigurationEvent(beginReconfigurationEvent);
    }

    void fireReconfigurationEvent(ReconfigurationExecutedEvent reconfigurationExecutedEvent) {
        ((IReconfigurationListener)this.getEventDispatcher()).reconfigurationExecuted(reconfigurationExecutedEvent);
    }

    protected EObject getMonitoredElement(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                return (EObject)MONITORED_ELEMENT_RETRIEVER.doSwitch((EObject)notification.getNewValue());
            }
            case 4: {
                return null;
            }
            case 8: {
                return null;
            }
            case 1: {
                return (EObject)MONITORED_ELEMENT_RETRIEVER.doSwitch((EObject)notification.getNotifier());
            }
        }
        LOGGER.warn((Object)("Unsupported RuntimeMeasurement Notification: " + notification));
        return null;
    }

    public ReconfigurationProcess getReconfigurationProcess() {
        return this.reconfigurationProcess;
    }
}

