/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.probes;

import java.util.Objects;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.probes.BasicEventProbe;
import org.palladiosimulator.simulizar.interpreter.listener.BeginReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EndReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EventResult;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.reconfiguration.Reconfigurator;

public class TakeReconfigurationDurationProbe
extends BasicEventProbe<Reconfigurator, Double, Duration> {
    public TakeReconfigurationDurationProbe(Reconfigurator reconfigurator) {
        super((Object)Objects.requireNonNull(reconfigurator), MetricDescriptionConstants.RECONFIGURATION_TIME_METRIC);
    }

    protected void registerListener() {
        ((Reconfigurator)((Object)this.eventSource)).addObserver(new IReconfigurationListener(){

            @Override
            public void reconfigurationExecuted(ReconfigurationExecutedEvent reconfExecutedEvent) {
                if (reconfExecutedEvent.getReconfigurationResult() == EventResult.SUCCESS) {
                    TakeReconfigurationDurationProbe.this.notify(Measure.valueOf((double)reconfExecutedEvent.getDuration(), (Unit)SI.SECOND));
                }
            }

            @Override
            public void endReconfigurationEvent(EndReconfigurationEvent event) {
            }

            @Override
            public void beginReconfigurationEvent(BeginReconfigurationEvent event) {
            }
        });
    }
}

