/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.calculator.RecorderAttachingCalculatorFactoryDecorator;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import de.uka.ipd.sdq.simulation.AbstractSimulationConfig;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import de.uka.ipd.sdq.simulation.preferences.SimulationPreferencesHelper;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

final class SimuComModelFactory {
    SimuComModelFactory() {
    }

    static SimuComModel createSimuComModel(SimuLizarWorkflowConfiguration configuration) {
        SimuComModel simuComModel = SimuComModelFactory.initialiseSimuComModel(configuration);
        return simuComModel;
    }

    private static SimuComModel initialiseSimuComModel(SimuLizarWorkflowConfiguration configuration) {
        AbstractSimulationConfig simulationConfiguration = configuration.getSimulationConfiguration();
        SimuComStatus simuComStatus = SimuComModelFactory.createSimuComStatus();
        ISimEngineFactory simEngineFactory = SimuComModelFactory.getSimEngineFactory();
        ProbeFrameworkContext probeFrameworkContext = new ProbeFrameworkContext((ICalculatorFactory)new RecorderAttachingCalculatorFactoryDecorator((ICalculatorFactory)new DefaultCalculatorFactory(), (SimuComConfig)simulationConfiguration));
        SimuComModel simuComModel = new SimuComModel((SimuComConfig)simulationConfiguration, simuComStatus, simEngineFactory, false, probeFrameworkContext);
        simuComModel.getSimulationStatus().setCurrentSimulationTime(0.0);
        return simuComModel;
    }

    private static ISimEngineFactory getSimEngineFactory() {
        ISimEngineFactory factory = SimulationPreferencesHelper.getPreferredSimulationEngine();
        if (factory == null) {
            throw new RuntimeException("There is no simulation engine available. Install at least one engine.");
        }
        return factory;
    }

    private static SimuComStatus createSimuComStatus() {
        SimuComStatus simuComStatus = SimucomstatusFactory.eINSTANCE.createSimuComStatus();
        simuComStatus.setProcessStatus(SimucomstatusFactory.eINSTANCE.createSimulatedProcesses());
        simuComStatus.setResourceStatus(SimucomstatusFactory.eINSTANCE.createSimulatedResources());
        return simuComStatus;
    }
}

