/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.simulationevents;

import java.util.List;
import javax.measure.Measure;
import javax.measure.unit.Unit;
import org.jscience.economics.money.Currency;
import org.jscience.economics.money.Money;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.probes.BasicEventProbe;
import org.palladiosimulator.simulizar.runtimestate.CostModel;
import org.palladiosimulator.simulizar.runtimestate.CostTuple;
import org.palladiosimulator.simulizar.simulationevents.IAbstractPeriodicContainerListener;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredCostModelEntity;

public class ContainerCostProbe
extends BasicEventProbe<PeriodicallyTriggeredCostModelEntity, Double, Money>
implements IAbstractPeriodicContainerListener {
    public ContainerCostProbe(PeriodicallyTriggeredCostModelEntity triggeredContainerEntity) {
        super((Object)triggeredContainerEntity, MetricDescriptionConstants.COST_OF_RESOURCE_CONTAINERS);
    }

    protected void registerListener() {
        ((PeriodicallyTriggeredCostModelEntity)((Object)this.eventSource)).addObserver(this);
    }

    @Override
    public void triggerPeriodicUpdate(CostModel costModel, double timestamp, double delay) {
        List<CostTuple> costTuplesForInterval = costModel.getCostTuplesForInterval(timestamp - delay, timestamp);
        double summedCost = 0.0;
        for (CostTuple costTuple : costTuplesForInterval) {
            summedCost += costTuple.getCost().doubleValue();
        }
        Measure costOfInterval = Measure.valueOf((double)summedCost, (Unit)Currency.EUR);
        this.notify(costOfInterval);
    }
}

