/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.simulationevents;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.commons.designpatterns.IAbstractObservable;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simulizar.runtimestate.CostModel;
import org.palladiosimulator.simulizar.simulationevents.IAbstractPeriodicContainerListener;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;

public class PeriodicallyTriggeredContainerEntity
extends PeriodicallyTriggeredSimulationEntity
implements IAbstractObservable<IAbstractPeriodicContainerListener> {
    private static final Logger LOGGER = Logger.getLogger(PeriodicallyTriggeredSimulationEntity.class);
    private final ResourceContainer resourceContainer;
    private final CostModel costModel;
    private final double containerPrice;
    private final String unit;
    private final AbstractObservable<IAbstractPeriodicContainerListener> observableDelegate;

    public PeriodicallyTriggeredContainerEntity(SimuComModel model, CostModel costModel, ResourceContainer resourceContainer) {
        super(model, 0.0, PeriodicallyTriggeredContainerEntity.getDelay(resourceContainer));
        this.containerPrice = (Double)StereotypeAPI.getTaggedValue((EObject)resourceContainer, (String)"amount", (String)"Price");
        this.unit = (String)StereotypeAPI.getTaggedValue((EObject)resourceContainer, (String)"unit", (String)"Price");
        this.resourceContainer = resourceContainer;
        this.costModel = costModel;
        this.observableDelegate = new AbstractObservable<IAbstractPeriodicContainerListener>(){};
    }

    private static double getDelay(ResourceContainer resourceContainer) {
        if (!StereotypeAPI.isStereotypeApplied((EObject)resourceContainer, (String)"Price")) {
            throw new RuntimeException("Periodically triggered container entities need to have a 'Price' stereotype applied!");
        }
        return (Double)StereotypeAPI.getTaggedValue((EObject)resourceContainer, (String)"interval", (String)"Price");
    }

    @Override
    protected void triggerInternal() {
        Double timestamp = this.getModel().getSimulationControl().getCurrentSimulationTime();
        if (LOGGER.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.resourceContainer.getEntityName());
            stringBuilder.append(" caused operation cost of ");
            stringBuilder.append(this.containerPrice);
            stringBuilder.append(" ");
            stringBuilder.append(this.unit);
            stringBuilder.append(" at time ");
            stringBuilder.append(timestamp.toString());
            LOGGER.info((Object)stringBuilder.toString());
        }
        this.costModel.addCostTuple(this.resourceContainer.getId(), timestamp, new Double(this.containerPrice));
    }

    public void addObserver(IAbstractPeriodicContainerListener observer) {
        this.observableDelegate.addObserver((Object)observer);
    }

    public void removeObserver(IAbstractPeriodicContainerListener observer) {
        this.observableDelegate.removeObserver((Object)observer);
    }

    @Override
    public void removeEvent() {
        super.removeEvent();
    }
}

