/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.usage.ClosedWorkload;
import de.uka.ipd.sdq.simucomframework.usage.ClosedWorkloadUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import de.uka.ipd.sdq.simucomframework.usage.OpenWorkload;
import de.uka.ipd.sdq.simucomframework.usage.OpenWorkloadUserFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.Workload;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.UsageScenarioSwitch;

public class SimulatedUsageModels {
    private static final Logger LOGGER = Logger.getLogger(SimulatedUsageModels.class);
    private final InterpreterDefaultContext rootContext;
    private final Map<org.palladiosimulator.pcm.usagemodel.ClosedWorkload, ClosedWorkload> closedWorkloads = new HashMap<org.palladiosimulator.pcm.usagemodel.ClosedWorkload, ClosedWorkload>();
    private final Map<org.palladiosimulator.pcm.usagemodel.OpenWorkload, OpenWorkload> openWorkloads = new HashMap<org.palladiosimulator.pcm.usagemodel.OpenWorkload, OpenWorkload>();

    public SimulatedUsageModels(InterpreterDefaultContext rootContext) {
        this.rootContext = rootContext;
    }

    public IWorkloadDriver[] getWorkloadDrivers() {
        EList usageScenarios = this.rootContext.getModelAccess().getGlobalPCMModel().getUsageModel().getUsageScenario_UsageModel();
        IWorkloadDriver[] workloads = new IWorkloadDriver[usageScenarios.size()];
        int i = 0;
        while (i < usageScenarios.size()) {
            workloads[i] = this.getWorkloadDriver((UsageScenario)usageScenarios.get(i));
            ++i;
        }
        return workloads;
    }

    private IWorkloadDriver getWorkloadDriver(UsageScenario usageScenario) {
        Workload workload = usageScenario.getWorkload_UsageScenario();
        if (workload.eClass() == UsagemodelPackage.eINSTANCE.getClosedWorkload()) {
            ClosedWorkload driver = this.getClosedWorkloadDriver(workload, usageScenario);
            this.closedWorkloads.put((org.palladiosimulator.pcm.usagemodel.ClosedWorkload)workload, driver);
            return driver;
        }
        if (workload.eClass() == UsagemodelPackage.eINSTANCE.getOpenWorkload()) {
            OpenWorkload driver = this.getOpenWorkloadDriver(workload, usageScenario);
            this.openWorkloads.put((org.palladiosimulator.pcm.usagemodel.OpenWorkload)workload, driver);
            return driver;
        }
        throw new UnsupportedOperationException("Unsupported Workload Found");
    }

    private ClosedWorkload getClosedWorkloadDriver(Workload workload, final UsageScenario usageScenario) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Create workload driver for ClosedWorkload: " + workload));
        }
        org.palladiosimulator.pcm.usagemodel.ClosedWorkload closedWorkload = (org.palladiosimulator.pcm.usagemodel.ClosedWorkload)workload;
        ClosedWorkloadUserFactory userFactory = new ClosedWorkloadUserFactory(this.rootContext.getModel(), closedWorkload.getThinkTime_ClosedWorkload().getSpecification(), usageScenario){

            public IScenarioRunner createScenarioRunner() {
                return SimulatedUsageModels.this.getScenarioRunner(usageScenario);
            }
        };
        return new ClosedWorkload((IUserFactory)userFactory, closedWorkload.getPopulation());
    }

    private OpenWorkload getOpenWorkloadDriver(Workload workload, final UsageScenario usageScenario) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Create workload driver for OpenWorkload: " + workload));
        }
        org.palladiosimulator.pcm.usagemodel.OpenWorkload openWorkload = (org.palladiosimulator.pcm.usagemodel.OpenWorkload)workload;
        OpenWorkloadUserFactory userFactory = new OpenWorkloadUserFactory(this.rootContext.getModel(), usageScenario){

            public IScenarioRunner createScenarioRunner() {
                return SimulatedUsageModels.this.getScenarioRunner(usageScenario);
            }
        };
        return new OpenWorkload(this.rootContext.getModel(), (IUserFactory)userFactory, openWorkload.getInterArrivalTime_OpenWorkload().getSpecification());
    }

    private IScenarioRunner getScenarioRunner(final UsageScenario scenario) {
        return new IScenarioRunner(){

            public void scenarioRunner(SimuComSimProcess thread) {
                InterpreterDefaultContext newContext = new InterpreterDefaultContext(SimulatedUsageModels.this.rootContext, thread);
                UsageModel usageModel = newContext.getModelAccess().getLocalPCMModel().getUsageModel();
                UsageScenario myUsageScenarioCopy = null;
                for (UsageScenario curScenario : usageModel.getUsageScenario_UsageModel()) {
                    if (!curScenario.getId().equals(scenario.getId())) continue;
                    myUsageScenarioCopy = curScenario;
                    break;
                }
                new UsageScenarioSwitch(newContext).doSwitch((EObject)myUsageScenarioCopy);
            }
        };
    }

    public OpenWorkload getOpenWorkloadDriver(org.palladiosimulator.pcm.usagemodel.OpenWorkload openWorkload) {
        return this.openWorkloads.get(openWorkload);
    }

    public ClosedWorkload getClosedWorkloadDriver(org.palladiosimulator.pcm.usagemodel.ClosedWorkload closedWorkload) {
        return this.closedWorkloads.get(closedWorkload);
    }
}

