/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import org.apache.log4j.Logger;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;
import org.palladiosimulator.simulizar.usagemodel.LoopingUsageEvolver;
import org.palladiosimulator.simulizar.usagemodel.StretchedUsageEvolver;
import org.scaledl.usageevolution.Usage;

public class UsageEvolver {
    private static final Logger LOGGER = Logger.getLogger(UsageEvolver.class);
    private final SimuLizarRuntimeState runtimeState;

    public UsageEvolver(SimuLizarRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    public void start() {
        for (Usage usage : this.runtimeState.getModelAccess().getUsageEvolutionModel().getUsages()) {
            double timePerStep = 1.0;
            if (usage.getEvolutionStepWidth() != 0.0) {
                timePerStep = usage.getEvolutionStepWidth();
            }
            if (usage.isRepeatingPattern()) {
                new LoopingUsageEvolver(this.runtimeState, 0.0, timePerStep, usage.getScenario());
                continue;
            }
            timePerStep = (double)this.runtimeState.getModel().getConfiguration().getSimuTime() / (usage.getLoadEvolution().getFinalDuration() + 1.0);
            new StretchedUsageEvolver(this.runtimeState, 0.0, timePerStep, usage.getScenario());
        }
    }
}

