/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.ResourceURIMeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.util.MeasuringpointSwitch;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.util.RepositorySwitch;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.util.ResourceenvironmentSwitch;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.EntryLevelSystemCallMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ExternalCallActionMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ResourceContainerMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ResourceEnvironmentMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SubSystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;
import simulizarmeasuringpoint.ReconfigurationMeasuringPoint;
import simulizarmeasuringpoint.util.SimulizarmeasuringpointSwitch;

public final class MonitorRepositoryUtil {
    public static MeasurementSpecification isMonitored(MonitorRepository monitorRepositoryModel, EObject element, MetricDescription metricDescription) {
        if (monitorRepositoryModel != null) {
            for (Monitor monitor : monitorRepositoryModel.getMonitors()) {
                if (!MonitorRepositoryUtil.elementConformingToMeasuringPoint(element, monitor.getMeasuringPoint())) continue;
                for (MeasurementSpecification measurementSpecification : monitor.getMeasurementSpecifications()) {
                    if (!measurementSpecification.getMetricDescription().getId().equals(metricDescription.getId())) continue;
                    return measurementSpecification;
                }
            }
        }
        return null;
    }

    public static EObject getMonitoredElement(MeasuringPoint mp) {
        EObject eobject = MonitorRepositoryUtil.getEObjectFromPCMMeasuringPoint(mp);
        if (eobject == null && (eobject = MonitorRepositoryUtil.getEObjectFromSimuLizarMeasuringPoint(mp)) == null && (eobject = MonitorRepositoryUtil.getEObjectFromGeneralMeasuringPoint(mp)) == null) {
            throw new IllegalArgumentException("Could not find EObject for MeasuringPoint \"" + mp.getStringRepresentation() + "\" -- most likely this type of measuring point is " + "not yet implemented within in getEObjectFromPCMMeasuringPoint " + "or getEObjectFromGeneralMeasuringPoint methods.");
        }
        return eobject;
    }

    private static EObject getEObjectFromSimuLizarMeasuringPoint(MeasuringPoint measuringPoint) {
        return (EObject)new SimulizarmeasuringpointSwitch<EObject>(){

            public EObject caseReconfigurationMeasuringPoint(ReconfigurationMeasuringPoint object) {
                return EMFLoadHelper.loadAndResolveEObject((String)object.getResourceURI());
            }
        }.doSwitch((EObject)measuringPoint);
    }

    private static EObject getEObjectFromGeneralMeasuringPoint(MeasuringPoint measuringPoint) {
        return (EObject)new MeasuringpointSwitch<EObject>(){

            public EObject caseResourceURIMeasuringPoint(ResourceURIMeasuringPoint object) {
                return EMFLoadHelper.loadAndResolveEObject((String)object.getResourceURI());
            }
        }.doSwitch((EObject)measuringPoint);
    }

    private static EObject getEObjectFromPCMMeasuringPoint(MeasuringPoint measuringPoint) {
        return (EObject)new PcmmeasuringpointSwitch<EObject>(){

            public EObject caseEntryLevelSystemCallMeasuringPoint(EntryLevelSystemCallMeasuringPoint object) {
                return object.getEntryLevelSystemCall();
            }

            public EObject caseUsageScenarioMeasuringPoint(UsageScenarioMeasuringPoint object) {
                return object.getUsageScenario();
            }

            public EObject caseResourceEnvironmentMeasuringPoint(ResourceEnvironmentMeasuringPoint object) {
                return object.getResourceEnvironment();
            }

            public EObject caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint object) {
                return object.getActiveResource();
            }

            public EObject caseSystemOperationMeasuringPoint(SystemOperationMeasuringPoint object) {
                return object.getOperationSignature();
            }

            public EObject caseExternalCallActionMeasuringPoint(ExternalCallActionMeasuringPoint object) {
                return object.getExternalCall();
            }
        }.doSwitch((EObject)measuringPoint);
    }

    public static List<Monitor> getMonitorsForElement(MonitorRepository monitorRepository, EObject element) {
        LinkedList<Monitor> result = new LinkedList<Monitor>();
        if (monitorRepository == null) {
            return result;
        }
        for (Monitor monitor : monitorRepository.getMonitors()) {
            if (!MonitorRepositoryUtil.elementConformingToMeasuringPoint(element, monitor.getMeasuringPoint())) continue;
            result.add(monitor);
        }
        return result;
    }

    public static List<MeasurementSpecification> getMeasurementSpecificationsForElement(MonitorRepository monitorRepository, EObject element) {
        LinkedList<MeasurementSpecification> result = new LinkedList<MeasurementSpecification>();
        for (Monitor monitor : MonitorRepositoryUtil.getMonitorsForElement(monitorRepository, element)) {
            result.addAll((Collection<MeasurementSpecification>)monitor.getMeasurementSpecifications());
        }
        return result;
    }

    public static boolean elementConformingToMeasuringPoint(EObject element, MeasuringPoint measuringPoint) {
        if (measuringPoint == null) {
            throw new IllegalArgumentException("Measuring point cannot be null");
        }
        Boolean result = MonitorRepositoryUtil.checkGeneralMeasuringPoints(element, measuringPoint);
        if (result == null && (result = MonitorRepositoryUtil.checkPCMMeasuringPoints(element, measuringPoint)) == null) {
            throw new IllegalArgumentException("Unknown measuring point type");
        }
        return result;
    }

    private static Boolean checkPCMMeasuringPoints(final EObject element, MeasuringPoint measuringPoint) {
        return (Boolean)new PcmmeasuringpointSwitch<Boolean>(){

            public Boolean caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint mp) {
                return this.checkActiveResourceMeasuringPoint(mp);
            }

            public Boolean caseAssemblyOperationMeasuringPoint(AssemblyOperationMeasuringPoint mp) {
                return this.checkAssemblyOperationMeasuringPoint(mp);
            }

            public Boolean caseAssemblyPassiveResourceMeasuringPoint(AssemblyPassiveResourceMeasuringPoint mp) {
                return this.checkAssemblyPassiveResourceMeasuringPoint(mp);
            }

            public Boolean caseSubSystemOperationMeasuringPoint(SubSystemOperationMeasuringPoint object) {
                throw new IllegalArgumentException("Subsystems are currently unsupported by SimuLizar");
            }

            public Boolean caseSystemOperationMeasuringPoint(SystemOperationMeasuringPoint mp) {
                return this.checkSystemOperationMeasuringPoint(mp);
            }

            public Boolean caseUsageScenarioMeasuringPoint(UsageScenarioMeasuringPoint mp) {
                return this.checkUsageScenarioMeasuringPoint(mp);
            }

            public Boolean caseResourceEnvironmentMeasuringPoint(ResourceEnvironmentMeasuringPoint mp) {
                return this.checkResourceEnvironmentMeasuringPoint(element, mp);
            }

            public Boolean caseResourceContainerMeasuringPoint(ResourceContainerMeasuringPoint mp) {
                return this.checkResourceContainerMeasuringPoint(element, mp);
            }

            public Boolean caseExternalCallActionMeasuringPoint(ExternalCallActionMeasuringPoint mp) {
                return this.checkExternCallActionMeasuringpoint(element, mp);
            }

            private boolean checkActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint mp) {
                final ProcessingResourceSpecification activeResource = mp.getActiveResource();
                return (Boolean)new ResourceenvironmentSwitch<Boolean>(){

                    public Boolean caseResourceContainer(ResourceContainer resourceContainer) {
                        return resourceContainer.getId().equals(activeResource.getResourceContainer_ProcessingResourceSpecification().getId());
                    }

                    public Boolean caseProcessingResourceSpecification(ProcessingResourceSpecification spec) {
                        return activeResource.getId().equals(spec.getId());
                    }

                    public Boolean defaultCase(EObject obj) {
                        return false;
                    }
                }.doSwitch(element);
            }

            private boolean checkAssemblyOperationMeasuringPoint(final AssemblyOperationMeasuringPoint mp) {
                return (Boolean)new SeffSwitch<Boolean>(){

                    public Boolean caseExternalCallAction(ExternalCallAction externalCallAction) {
                        if (externalCallAction.getCalledService_ExternalService().getId().equals(mp.getOperationSignature().getId()) && externalCallAction.getRole_ExternalService().getId().equals(mp.getRole().getId())) {
                            return true;
                        }
                        return false;
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch(element);
            }

            private Boolean checkAssemblyPassiveResourceMeasuringPoint(final AssemblyPassiveResourceMeasuringPoint mp) {
                return (Boolean)new RepositorySwitch<Boolean>(){

                    public Boolean casePassiveResource(PassiveResource passiveResource) {
                        return passiveResource.getId().equals(mp.getPassiveResource().getId());
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch((EObject)mp);
            }

            private boolean checkSystemOperationMeasuringPoint(final SystemOperationMeasuringPoint mp) {
                return (Boolean)new UsagemodelSwitch<Boolean>(){

                    public Boolean caseEntryLevelSystemCall(EntryLevelSystemCall entryLevelSystemCall) {
                        if (entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall().getId().equals(mp.getOperationSignature().getId()) && entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall().getId().equals(mp.getRole().getId())) {
                            return true;
                        }
                        return false;
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch(element);
            }

            private boolean checkUsageScenarioMeasuringPoint(final UsageScenarioMeasuringPoint mp) {
                return (Boolean)new UsagemodelSwitch<Boolean>(){

                    public Boolean caseUsageScenario(UsageScenario usageScenario) {
                        return usageScenario.getId().equals(mp.getUsageScenario().getId());
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch(element);
            }

            private Boolean checkResourceEnvironmentMeasuringPoint(EObject element2, final ResourceEnvironmentMeasuringPoint mp) {
                return (Boolean)new ResourceenvironmentSwitch<Boolean>(){

                    public Boolean caseResourceEnvironment(ResourceEnvironment resourceEnvironment) {
                        return resourceEnvironment.getEntityName().equals(mp.getResourceEnvironment().getEntityName());
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch(element2);
            }

            private Boolean checkResourceContainerMeasuringPoint(EObject element2, final ResourceContainerMeasuringPoint mp) {
                return (Boolean)new ResourceenvironmentSwitch<Boolean>(){

                    public Boolean caseResourceContainer(ResourceContainer resourceContainer) {
                        return resourceContainer.getId().equals(mp.getResourceContainer().getId());
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch(element2);
            }

            private Boolean checkExternCallActionMeasuringpoint(EObject element2, final ExternalCallActionMeasuringPoint mp) {
                return (Boolean)new SeffSwitch<Boolean>(){

                    public Boolean caseExternalCallAction(ExternalCallAction externalCallAction) {
                        return externalCallAction.getId().equals(mp.getExternalCall().getId());
                    }

                    public Boolean defaultCase(EObject object) {
                        return false;
                    }
                }.doSwitch(element2);
            }
        }.doSwitch((EObject)measuringPoint);
    }

    private static Boolean checkGeneralMeasuringPoints(final EObject element, MeasuringPoint measuringPoint) {
        return (Boolean)new MeasuringpointSwitch<Boolean>(){

            public Boolean caseResourceURIMeasuringPoint(ResourceURIMeasuringPoint mp) {
                String measuringPointResourceURI = mp.getResourceURI();
                String elementResourceFragment = EMFLoadHelper.getResourceFragment((EObject)element);
                return measuringPointResourceURI.endsWith(elementResourceFragment);
            }

            public Boolean caseStringMeasuringPoint(StringMeasuringPoint mp) {
                throw new IllegalArgumentException("String measuring points are forbidden for SimuLizar: " + mp.toString());
            }
        }.doSwitch((EObject)measuringPoint);
    }
}

