/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.interpreter;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.simulizar.action.context.ExecutionContext;
import org.palladiosimulator.simulizar.action.core.EnactAdaptationStep;
import org.palladiosimulator.simulizar.action.core.GuardedTransition;
import org.palladiosimulator.simulizar.action.core.ResourceDemandingStep;
import org.palladiosimulator.simulizar.action.core.StateTransformingStep;
import org.palladiosimulator.simulizar.action.instance.RoleSet;
import org.palladiosimulator.simulizar.action.mapping.Mapping;
import org.palladiosimulator.simulizar.action.mapping.MappingPackage;
import org.palladiosimulator.simulizar.reconfiguration.qvto.AbstractQVTOExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.TransformationParameterInformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.ModelTransformationCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;

class TransientEffectQVTOExecutor
extends AbstractQVTOExecutor {
    private static final Logger LOGGER = Logger.getLogger(TransientEffectQVTOExecutor.class);
    private static final EPackage MAPPING_EPACKAGE = MappingPackage.Literals.MAPPING.getEPackage();
    private static final EPackage REPOSITORY_EPACKAGE = RepositoryPackage.Literals.REPOSITORY.getEPackage();
    private final Collection<ModelExtent> currentPureOutParams = new ArrayList<ModelExtent>();

    protected TransientEffectQVTOExecutor(ModelTransformationCache transformationCache, QVToModelCache availableModels) {
        super(transformationCache, Objects.requireNonNull(availableModels));
    }

    Optional<Mapping> executeControllerCompletion(Repository controllerCompletionRepository, String controllerCompletionPath, IResourceTableManager resourceTableManager) {
        Collection<EObject> cachedRepo = this.getModelsByType(REPOSITORY_EPACKAGE);
        this.storeModel((EObject)controllerCompletionRepository);
        URI controllerCompletionUri = URI.createURI((String)controllerCompletionPath);
        QvtoModelTransformation controllerCompletion = this.getTransformationByUri(controllerCompletionUri).get();
        boolean result = this.executeTransformation(controllerCompletion, resourceTableManager);
        cachedRepo.forEach(repoInCache -> this.storeModel((EObject)repoInCache));
        if (result) {
            return this.getModelByType(MAPPING_EPACKAGE).map(obj -> (Mapping)obj);
        }
        return Optional.empty();
    }

    boolean executeGuardedTransition(GuardedTransition guardedTransition, IResourceTableManager resourceTableManager) {
        URI conditionUri = URI.createURI((String)guardedTransition.getConditionURI());
        QvtoModelTransformation condition = this.getTransformationByUri(conditionUri).get();
        ExecutionDiagnostic result = this.executeTransformationInternal(Objects.requireNonNull(condition), resourceTableManager);
        return this.handleExecutionResultForGuardedTransition(guardedTransition, result);
    }

    private void storeModel(EObject model) {
        this.getAvailableModels().storeModel(model);
    }

    private void prepareTransformation(String transformationUri) {
        assert (transformationUri != null);
        URI uri = URI.createURI((String)Objects.requireNonNull(transformationUri));
        if (!this.getAvailableTransformations().contains(uri)) {
            this.getAvailableTransformations().store(new URI[]{uri});
        }
    }

    void addTransformationParameters(RoleSet roleSet, ExecutionContext context) {
        this.storeModel(roleSet);
        this.storeModel(context);
    }

    void enableForTransformationExecution(EnactAdaptationStep enactAdaptationStep) {
        this.storeModel(Objects.requireNonNull(enactAdaptationStep));
        this.prepareTransformation(enactAdaptationStep.getAdaptationStepURI());
    }

    void enableForTransformationExecution(ResourceDemandingStep resourceDemandingStep) {
        this.storeModel(Objects.requireNonNull(resourceDemandingStep));
        this.prepareTransformation(resourceDemandingStep.getControllerCompletionURI());
    }

    void enableForTransformationExecution(StateTransformingStep stateTransformingStep) {
        this.storeModel(Objects.requireNonNull(stateTransformingStep));
    }

    void enableForTransformationExecution(GuardedTransition guardedTransition) {
        this.prepareTransformation(Objects.requireNonNull(guardedTransition).getConditionURI());
    }

    Optional<QvtoModelTransformation> getTransformationByUri(URI transformationId) {
        return this.getAvailableTransformations().get(Objects.requireNonNull(transformationId));
    }

    Collection<EObject> getModelsByType(EPackage modelType) {
        return this.getAvailableModels().getModelsByType(Objects.requireNonNull(modelType));
    }

    Optional<EObject> getModelByType(EPackage modelType) {
        Collection<EObject> modelsOfType = this.getModelsByType(Objects.requireNonNull(modelType));
        return modelsOfType.isEmpty() ? Optional.empty() : Optional.of(modelsOfType.iterator().next());
    }

    protected boolean handleExecutionResult(ExecutionDiagnostic executionResult) {
        boolean result = super.handleExecutionResult(executionResult);
        if (result) {
            this.currentPureOutParams.stream().map(ModelExtent::getContents).filter(contents -> !contents.isEmpty()).map(contents -> (EObject)contents.get(0)).forEach(arg_0 -> ((QVToModelCache)this.getAvailableModels()).storeModel(arg_0));
        }
        return result;
    }

    protected boolean handleExecutionResultForGuardedTransition(GuardedTransition guardedTransition, ExecutionDiagnostic executionResult) {
        if (executionResult.getCode() == 100) {
            LOGGER.info((Object)("Guard Condition of \"" + guardedTransition.getEntityName() + "\" evaluated to false. The transition is not taken."));
            return false;
        }
        return this.handleExecutionResult(executionResult);
    }

    protected ModelExtent[] setupModelExtents(QvtoModelTransformation transformation) {
        this.currentPureOutParams.clear();
        ModelExtent[] result = super.setupModelExtents(transformation);
        transformation.getPureOutParameters().stream().mapToInt(TransformationParameterInformation::getParameterIndex).mapToObj(index -> result[index]).forEach(this.currentPureOutParams::add);
        return result;
    }
}

