package org.palladiosimulator.simulizar.reconfiguration.qvto;

import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import org.palladiosimulator.simulizar.di.component.core.SimuLizarRootComponent;
import org.palladiosimulator.simulizar.di.component.core.SimuLizarRuntimeComponent;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerQVTOReconfigurationComponent implements QVTOReconfigurationComponent {
  private Provider<SimuLizarWorkflowConfiguration> configProvider;

  private Provider<PCMPartitionManager> globalPartitionManagerProvider;

  private Provider<QVTOReconfigurator> qVTOReconfiguratorProvider;

  private Provider<QVTOReconfigurationLoader> qVTOReconfigurationLoaderProvider;

  private DaggerQVTOReconfigurationComponent(
      SimuLizarRuntimeComponent simuLizarRuntimeComponentParam,
      SimuLizarRootComponent simuLizarRootComponentParam) {

    initialize(simuLizarRuntimeComponentParam, simuLizarRootComponentParam);
  }

  public static QVTOReconfigurationComponent.Factory factory() {
    return new Factory();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final SimuLizarRuntimeComponent simuLizarRuntimeComponentParam,
      final SimuLizarRootComponent simuLizarRootComponentParam) {
    this.configProvider = new org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_config(simuLizarRootComponentParam);
    this.globalPartitionManagerProvider = new org_palladiosimulator_simulizar_di_component_core_SimuLizarRuntimeComponent_globalPartitionManager(simuLizarRuntimeComponentParam);
    this.qVTOReconfiguratorProvider = DoubleCheck.provider(QVTOReconfigurator_Factory.create(configProvider, globalPartitionManagerProvider));
    this.qVTOReconfigurationLoaderProvider = DoubleCheck.provider(QVTOReconfigurationLoader_Factory.create());
  }

  @Override
  public QVTOReconfigurator reconfigurator() {
    return qVTOReconfiguratorProvider.get();
  }

  @Override
  public QVTOReconfigurationLoader loader() {
    return qVTOReconfigurationLoaderProvider.get();
  }

  private static final class Factory implements QVTOReconfigurationComponent.Factory {
    @Override
    public QVTOReconfigurationComponent create(SimuLizarRootComponent rootComponent,
        SimuLizarRuntimeComponent runtimeComponent) {
      Preconditions.checkNotNull(rootComponent);
      Preconditions.checkNotNull(runtimeComponent);
      return new DaggerQVTOReconfigurationComponent(runtimeComponent, rootComponent);
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_config implements Provider<SimuLizarWorkflowConfiguration> {
    private final SimuLizarRootComponent simuLizarRootComponent;

    org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_config(
        SimuLizarRootComponent simuLizarRootComponent) {
      this.simuLizarRootComponent = simuLizarRootComponent;
    }

    @Override
    public SimuLizarWorkflowConfiguration get() {
      return Preconditions.checkNotNullFromComponent(simuLizarRootComponent.config());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_core_SimuLizarRuntimeComponent_globalPartitionManager implements Provider<PCMPartitionManager> {
    private final SimuLizarRuntimeComponent simuLizarRuntimeComponent;

    org_palladiosimulator_simulizar_di_component_core_SimuLizarRuntimeComponent_globalPartitionManager(
        SimuLizarRuntimeComponent simuLizarRuntimeComponent) {
      this.simuLizarRuntimeComponent = simuLizarRuntimeComponent;
    }

    @Override
    public PCMPartitionManager get() {
      return Preconditions.checkNotNullFromComponent(simuLizarRuntimeComponent.globalPartitionManager());
    }
  }
}
