/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.util.RuntimeMeasurementSwitch;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOReconfigurationLogger;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.TransformationParameterInformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.ModelTransformationCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;

public abstract class AbstractQVTOExecutor {
    private static final Logger LOGGER = Logger.getLogger(AbstractQVTOExecutor.class);
    private final QVToModelCache availableModels;
    private final ModelTransformationCache transformationCache;
    private static final RuntimeMeasurementSwitch<Collection<EObject>> CREATE_NON_EMPTY_MODEL_ELEMENTS_SWITCH = new RuntimeMeasurementSwitch<Collection<EObject>>(){

        public Collection<EObject> caseRuntimeMeasurementModel(RuntimeMeasurementModel runtimeMeasurementModel) {
            return new ArrayList<EObject>((Collection<EObject>)runtimeMeasurementModel.getMeasurements());
        }

        public Collection<EObject> defaultCase(EObject model) {
            return Collections.singletonList(model);
        }
    };
    private static final Collector<EObject, List<EObject>, ModelExtent> BASIC_MODEL_EXTENT_COLLECTOR = Collector.of(ArrayList::new, (acc, t) -> {
        boolean bl = acc.add(t);
    }, (l, r) -> {
        l.addAll(r);
        return l;
    }, BasicModelExtent::new, new Collector.Characteristics[0]);

    protected AbstractQVTOExecutor(ModelTransformationCache knownTransformations, QVToModelCache knownModels) {
        this.transformationCache = Objects.requireNonNull(knownTransformations);
        this.availableModels = Objects.requireNonNull(knownModels);
    }

    protected ModelTransformationCache getAvailableTransformations() {
        return this.transformationCache;
    }

    protected QVToModelCache getAvailableModels() {
        return this.availableModels;
    }

    public boolean executeTransformation(URI transformationURI, IResourceTableManager resourceTableManager) {
        Optional<QvtoModelTransformation> data = this.transformationCache.get(Objects.requireNonNull(transformationURI));
        return this.executeTransformation(data.orElseThrow(() -> new IllegalArgumentException("Given transformation not present in transformation cache.")), resourceTableManager);
    }

    public final boolean executeTransformation(QvtoModelTransformation modelTransformation, IResourceTableManager resourceTableManager) {
        ExecutionDiagnostic result = this.executeTransformationInternal(modelTransformation, resourceTableManager);
        return this.handleExecutionResult(result);
    }

    protected ExecutionDiagnostic executeTransformationInternal(QvtoModelTransformation modelTransformation, IResourceTableManager resourceTableManager) {
        ModelExtent[] modelExtents = this.setupModelExtents(Objects.requireNonNull(modelTransformation));
        ExecutionContext executionContext = this.setupExecutionContext(resourceTableManager);
        ExecutionDiagnostic result = this.doExecution(modelTransformation, executionContext, modelExtents);
        return result;
    }

    protected final ExecutionDiagnostic doExecution(QvtoModelTransformation modelTransformation, ExecutionContext context, ModelExtent[] params) {
        return modelTransformation.getTransformationExecutor().execute(context, params);
    }

    protected boolean handleExecutionResult(ExecutionDiagnostic executionResult) {
        int severity = executionResult.getSeverity();
        if (severity == 0 || severity == 1) {
            LOGGER.debug((Object)("Successful rule application: " + executionResult.getMessage()));
            return true;
        }
        List details = executionResult.getChildren();
        String chainedDetails = details.stream().map(Object::toString).collect(Collectors.joining(","));
        Level level = Level.WARN;
        if (severity >= 4) {
            level = Level.ERROR;
        }
        LOGGER.log((Priority)level, (Object)String.format("%s; %s", executionResult.getMessage(), chainedDetails), executionResult.getException());
        return false;
    }

    protected ExecutionContext setupExecutionContext(IResourceTableManager resourceTableManager) {
        ExecutionContextImpl result = new ExecutionContextImpl();
        result.setLog(this.createLog());
        result.setConfigProperty("resourceTableManager", (Object)resourceTableManager);
        return result;
    }

    protected Log createLog() {
        return new QVTOReconfigurationLogger(this.getClass());
    }

    protected ModelExtent[] setupModelExtents(QvtoModelTransformation transformation) {
        assert (transformation != null && transformation.getTransformationExecutor() != null);
        ModelExtent[] modelExtents = new ModelExtent[transformation.getParameterCount()];
        for (TransformationParameterInformation inParams : transformation.getInParameters()) {
            Collection<EObject> sourceModel = this.availableModels.getModelsByType(inParams.getParameterType());
            if (sourceModel.isEmpty()) {
                throw new IllegalStateException("No model in QVTo model cache for " + (inParams.getParameterIndex() + 1) + ". parameter of transformation '" + transformation.getTransformationName() + "'");
            }
            modelExtents[inParams.getParameterIndex()] = sourceModel.stream().map(arg_0 -> CREATE_NON_EMPTY_MODEL_ELEMENTS_SWITCH.doSwitch(arg_0)).flatMap(Collection::stream).collect(BASIC_MODEL_EXTENT_COLLECTOR);
        }
        transformation.getPureOutParameters().stream().mapToInt(TransformationParameterInformation::getParameterIndex).forEach(index -> {
            BasicModelExtent basicModelExtent = new BasicModelExtent();
        });
        return modelExtents;
    }
}

