/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOExecutor;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.ModelTransformationCache;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.scopes.RuntimeExtensionScope;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

@RuntimeExtensionScope
public class QVTOReconfigurator
extends AbstractReconfigurator {
    private static final Logger LOGGER = Logger.getLogger(QVTOReconfigurator.class);
    private QVTOExecutor qvtoExecutor;

    @Inject
    public QVTOReconfigurator(SimuLizarWorkflowConfiguration configuration, PCMPartitionManager partitionManager) {
        this.configuration = configuration;
        this.pcmPartitionManager = partitionManager;
    }

    private QVTOExecutor getQVTOExecutor() {
        if (this.qvtoExecutor == null) {
            this.qvtoExecutor = new QVTOExecutor(new ModelTransformationCache(new URI[0]), new QVToModelCache(this.pcmPartitionManager));
        }
        return this.qvtoExecutor;
    }

    public boolean runCheck(EList<? extends ModelTransformation<? extends Object>> checks, EObject monitoredElement, IResourceTableManager resourceTableManager) {
        return this.runExecute(checks, monitoredElement, resourceTableManager);
    }

    public boolean runExecute(EList<? extends ModelTransformation<? extends Object>> actions, EObject monitoredElement, IResourceTableManager resourceTableManager) {
        LOGGER.debug((Object)"Checking reconfiguration rules due to PRM change");
        ArrayList<QvtoModelTransformation> transformations = new ArrayList<QvtoModelTransformation>();
        for (ModelTransformation action : actions) {
            try {
                if (!(action instanceof QvtoModelTransformation)) continue;
                transformations.add((QvtoModelTransformation)action);
            }
            catch (ClassCastException e) {
                LOGGER.debug((Object)"Not a QVTO model transformation.");
            }
        }
        boolean result = this.getQVTOExecutor().executeTransformations(transformations, resourceTableManager);
        LOGGER.debug((Object)(result ? "Reconfigured system by a matching rule" : "No reconfiguration rule was executed, all conditions were false"));
        return result;
    }
}

