/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QVTOTransformationExecutor;

public class QVTOTransformationExecutorPool {
    private final Collection<SoftReference<QVTOTransformationExecutor>> availableExecutors = new LinkedList<SoftReference<QVTOTransformationExecutor>>();
    private final ReferenceQueue<QVTOTransformationExecutor> collectedExecutors = new ReferenceQueue();
    protected final Supplier<QVTOTransformationExecutor> executorSupplier;

    public QVTOTransformationExecutorPool(Supplier<QVTOTransformationExecutor> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    public QVTOTransformationExecutor getExecutor() {
        Reference<QVTOTransformationExecutor> ref2 = this.collectedExecutors.poll();
        while (ref2 != null) {
            this.availableExecutors.remove(ref2);
            ref2 = this.collectedExecutors.poll();
        }
        return this.availableExecutors.stream().map(ref -> (QVTOTransformationExecutor)ref.get()).filter(ref -> ref != null).filter(exec -> !exec.isInUse()).findFirst().orElseGet(() -> {
            QVTOTransformationExecutor exec = this.executorSupplier.get();
            this.availableExecutors.add(new SoftReference<QVTOTransformationExecutor>(exec, this.collectedExecutors));
            return exec;
        });
    }
}

