/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.storydiagram;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.SDExecutor;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.SDModelTransformation;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;

public class SDReconfigurator
extends AbstractReconfigurator {
    private static final Logger LOGGER = Logger.getLogger(SDReconfigurator.class);
    private SDExecutor sdExecutor;

    public boolean runCheck(EList<? extends ModelTransformation<? extends Object>> checks, EObject monitoredElement, IResourceTableManager resourceTableManager) {
        ArrayList<SDModelTransformation> transformations = new ArrayList<SDModelTransformation>();
        for (ModelTransformation check : checks) {
            try {
                if (!(check instanceof SDModelTransformation)) continue;
                SDModelTransformation sdModelTransformation = (SDModelTransformation)check;
                transformations.add(sdModelTransformation);
            }
            catch (ClassCastException e) {
                LOGGER.debug((Object)"Not a Storydiagram model transformation.");
            }
        }
        return this.executeTransformations(monitoredElement, transformations);
    }

    public boolean runExecute(EList<? extends ModelTransformation<? extends Object>> actions, EObject monitoredElement, IResourceTableManager resourceTableManager) {
        ArrayList<SDModelTransformation> activities = new ArrayList<SDModelTransformation>();
        LOGGER.info((Object)"Executing Story Diagram Model Transformation.");
        for (ModelTransformation action : actions) {
            try {
                if (!(action instanceof SDModelTransformation)) continue;
                SDModelTransformation sdModelTransformation = (SDModelTransformation)action;
                activities.add(sdModelTransformation);
            }
            catch (ClassCastException e) {
                LOGGER.info((Object)"Not a Storydiagram model transformation.");
            }
        }
        return this.executeTransformations(monitoredElement, activities);
    }

    private boolean executeTransformations(EObject monitoredElement, ArrayList<SDModelTransformation> transformations) {
        if (!transformations.isEmpty()) {
            LOGGER.info((Object)"Checking reconfiguration rules due to RuntimeMeasurement change");
            boolean result = this.getSDExecutor().executeTransformations(transformations, monitoredElement);
            LOGGER.info((Object)(result ? "Reconfigured system by a matching rule" : "No reconfiguration rule was executed, all conditions were false"));
            return result;
        }
        return false;
    }

    private SDExecutor getSDExecutor() {
        if (this.sdExecutor == null) {
            this.sdExecutor = new SDExecutor(this.pcmPartitionManager);
        }
        return this.sdExecutor;
    }
}

