package org.palladiosimulator.simulizar.di.component.core;

import com.google.common.collect.ImmutableSet;
import dagger.internal.DelegateFactory;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.SetFactory;
import dagger.internal.SingleCheck;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.IAssemblyAllocationLookup;
import de.uka.ipd.sdq.simucomframework.resources.ISimulatedModelEntityAccess;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResource;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simulation.AbstractSimulationConfig;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.probeframework.ProbeFrameworkContext;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.recorderframework.config.IRecorderConfigurationFactory;
import org.palladiosimulator.simulizar.di.component.dependency.QUALComponent;
import org.palladiosimulator.simulizar.di.component.dependency.SimEngineComponent;
import org.palladiosimulator.simulizar.di.component.dependency.SimuComFrameworkComponent;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.di.extension.ExtensionComponent;
import org.palladiosimulator.simulizar.di.extension.ExtensionComponentDependencyResolution;
import org.palladiosimulator.simulizar.di.extension.ExtensionLookup;
import org.palladiosimulator.simulizar.di.extension.GenericExtensionComponent;
import org.palladiosimulator.simulizar.di.modules.component.core.SimuLizarRuntimeModule_BindRegisteredComponentsFactory;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule_ProvideBootstrapExtensionsFactory;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule_ProvideExtensionFactoriesFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.CoreRuntimeExtensionBindings_ProvideCoreEntityManagersFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.CoreRuntimeExtensionBindings_ProvideCoreModelObserversFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.CoreSimulationRuntimeEntitiesBindings_ProvideEventNotificationHelperFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.CoreSimulationRuntimeEntitiesBindings_ProvidePartitionManagerFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentReconfigurationExtensionBindings_BindReconfigurationEnginesFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentReconfigurationExtensionBindings_BindReconfigurationListenerFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentReconfigurationExtensionBindings_BindReconfigurationLoadersFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_BindInterpreterListenersFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_BindInterpreterResultListenersFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_EntityManagersFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_EntityObserversFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_ModelObserversFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_ProvideDependencyResolutionFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ExtensionComponentRuntimeExtensionBindings_ProvideExtensionLookupFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.LinkingResourceSimulationModule_ProvideCalculatorFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.QUALRuntimeExtensionBindings_ProvideProbeFrameworkCleanupTaskFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ReconfiguratorBindingsModule_BindReconfigurationListenerDispatcherFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.runtime.ReconfiguratorBindingsModule_ProvideReconfiguratorFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.configuration.SimuLizarConfigurationModule_ProvideSimConfigFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.configuration.SimulationConfigBindingModule_ProvideMaxSimTimeFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.DefaultSimuLizarSimulatedThreadFactoryModule_ProvideSimulatedThreadComponentFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RuntimeComponentFactoriesModule;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RuntimeComponentFactoriesModule_ProvidesSimulatedThreadComponentFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.extension.ExtensionSupportModule_ProvidesExtensionComponentsFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.extension.ExtensionSupportModule_ProvidesGenericExtensionComponentsFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.mdsd.PCMPartitionManagerAdapterModule_ProvidesGlobalPartitionFactory;
import org.palladiosimulator.simulizar.entity.EntityReference;
import org.palladiosimulator.simulizar.entity.SimuLizarEntityReferenceFactories_LinkingResource_Factory;
import org.palladiosimulator.simulizar.entity.SimuLizarEntityReferenceFactories_ResourceContainer_Factory;
import org.palladiosimulator.simulizar.entity.SimuLizarEntityReferenceFactories_UsageScenario_Factory;
import org.palladiosimulator.simulizar.entity.access.SimulatedLinkingResourceAccess;
import org.palladiosimulator.simulizar.entity.access.SimulatedLinkingResourceAccess_Factory;
import org.palladiosimulator.simulizar.interpreter.EventDispatcher;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultRootContext;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultRootContext_Factory;
import org.palladiosimulator.simulizar.interpreter.impl.SimulatedThreadComponentDelegatingScenarioRunner;
import org.palladiosimulator.simulizar.interpreter.impl.SimulatedThreadComponentDelegatingScenarioRunner_Factory;
import org.palladiosimulator.simulizar.interpreter.impl.SimulatedThreadComponentDelegatingScenarioRunner_Factory_Impl;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionInterpreter;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionPayloadDemandCalculator;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionSimulationStrategy;
import org.palladiosimulator.simulizar.interpreter.linking.impl.DefaultSimuLizarTransmissionInterpreter;
import org.palladiosimulator.simulizar.interpreter.linking.impl.DefaultSimuLizarTransmissionInterpreter_Factory;
import org.palladiosimulator.simulizar.interpreter.linking.impl.MiddlewareCompletionAwareDemandCalculator_Factory;
import org.palladiosimulator.simulizar.interpreter.linking.impl.NoDemandCalculator_Factory;
import org.palladiosimulator.simulizar.interpreter.linking.impl.ResourceEnvironmentObservingLegacyRouter;
import org.palladiosimulator.simulizar.interpreter.linking.impl.ResourceEnvironmentObservingLegacyRouter_Factory;
import org.palladiosimulator.simulizar.interpreter.linking.impl.SimulatedLinkingResourceContainerTransmissionStrategy;
import org.palladiosimulator.simulizar.interpreter.linking.impl.SimulatedLinkingResourceContainerTransmissionStrategy_Factory;
import org.palladiosimulator.simulizar.interpreter.linking.impl.StackFrameBytesizeAccumulatingDemandCalculator_Factory;
import org.palladiosimulator.simulizar.interpreter.listener.IInterpreterListener;
import org.palladiosimulator.simulizar.interpreter.listener.InterpreterResultEventEmitter;
import org.palladiosimulator.simulizar.interpreter.listener.InterpreterResultListener;
import org.palladiosimulator.simulizar.interpreter.listener.InterpreterResultListenerDispatch;
import org.palladiosimulator.simulizar.interpreter.listener.InterpreterResultListenerDispatch_Factory;
import org.palladiosimulator.simulizar.interpreter.listener.ProbeFrameworkListener;
import org.palladiosimulator.simulizar.interpreter.listener.ProbeFrameworkListener_Factory;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultHandler;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResultMerger;
import org.palladiosimulator.simulizar.interpreter.result.impl.BasicInterpreterResultMerger_Factory;
import org.palladiosimulator.simulizar.interpreter.result.impl.NoIssuesHandler_Factory;
import org.palladiosimulator.simulizar.launcher.jobs.RunInterpreterJob;
import org.palladiosimulator.simulizar.launcher.jobs.SimuLizarRuntimeJob;
import org.palladiosimulator.simulizar.legacy.CalculatorFactoryFacade;
import org.palladiosimulator.simulizar.legacy.CalculatorFactoryFacade_Factory;
import org.palladiosimulator.simulizar.modelobserver.AllocationLookupSyncer;
import org.palladiosimulator.simulizar.modelobserver.AllocationLookupSyncer_Factory;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;
import org.palladiosimulator.simulizar.modelobserver.ResourceEnvironmentSyncer;
import org.palladiosimulator.simulizar.modelobserver.ResourceEnvironmentSyncer_Factory;
import org.palladiosimulator.simulizar.modelobserver.UsageEvolutionSyncer;
import org.palladiosimulator.simulizar.modelobserver.UsageEvolutionSyncer_Factory;
import org.palladiosimulator.simulizar.modelobserver.UsageModelSyncer;
import org.palladiosimulator.simulizar.modelobserver.UsageModelSyncer_Factory;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurationLoader;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationEngine;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.reconfiguration.NumberOfResourceContainerTrackingListener;
import org.palladiosimulator.simulizar.reconfiguration.NumberOfResourceContainerTrackingListener_Factory;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcessFactory;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcessFactory_Impl;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcess_Factory;
import org.palladiosimulator.simulizar.reconfiguration.Reconfigurator;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.runtimestate.AssemblyAllocationManager;
import org.palladiosimulator.simulizar.runtimestate.AssemblyAllocationManager_Factory;
import org.palladiosimulator.simulizar.runtimestate.ComponentInstanceRegistry;
import org.palladiosimulator.simulizar.runtimestate.ComponentInstanceRegistry_Factory;
import org.palladiosimulator.simulizar.runtimestate.PreInterpretationBehaviorManager;
import org.palladiosimulator.simulizar.runtimestate.PreInterpretationBehaviorManager_Factory;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityManager;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityObserver;
import org.palladiosimulator.simulizar.usagemodel.IScenarioRunnerFactory;
import org.palladiosimulator.simulizar.usagemodel.LoopingUsageEvolverFactory;
import org.palladiosimulator.simulizar.usagemodel.LoopingUsageEvolverFactory_Impl;
import org.palladiosimulator.simulizar.usagemodel.LoopingUsageEvolver_Factory;
import org.palladiosimulator.simulizar.usagemodel.SimulatedUsageModels;
import org.palladiosimulator.simulizar.usagemodel.SimulatedUsageModels_Factory;
import org.palladiosimulator.simulizar.usagemodel.StretchedUsageEvolverFactory;
import org.palladiosimulator.simulizar.usagemodel.StretchedUsageEvolverFactory_Impl;
import org.palladiosimulator.simulizar.usagemodel.StretchedUsageEvolver_Factory;
import org.palladiosimulator.simulizar.usagemodel.UsageEvolverFacade;
import org.palladiosimulator.simulizar.usagemodel.UsageEvolverFacade_Factory;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerSimuLizarRuntimeComponent implements SimuLizarRuntimeComponent {
  private final SimuLizarRootComponent simuLizarRootComponent;

  private final RuntimeComponentFactoriesModule runtimeComponentFactoriesModule;

  private Provider<MDSDBlackboard> blackboardProvider;

  private Provider<SimuLizarWorkflowConfiguration> configProvider;

  private Provider<PCMPartitionManager> providePartitionManagerProvider;

  private Provider<EventDispatcher> provideEventNotificationHelperProvider;

  private Provider<PCMResourceSetPartition> providesGlobalPartitionProvider;

  private Provider<AssemblyAllocationManager> assemblyAllocationManagerProvider;

  private Provider<AllocationLookupSyncer> allocationLookupSyncerProvider;

  private Provider<ResourceRegistry> resourceRegistryProvider;

  private Provider<SimuComModel> simuComModelProvider;

  private Provider<CalculatorFactoryFacade> calculatorFactoryFacadeProvider;

  private Provider<ResourceEnvironmentSyncer> resourceEnvironmentSyncerProvider;

  private Provider<ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer>> resourceContainerAccessProvider;

  private Provider<IResourceTableManager> resourceTableManagerProvider;

  private Provider<InterpreterDefaultRootContext> interpreterDefaultRootContextProvider;

  private Provider<InterpreterDefaultContext> bindMainInterpreterDefaultContextProvider;

  private Provider<SimuLizarSimulatedThreadComponent.Factory> providesSimulatedThreadComponentProvider;

  private Provider<SimuLizarRuntimeComponent> simuLizarRuntimeComponentProvider;

  private Provider<SimuComFrameworkComponent> simuComFrameworkComponentProvider;

  private Provider<SimuLizarRootComponent> simuLizarRootComponentProvider;

  private Provider<SimulatedThreadComponent.Factory> provideSimulatedThreadComponentFactoryProvider;

  private SimulatedThreadComponentDelegatingScenarioRunner_Factory simulatedThreadComponentDelegatingScenarioRunnerProvider;

  private Provider<SimulatedThreadComponentDelegatingScenarioRunner.Factory> factoryProvider;

  private Provider<IScenarioRunnerFactory<Entity>> bindScenarioRunnerFactoryProvider;

  private Provider<SimulatedUsageModels> simulatedUsageModelsProvider;

  private Provider<UsageModelSyncer> usageModelSyncerProvider;

  private Provider<ISimulationControl> simulationControlProvider;

  private Provider<ISimEventFactory> simEventFactoryProvider;

  private Provider<ISimulationTimeProvider> simTimeProvider;

  private LoopingUsageEvolver_Factory loopingUsageEvolverProvider;

  private Provider<LoopingUsageEvolverFactory> loopingUsageEvolverFactoryProvider;

  private Provider<AbstractSimulationConfig> provideSimConfigProvider;

  private Provider<Optional<Double>> provideMaxSimTimeProvider;

  private StretchedUsageEvolver_Factory stretchedUsageEvolverProvider;

  private Provider<StretchedUsageEvolverFactory> stretchedUsageEvolverFactoryProvider;

  private Provider<UsageEvolverFacade> usageEvolverFacadeProvider;

  private Provider<UsageEvolutionSyncer> usageEvolutionSyncerProvider;

  private Provider<QUALComponent> qUALComponentProvider;

  private Provider<SimEngineComponent> simEngineComponentProvider;

  private Provider<Set<Object>> bindRegisteredComponentsProvider;

  private Provider<Set<Object>> provideBootstrapExtensionsProvider;

  private Provider<Set<Object>> registeredComponentSetOfObjectProvider;

  private Provider<Set<ExtensionComponent.Factory>> provideExtensionFactoriesProvider;

  private Provider<Set<ExtensionComponent.Factory>> setOfExtensionComponentFactoryProvider;

  private Provider<ExtensionComponentDependencyResolution> provideDependencyResolutionProvider;

  private Provider<Set<ExtensionComponent>> providesExtensionComponentsProvider;

  private Provider<Set<ExtensionComponent>> setOfExtensionComponentProvider;

  private Provider<Set<GenericExtensionComponent>> providesGenericExtensionComponentsProvider;

  private Provider<Set<GenericExtensionComponent>> setOfGenericExtensionComponentProvider;

  private Provider<ExtensionLookup> provideExtensionLookupProvider;

  private Provider<Set<IModelObserver>> modelObserversProvider;

  private Provider<Set<IReconfigurationEngine>> bindReconfigurationEnginesProvider;

  private Provider<Set<IReconfigurationEngine>> setOfIReconfigurationEngineProvider;

  private Provider<Set<AbstractReconfigurationLoader>> bindReconfigurationLoadersProvider;

  private Provider<Set<AbstractReconfigurationLoader>> setOfAbstractReconfigurationLoaderProvider;

  private Provider<Reconfigurator> provideReconfiguratorProvider;

  private Provider<IReconfigurationListener> bindReconfigurationListenerDispatcherProvider;

  private ReconfigurationProcess_Factory reconfigurationProcessProvider;

  private Provider<ReconfigurationProcessFactory> reconfigurationProcessFactoryProvider;

  private Provider<Set<IReconfigurationListener>> bindReconfigurationListenerProvider;

  private Provider<IGenericCalculatorFactory> calculatorFactoryProvider;

  private Provider<NumberOfResourceContainerTrackingListener> numberOfResourceContainerTrackingListenerProvider;

  private Provider<IReconfigurationListener> bindResourceContainerCounterProvider;

  private Provider<Set<IReconfigurationListener>> setOfIReconfigurationListenerProvider;

  private Provider<Set<IInterpreterListener>> bindInterpreterListenersProvider;

  private Provider<ProbeFrameworkListener> probeFrameworkListenerProvider;

  private Provider<IInterpreterListener> bindProbeFrameworkListenerProvider;

  private Provider<ComponentInstanceRegistry> componentInstanceRegistryProvider;

  private Provider<ProbeFrameworkContext> probeFrameworkContextProvider;

  private Provider<IRecorderConfigurationFactory> recorderConfigurationFactoryProvider;

  private Provider<IObservableCalculatorRegistry> calculatorRegistryProvider;

  private Provider<RuntimeStateEntityManager> provideProbeFrameworkCleanupTaskProvider;

  private Provider<Set<RuntimeStateEntityManager>> entityManagersProvider;

  private Provider<Set<RuntimeStateEntityObserver>> entityObserversProvider;

  private Provider<ResourceEnvironmentObservingLegacyRouter> resourceEnvironmentObservingLegacyRouterProvider;

  private Provider<ITransmissionPayloadDemandCalculator<SimulatedStackframe<Object>, Double>> provideCalculatorProvider;

  private Provider<SimulatedLinkingResourceAccess> simulatedLinkingResourceAccessProvider;

  private Provider<ISimulatedModelEntityAccess<LinkingResource, SimulatedLinkingResource>> bindLinkingResourceAccessProvider;

  private Provider<SimulatedLinkingResourceContainerTransmissionStrategy> simulatedLinkingResourceContainerTransmissionStrategyProvider;

  private Provider<ITransmissionSimulationStrategy<EntityReference<LinkingResource>, Double, InterpreterDefaultContext>> bindSimulationStrategyProvider;

  private Provider<InterpreterResultHandler> bindResultHandlerProvider;

  private Provider<InterpreterResultMerger> bindResultMergerProvider;

  private Provider<PreInterpretationBehaviorManager> preInterpretationBehaviorManagerProvider;

  private Provider<DefaultSimuLizarTransmissionInterpreter<EntityReference<ResourceContainer>, SimulatedStackframe<Object>>> defaultSimuLizarTransmissionInterpreterProvider;

  private Provider<ITransmissionInterpreter<EntityReference<ResourceContainer>, SimulatedStackframe<Object>, InterpreterDefaultContext>> bindTransmissionInterpreterProvider;

  private Provider<Set<InterpreterResultListener>> bindInterpreterResultListenersProvider;

  private Provider<Set<InterpreterResultListener>> setOfInterpreterResultListenerProvider;

  private Provider<InterpreterResultListenerDispatch> interpreterResultListenerDispatchProvider;

  private Provider<InterpreterResultEventEmitter> bindEventEmitterProvider;

  private DaggerSimuLizarRuntimeComponent(
      RuntimeComponentFactoriesModule runtimeComponentFactoriesModuleParam,
      ExtensionComponentsModule extensionComponentsModuleParam,
      SimuLizarRootComponent simuLizarRootComponentParam,
      SimuComFrameworkComponent simuComFrameworkComponentParam, QUALComponent qUALComponentParam,
      SimEngineComponent simEngineComponentParam) {
    this.simuLizarRootComponent = simuLizarRootComponentParam;
    this.runtimeComponentFactoriesModule = runtimeComponentFactoriesModuleParam;
    initialize(runtimeComponentFactoriesModuleParam, extensionComponentsModuleParam, simuLizarRootComponentParam, simuComFrameworkComponentParam, qUALComponentParam, simEngineComponentParam);
  }

  public static SimuLizarRuntimeComponent.Factory factory() {
    return new Factory();
  }

  private Set<IModelObserver> provideCoreModelObservers() {
    return CoreRuntimeExtensionBindings_ProvideCoreModelObserversFactory.provideCoreModelObservers(allocationLookupSyncerProvider.get(), resourceEnvironmentSyncerProvider.get(), usageModelSyncerProvider.get(), usageEvolutionSyncerProvider.get());
  }

  private Set<IModelObserver> setOfIModelObserver() {
    return ImmutableSet.<IModelObserver>builderWithExpectedSize(3).addAll(provideCoreModelObservers()).addAll(modelObserversProvider.get()).add(provideReconfiguratorProvider.get()).build();
  }

  private Set<IInterpreterListener> setOfIInterpreterListener() {
    return ImmutableSet.<IInterpreterListener>builderWithExpectedSize(2).addAll(bindInterpreterListenersProvider.get()).add(bindProbeFrameworkListenerProvider.get()).build();
  }

  private RunInterpreterJob runInterpreterJob() {
    return new RunInterpreterJob(simuComModelProvider);
  }

  private Set<AbstractReconfigurationLoader> setOfAbstractReconfigurationLoader() {
    return ImmutableSet.<AbstractReconfigurationLoader>copyOf(bindReconfigurationLoadersProvider.get());
  }

  private Set<RuntimeStateEntityManager> provideCoreEntityManagers() {
    return CoreRuntimeExtensionBindings_ProvideCoreEntityManagersFactory.provideCoreEntityManagers(componentInstanceRegistryProvider.get(), assemblyAllocationManagerProvider.get());
  }

  private Set<RuntimeStateEntityManager> setOfRuntimeStateEntityManager() {
    return ImmutableSet.<RuntimeStateEntityManager>builderWithExpectedSize(3).addAll(provideCoreEntityManagers()).add(provideProbeFrameworkCleanupTaskProvider.get()).addAll(entityManagersProvider.get()).build();
  }

  private Set<RuntimeStateEntityObserver> setOfRuntimeStateEntityObserver() {
    return ImmutableSet.<RuntimeStateEntityObserver>copyOf(entityObserversProvider.get());
  }

  @SuppressWarnings("unchecked")
  private void initialize(
      final RuntimeComponentFactoriesModule runtimeComponentFactoriesModuleParam,
      final ExtensionComponentsModule extensionComponentsModuleParam,
      final SimuLizarRootComponent simuLizarRootComponentParam,
      final SimuComFrameworkComponent simuComFrameworkComponentParam,
      final QUALComponent qUALComponentParam, final SimEngineComponent simEngineComponentParam) {
    this.blackboardProvider = new org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_blackboard(simuLizarRootComponentParam);
    this.configProvider = new org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_config(simuLizarRootComponentParam);
    this.providePartitionManagerProvider = DoubleCheck.provider(CoreSimulationRuntimeEntitiesBindings_ProvidePartitionManagerFactory.create(blackboardProvider, configProvider));
    this.provideEventNotificationHelperProvider = DoubleCheck.provider(CoreSimulationRuntimeEntitiesBindings_ProvideEventNotificationHelperFactory.create());
    this.providesGlobalPartitionProvider = PCMPartitionManagerAdapterModule_ProvidesGlobalPartitionFactory.create(providePartitionManagerProvider);
    this.assemblyAllocationManagerProvider = DoubleCheck.provider(AssemblyAllocationManager_Factory.create());
    this.allocationLookupSyncerProvider = DoubleCheck.provider(AllocationLookupSyncer_Factory.create((Provider) SimuLizarEntityReferenceFactories_ResourceContainer_Factory.create(), providesGlobalPartitionProvider, assemblyAllocationManagerProvider));
    this.resourceRegistryProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceRegistry(simuComFrameworkComponentParam);
    this.simuComModelProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simuComModel(simuComFrameworkComponentParam);
    this.calculatorFactoryFacadeProvider = CalculatorFactoryFacade_Factory.create(simuComModelProvider);
    this.resourceEnvironmentSyncerProvider = DoubleCheck.provider(ResourceEnvironmentSyncer_Factory.create(providesGlobalPartitionProvider, resourceRegistryProvider, calculatorFactoryFacadeProvider));
    this.resourceContainerAccessProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceContainerAccess(simuComFrameworkComponentParam);
    this.resourceTableManagerProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceTableManager(simuComFrameworkComponentParam);
    this.interpreterDefaultRootContextProvider = InterpreterDefaultRootContext_Factory.create(simuComModelProvider, providePartitionManagerProvider, (Provider) assemblyAllocationManagerProvider, resourceContainerAccessProvider, resourceTableManagerProvider);
    this.bindMainInterpreterDefaultContextProvider = DoubleCheck.provider((Provider) interpreterDefaultRootContextProvider);
    this.providesSimulatedThreadComponentProvider = RuntimeComponentFactoriesModule_ProvidesSimulatedThreadComponentFactory.create(runtimeComponentFactoriesModuleParam);
    this.simuLizarRuntimeComponentProvider = InstanceFactory.create((SimuLizarRuntimeComponent) this);
    this.simuComFrameworkComponentProvider = InstanceFactory.create(simuComFrameworkComponentParam);
    this.simuLizarRootComponentProvider = InstanceFactory.create(simuLizarRootComponentParam);
    this.provideSimulatedThreadComponentFactoryProvider = DefaultSimuLizarSimulatedThreadFactoryModule_ProvideSimulatedThreadComponentFactoryFactory.create(providesSimulatedThreadComponentProvider, simuLizarRuntimeComponentProvider, simuComFrameworkComponentProvider, simuLizarRootComponentProvider);
    this.simulatedThreadComponentDelegatingScenarioRunnerProvider = SimulatedThreadComponentDelegatingScenarioRunner_Factory.create(provideSimulatedThreadComponentFactoryProvider, bindMainInterpreterDefaultContextProvider);
    this.factoryProvider = SimulatedThreadComponentDelegatingScenarioRunner_Factory_Impl.create(simulatedThreadComponentDelegatingScenarioRunnerProvider);
    this.bindScenarioRunnerFactoryProvider = DoubleCheck.provider((Provider) factoryProvider);
    this.simulatedUsageModelsProvider = SimulatedUsageModels_Factory.create(bindMainInterpreterDefaultContextProvider, providesGlobalPartitionProvider, simuComModelProvider, resourceTableManagerProvider, (Provider) SimuLizarEntityReferenceFactories_UsageScenario_Factory.create(), bindScenarioRunnerFactoryProvider);
    this.usageModelSyncerProvider = DoubleCheck.provider(UsageModelSyncer_Factory.create(providesGlobalPartitionProvider, simulatedUsageModelsProvider));
    this.simulationControlProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simulationControl(simuComFrameworkComponentParam);
    this.simEventFactoryProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimEngineComponent_simEventFactory(simEngineComponentParam);
    this.simTimeProvider = new org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simTimeProvider(simuComFrameworkComponentParam);
    this.loopingUsageEvolverProvider = LoopingUsageEvolver_Factory.create(providesGlobalPartitionProvider, simEventFactoryProvider, simTimeProvider);
    this.loopingUsageEvolverFactoryProvider = LoopingUsageEvolverFactory_Impl.create(loopingUsageEvolverProvider);
    this.provideSimConfigProvider = SimuLizarConfigurationModule_ProvideSimConfigFactory.create(configProvider);
    this.provideMaxSimTimeProvider = SimulationConfigBindingModule_ProvideMaxSimTimeFactory.create(provideSimConfigProvider);
    this.stretchedUsageEvolverProvider = StretchedUsageEvolver_Factory.create(provideMaxSimTimeProvider, providesGlobalPartitionProvider, simEventFactoryProvider, simTimeProvider);
    this.stretchedUsageEvolverFactoryProvider = StretchedUsageEvolverFactory_Impl.create(stretchedUsageEvolverProvider);
    this.usageEvolverFacadeProvider = DoubleCheck.provider(UsageEvolverFacade_Factory.create(simulationControlProvider, loopingUsageEvolverFactoryProvider, stretchedUsageEvolverFactoryProvider, (Provider) SimuLizarEntityReferenceFactories_UsageScenario_Factory.create()));
    this.usageEvolutionSyncerProvider = DoubleCheck.provider(UsageEvolutionSyncer_Factory.create(providesGlobalPartitionProvider, usageEvolverFacadeProvider));
    this.qUALComponentProvider = InstanceFactory.create(qUALComponentParam);
    this.simEngineComponentProvider = InstanceFactory.create(simEngineComponentParam);
    this.bindRegisteredComponentsProvider = DoubleCheck.provider(SimuLizarRuntimeModule_BindRegisteredComponentsFactory.create(simuLizarRootComponentProvider, simuComFrameworkComponentProvider, qUALComponentProvider, simEngineComponentProvider, simuLizarRuntimeComponentProvider));
    this.provideBootstrapExtensionsProvider = ExtensionComponentsModule_ProvideBootstrapExtensionsFactory.create(extensionComponentsModuleParam);
    this.registeredComponentSetOfObjectProvider = SetFactory.<Object>builder(0, 2).addCollectionProvider(bindRegisteredComponentsProvider).addCollectionProvider(provideBootstrapExtensionsProvider).build();
    this.provideExtensionFactoriesProvider = ExtensionComponentsModule_ProvideExtensionFactoriesFactory.create(extensionComponentsModuleParam);
    this.setOfExtensionComponentFactoryProvider = SetFactory.<ExtensionComponent.Factory>builder(0, 1).addCollectionProvider(provideExtensionFactoriesProvider).build();
    this.provideDependencyResolutionProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_ProvideDependencyResolutionFactory.create(registeredComponentSetOfObjectProvider, setOfExtensionComponentFactoryProvider));
    this.providesExtensionComponentsProvider = ExtensionSupportModule_ProvidesExtensionComponentsFactory.create(provideDependencyResolutionProvider);
    this.setOfExtensionComponentProvider = SetFactory.<ExtensionComponent>builder(0, 1).addCollectionProvider(providesExtensionComponentsProvider).build();
    this.providesGenericExtensionComponentsProvider = ExtensionSupportModule_ProvidesGenericExtensionComponentsFactory.create(setOfExtensionComponentProvider);
    this.setOfGenericExtensionComponentProvider = SetFactory.<GenericExtensionComponent>builder(0, 1).addCollectionProvider(providesGenericExtensionComponentsProvider).build();
    this.provideExtensionLookupProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_ProvideExtensionLookupFactory.create(setOfGenericExtensionComponentProvider));
    this.modelObserversProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_ModelObserversFactory.create(provideExtensionLookupProvider));
    this.bindReconfigurationEnginesProvider = DoubleCheck.provider(ExtensionComponentReconfigurationExtensionBindings_BindReconfigurationEnginesFactory.create(provideExtensionLookupProvider));
    this.setOfIReconfigurationEngineProvider = SetFactory.<IReconfigurationEngine>builder(0, 1).addCollectionProvider(bindReconfigurationEnginesProvider).build();
    this.bindReconfigurationLoadersProvider = DoubleCheck.provider(ExtensionComponentReconfigurationExtensionBindings_BindReconfigurationLoadersFactory.create(provideExtensionLookupProvider));
    this.setOfAbstractReconfigurationLoaderProvider = SetFactory.<AbstractReconfigurationLoader>builder(0, 1).addCollectionProvider(bindReconfigurationLoadersProvider).build();
    this.provideReconfiguratorProvider = new DelegateFactory<>();
    this.bindReconfigurationListenerDispatcherProvider = ReconfiguratorBindingsModule_BindReconfigurationListenerDispatcherFactory.create(provideReconfiguratorProvider);
    this.reconfigurationProcessProvider = ReconfigurationProcess_Factory.create(simuComModelProvider, setOfIReconfigurationEngineProvider, setOfAbstractReconfigurationLoaderProvider, configProvider, bindReconfigurationListenerDispatcherProvider, resourceTableManagerProvider, simTimeProvider);
    this.reconfigurationProcessFactoryProvider = ReconfigurationProcessFactory_Impl.create(reconfigurationProcessProvider);
    this.bindReconfigurationListenerProvider = DoubleCheck.provider(ExtensionComponentReconfigurationExtensionBindings_BindReconfigurationListenerFactory.create(provideExtensionLookupProvider));
    this.calculatorFactoryProvider = new org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_calculatorFactory(qUALComponentParam);
    this.numberOfResourceContainerTrackingListenerProvider = NumberOfResourceContainerTrackingListener_Factory.create(simulationControlProvider, providesGlobalPartitionProvider, calculatorFactoryProvider);
    this.bindResourceContainerCounterProvider = DoubleCheck.provider((Provider) numberOfResourceContainerTrackingListenerProvider);
    this.setOfIReconfigurationListenerProvider = SetFactory.<IReconfigurationListener>builder(1, 1).addCollectionProvider(bindReconfigurationListenerProvider).addProvider(bindResourceContainerCounterProvider).build();
    DelegateFactory.setDelegate(provideReconfiguratorProvider, DoubleCheck.provider(ReconfiguratorBindingsModule_ProvideReconfiguratorFactory.create(providesGlobalPartitionProvider, reconfigurationProcessFactoryProvider, simTimeProvider, setOfIReconfigurationListenerProvider)));
    this.bindInterpreterListenersProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_BindInterpreterListenersFactory.create(provideExtensionLookupProvider));
    this.probeFrameworkListenerProvider = ProbeFrameworkListener_Factory.create(providePartitionManagerProvider, simuComModelProvider, provideReconfiguratorProvider);
    this.bindProbeFrameworkListenerProvider = DoubleCheck.provider((Provider) probeFrameworkListenerProvider);
    this.componentInstanceRegistryProvider = DoubleCheck.provider(ComponentInstanceRegistry_Factory.create());
    this.probeFrameworkContextProvider = new org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_probeFrameworkContext(qUALComponentParam);
    this.recorderConfigurationFactoryProvider = new org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_recorderConfigurationFactory(qUALComponentParam);
    this.calculatorRegistryProvider = new org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_calculatorRegistry(qUALComponentParam);
    this.provideProbeFrameworkCleanupTaskProvider = DoubleCheck.provider(QUALRuntimeExtensionBindings_ProvideProbeFrameworkCleanupTaskFactory.create(configProvider, probeFrameworkContextProvider, recorderConfigurationFactoryProvider, calculatorRegistryProvider));
    this.entityManagersProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_EntityManagersFactory.create(provideExtensionLookupProvider));
    this.entityObserversProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_EntityObserversFactory.create(provideExtensionLookupProvider));
    this.resourceEnvironmentObservingLegacyRouterProvider = DoubleCheck.provider(ResourceEnvironmentObservingLegacyRouter_Factory.create(providesGlobalPartitionProvider, (Provider) SimuLizarEntityReferenceFactories_LinkingResource_Factory.create()));
    this.provideCalculatorProvider = LinkingResourceSimulationModule_ProvideCalculatorFactory.create(configProvider, NoDemandCalculator_Factory.create(), MiddlewareCompletionAwareDemandCalculator_Factory.create(), StackFrameBytesizeAccumulatingDemandCalculator_Factory.create());
    this.simulatedLinkingResourceAccessProvider = SimulatedLinkingResourceAccess_Factory.create(resourceRegistryProvider);
    this.bindLinkingResourceAccessProvider = SingleCheck.provider((Provider) simulatedLinkingResourceAccessProvider);
    this.simulatedLinkingResourceContainerTransmissionStrategyProvider = SimulatedLinkingResourceContainerTransmissionStrategy_Factory.create(bindLinkingResourceAccessProvider);
    this.bindSimulationStrategyProvider = SingleCheck.provider((Provider) simulatedLinkingResourceContainerTransmissionStrategyProvider);
    this.bindResultHandlerProvider = DoubleCheck.provider((Provider) NoIssuesHandler_Factory.create());
    this.bindResultMergerProvider = DoubleCheck.provider((Provider) BasicInterpreterResultMerger_Factory.create());
    this.preInterpretationBehaviorManagerProvider = DoubleCheck.provider(PreInterpretationBehaviorManager_Factory.create(bindResultMergerProvider));
    this.defaultSimuLizarTransmissionInterpreterProvider = DefaultSimuLizarTransmissionInterpreter_Factory.create((Provider) resourceEnvironmentObservingLegacyRouterProvider, provideCalculatorProvider, bindSimulationStrategyProvider, bindResultHandlerProvider, bindResultMergerProvider, preInterpretationBehaviorManagerProvider);
    this.bindTransmissionInterpreterProvider = SingleCheck.provider((Provider) defaultSimuLizarTransmissionInterpreterProvider);
    this.bindInterpreterResultListenersProvider = DoubleCheck.provider(ExtensionComponentRuntimeExtensionBindings_BindInterpreterResultListenersFactory.create(provideExtensionLookupProvider));
    this.setOfInterpreterResultListenerProvider = SetFactory.<InterpreterResultListener>builder(0, 1).addCollectionProvider(bindInterpreterResultListenersProvider).build();
    this.interpreterResultListenerDispatchProvider = InterpreterResultListenerDispatch_Factory.create(setOfInterpreterResultListenerProvider);
    this.bindEventEmitterProvider = DoubleCheck.provider((Provider) interpreterResultListenerDispatchProvider);
  }

  @Override
  public SimuLizarRuntimeJob runtimeJob() {
    return new SimuLizarRuntimeJob(Preconditions.checkNotNullFromComponent(simuLizarRootComponent.config()), providePartitionManagerProvider.get(), provideEventNotificationHelperProvider.get(), setOfIModelObserver(), setOfIInterpreterListener(), runInterpreterJob(), setOfAbstractReconfigurationLoader(), setOfRuntimeStateEntityManager(), setOfRuntimeStateEntityObserver());
  }

  @Override
  public PCMPartitionManager globalPartitionManager() {
    return providePartitionManagerProvider.get();
  }

  @Override
  public PCMResourceSetPartition globalPCMModel() {
    return PCMPartitionManagerAdapterModule_ProvidesGlobalPartitionFactory.providesGlobalPartition(providePartitionManagerProvider.get());
  }

  @Override
  public IAssemblyAllocationLookup<EntityReference<ResourceContainer>> resourceContainerLookup() {
    return assemblyAllocationManagerProvider.get();
  }

  @Override
  public ComponentInstanceRegistry componentInstanceRegistry() {
    return componentInstanceRegistryProvider.get();
  }

  @Override
  public AssemblyAllocationManager allocationManager() {
    return assemblyAllocationManagerProvider.get();
  }

  @Override
  public EventDispatcher eventDispatcher() {
    return provideEventNotificationHelperProvider.get();
  }

  @Override
  public InterpreterDefaultContext mainContext() {
    return bindMainInterpreterDefaultContextProvider.get();
  }

  @Override
  public SimulatedThreadComponent.Factory interpreterThreadComponentFactory() {
    return DefaultSimuLizarSimulatedThreadFactoryModule_ProvideSimulatedThreadComponentFactoryFactory.provideSimulatedThreadComponentFactory(RuntimeComponentFactoriesModule_ProvidesSimulatedThreadComponentFactory.providesSimulatedThreadComponent(runtimeComponentFactoriesModule), simuLizarRuntimeComponentProvider, simuComFrameworkComponentProvider, simuLizarRootComponentProvider);
  }

  @Override
  public ITransmissionInterpreter<EntityReference<ResourceContainer>, SimulatedStackframe<Object>, InterpreterDefaultContext> transmissionInterpreter(
      ) {
    return bindTransmissionInterpreterProvider.get();
  }

  @Override
  public ExtensionLookup runtimeExtensionLookup() {
    return provideExtensionLookupProvider.get();
  }

  @Override
  public InterpreterResultMerger merger() {
    return bindResultMergerProvider.get();
  }

  @Override
  public InterpreterResultHandler resultHandler() {
    return bindResultHandlerProvider.get();
  }

  @Override
  public InterpreterResultEventEmitter resultEventEmitter() {
    return bindEventEmitterProvider.get();
  }

  @Override
  public PreInterpretationBehaviorManager preInterpretationBehaviorManager() {
    return preInterpretationBehaviorManagerProvider.get();
  }

  private static final class Factory implements SimuLizarRuntimeComponent.Factory {
    @Override
    public SimuLizarRuntimeComponent create(SimuLizarRootComponent rootComponent,
        SimuComFrameworkComponent frameworkComponent, QUALComponent qualComponent,
        SimEngineComponent simEngineComponent, ExtensionComponentsModule extensionModule,
        RuntimeComponentFactoriesModule componentFactoriesModule) {
      Preconditions.checkNotNull(rootComponent);
      Preconditions.checkNotNull(frameworkComponent);
      Preconditions.checkNotNull(qualComponent);
      Preconditions.checkNotNull(simEngineComponent);
      Preconditions.checkNotNull(extensionModule);
      Preconditions.checkNotNull(componentFactoriesModule);
      return new DaggerSimuLizarRuntimeComponent(componentFactoriesModule, extensionModule, rootComponent, frameworkComponent, qualComponent, simEngineComponent);
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_blackboard implements Provider<MDSDBlackboard> {
    private final SimuLizarRootComponent simuLizarRootComponent;

    org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_blackboard(
        SimuLizarRootComponent simuLizarRootComponent) {
      this.simuLizarRootComponent = simuLizarRootComponent;
    }

    @Override
    public MDSDBlackboard get() {
      return Preconditions.checkNotNullFromComponent(simuLizarRootComponent.blackboard());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_config implements Provider<SimuLizarWorkflowConfiguration> {
    private final SimuLizarRootComponent simuLizarRootComponent;

    org_palladiosimulator_simulizar_di_component_core_SimuLizarRootComponent_config(
        SimuLizarRootComponent simuLizarRootComponent) {
      this.simuLizarRootComponent = simuLizarRootComponent;
    }

    @Override
    public SimuLizarWorkflowConfiguration get() {
      return Preconditions.checkNotNullFromComponent(simuLizarRootComponent.config());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceRegistry implements Provider<ResourceRegistry> {
    private final SimuComFrameworkComponent simuComFrameworkComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceRegistry(
        SimuComFrameworkComponent simuComFrameworkComponent) {
      this.simuComFrameworkComponent = simuComFrameworkComponent;
    }

    @Override
    public ResourceRegistry get() {
      return Preconditions.checkNotNullFromComponent(simuComFrameworkComponent.resourceRegistry());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simuComModel implements Provider<SimuComModel> {
    private final SimuComFrameworkComponent simuComFrameworkComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simuComModel(
        SimuComFrameworkComponent simuComFrameworkComponent) {
      this.simuComFrameworkComponent = simuComFrameworkComponent;
    }

    @Override
    public SimuComModel get() {
      return Preconditions.checkNotNullFromComponent(simuComFrameworkComponent.simuComModel());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceContainerAccess implements Provider<ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer>> {
    private final SimuComFrameworkComponent simuComFrameworkComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceContainerAccess(
        SimuComFrameworkComponent simuComFrameworkComponent) {
      this.simuComFrameworkComponent = simuComFrameworkComponent;
    }

    @Override
    public ISimulatedModelEntityAccess<ResourceContainer, AbstractSimulatedResourceContainer> get(
        ) {
      return Preconditions.checkNotNullFromComponent(simuComFrameworkComponent.resourceContainerAccess());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceTableManager implements Provider<IResourceTableManager> {
    private final SimuComFrameworkComponent simuComFrameworkComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_resourceTableManager(
        SimuComFrameworkComponent simuComFrameworkComponent) {
      this.simuComFrameworkComponent = simuComFrameworkComponent;
    }

    @Override
    public IResourceTableManager get() {
      return Preconditions.checkNotNullFromComponent(simuComFrameworkComponent.resourceTableManager());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simulationControl implements Provider<ISimulationControl> {
    private final SimuComFrameworkComponent simuComFrameworkComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simulationControl(
        SimuComFrameworkComponent simuComFrameworkComponent) {
      this.simuComFrameworkComponent = simuComFrameworkComponent;
    }

    @Override
    public ISimulationControl get() {
      return Preconditions.checkNotNullFromComponent(simuComFrameworkComponent.simulationControl());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimEngineComponent_simEventFactory implements Provider<ISimEventFactory> {
    private final SimEngineComponent simEngineComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimEngineComponent_simEventFactory(
        SimEngineComponent simEngineComponent) {
      this.simEngineComponent = simEngineComponent;
    }

    @Override
    public ISimEventFactory get() {
      return Preconditions.checkNotNullFromComponent(simEngineComponent.simEventFactory());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simTimeProvider implements Provider<ISimulationTimeProvider> {
    private final SimuComFrameworkComponent simuComFrameworkComponent;

    org_palladiosimulator_simulizar_di_component_dependency_SimuComFrameworkComponent_simTimeProvider(
        SimuComFrameworkComponent simuComFrameworkComponent) {
      this.simuComFrameworkComponent = simuComFrameworkComponent;
    }

    @Override
    public ISimulationTimeProvider get() {
      return Preconditions.checkNotNullFromComponent(simuComFrameworkComponent.simTimeProvider());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_calculatorFactory implements Provider<IGenericCalculatorFactory> {
    private final QUALComponent qUALComponent;

    org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_calculatorFactory(
        QUALComponent qUALComponent) {
      this.qUALComponent = qUALComponent;
    }

    @Override
    public IGenericCalculatorFactory get() {
      return Preconditions.checkNotNullFromComponent(qUALComponent.calculatorFactory());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_probeFrameworkContext implements Provider<ProbeFrameworkContext> {
    private final QUALComponent qUALComponent;

    org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_probeFrameworkContext(
        QUALComponent qUALComponent) {
      this.qUALComponent = qUALComponent;
    }

    @Override
    public ProbeFrameworkContext get() {
      return Preconditions.checkNotNullFromComponent(qUALComponent.probeFrameworkContext());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_recorderConfigurationFactory implements Provider<IRecorderConfigurationFactory> {
    private final QUALComponent qUALComponent;

    org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_recorderConfigurationFactory(
        QUALComponent qUALComponent) {
      this.qUALComponent = qUALComponent;
    }

    @Override
    public IRecorderConfigurationFactory get() {
      return Preconditions.checkNotNullFromComponent(qUALComponent.recorderConfigurationFactory());
    }
  }

  private static class org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_calculatorRegistry implements Provider<IObservableCalculatorRegistry> {
    private final QUALComponent qUALComponent;

    org_palladiosimulator_simulizar_di_component_dependency_QUALComponent_calculatorRegistry(
        QUALComponent qUALComponent) {
      this.qUALComponent = qUALComponent;
    }

    @Override
    public IObservableCalculatorRegistry get() {
      return Preconditions.checkNotNullFromComponent(qUALComponent.calculatorRegistry());
    }
  }
}
