/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.di.extension;

import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.simulizar.di.extension.ExtensionComponent;

public class GenericExtensionComponent {
    private ExtensionComponent decoratedComponent;

    public GenericExtensionComponent(ExtensionComponent decoratedComponent) {
        this.decoratedComponent = decoratedComponent;
    }

    public <T> Supplier<Set<T>> getExtensions(Class<T> extensionsType) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Set supplierMethods = Arrays.asList(this.decoratedComponent.getClass().getMethods()).stream().filter(m -> m.getParameterCount() == 0 && this.isCompatibleSignature(m.getGenericReturnType(), extensionsType)).collect(Collectors.toSet());
        Set singleMethods = supplierMethods.stream().filter(m -> extensionsType.isAssignableFrom(m.getReturnType())).collect(Collectors.toSet());
        Sets.SetView iterableMethods = Sets.difference(supplierMethods, singleMethods);
        Stream<Supplier> singleSuppliers = singleMethods.stream().map(m -> this.createSupplier((Method)m, lookup));
        Stream<Supplier> iterableSuppliers = iterableMethods.stream().map(m -> this.createSupplier((Method)m, lookup));
        return () -> Streams.concat((Stream[])new Stream[]{singleSuppliers.map(Supplier::get), iterableSuppliers.map(Supplier::get).flatMap(Streams::stream)}).collect(Collectors.toSet());
    }

    private <T> boolean isCompatibleSignature(Type type, Class<T> extensionsType) {
        ParameterizedType paramType;
        if (type instanceof Class) {
            return extensionsType.isAssignableFrom((Class)type);
        }
        if (type instanceof ParameterizedType && (paramType = (ParameterizedType)type).getRawType() instanceof Class && paramType.getActualTypeArguments().length == 1) {
            return Iterable.class.isAssignableFrom((Class)paramType.getRawType()) && extensionsType.isAssignableFrom((Class)paramType.getActualTypeArguments()[0]);
        }
        return false;
    }

    private <T> Supplier<T> createSupplier(Method m, MethodHandles.Lookup lookup) {
        try {
            MethodHandle handle = lookup.unreflect(m);
            return () -> {
                try {
                    return handle.invoke(this.decoratedComponent);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

