/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.listener;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractInterpreterListener;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractRecordingProbeFrameworkListenerDecorator;
import org.palladiosimulator.simulizar.interpreter.listener.AssemblyProvidedOperationPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.ModelElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.RDSEFFElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.SystemOperationPassedEvent;
import org.palladiosimulator.simulizar.reconfiguration.Reconfigurator;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

public abstract class AbstractProbeFrameworkListener
extends AbstractInterpreterListener {
    private static final int START_PROBE_INDEX = 0;
    private static final int STOP_PROBE_INDEX = 1;
    protected final SimuComModel simuComModel;
    protected final IGenericCalculatorFactory calculatorFactory;
    protected final Reconfigurator reconfigurator;
    private final PCMPartitionManager pcmPartitionManager;
    private final Map<String, List<TriggeredProbe>> currentTimeProbes = new HashMap<String, List<TriggeredProbe>>();

    public AbstractProbeFrameworkListener(PCMPartitionManager pcmPartitionManager, SimuComModel simuComModel, Reconfigurator reconfigurator) {
        this.pcmPartitionManager = Objects.requireNonNull(pcmPartitionManager);
        this.calculatorFactory = Objects.requireNonNull(simuComModel).getProbeFrameworkContext().getGenericCalculatorFactory();
        this.simuComModel = simuComModel;
        this.reconfigurator = Objects.requireNonNull(reconfigurator);
    }

    @Override
    public void initialize() {
        this.initResponseTimeMeasurements();
        this.initReconfigurationTimeMeasurement();
        this.initExtensionMeasurements();
    }

    private void initExtensionMeasurements() {
        List extensions = ExtensionHelper.getExecutableExtensions((String)"org.palladiosimulator.simulizar.interpreter.listener.probeframework", (String)"decorator");
        for (AbstractRecordingProbeFrameworkListenerDecorator decorator : extensions) {
            decorator.setProbeFrameworkListener(this);
            decorator.registerMeasurements();
        }
    }

    @Override
    public void beginUsageScenarioInterpretation(ModelElementPassedEvent<UsageScenario> event) {
        this.startMeasurement(event);
    }

    @Override
    public void endUsageScenarioInterpretation(ModelElementPassedEvent<UsageScenario> event) {
        this.endMeasurement(event);
    }

    @Override
    public void beginEntryLevelSystemCallInterpretation(ModelElementPassedEvent<EntryLevelSystemCall> event) {
        this.startMeasurement(event);
    }

    @Override
    public void endEntryLevelSystemCallInterpretation(ModelElementPassedEvent<EntryLevelSystemCall> event) {
        this.endMeasurement(event);
    }

    @Override
    public void beginExternalCallInterpretation(RDSEFFElementPassedEvent<ExternalCallAction> event) {
        this.startMeasurement(event);
    }

    @Override
    public void endExternalCallInterpretation(RDSEFFElementPassedEvent<ExternalCallAction> event) {
        this.endMeasurement(event);
    }

    @Override
    public <T extends EObject> void beginUnknownElementInterpretation(ModelElementPassedEvent<T> event) {
    }

    @Override
    public <T extends EObject> void endUnknownElementInterpretation(ModelElementPassedEvent<T> event) {
    }

    public SimuComModel getSimuComModel() {
        return this.simuComModel;
    }

    public PCMPartitionManager getPCMPartitionManager() {
        return this.pcmPartitionManager;
    }

    public Collection<MeasurementSpecification> getMeasurementSpecificationsForMetricDescription(MetricDescription soughtFor) {
        Objects.requireNonNull(soughtFor, "Given MetricDescription must not be null.");
        return this.filterMeasurementSpecifications(m -> MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)m.getMetricDescription(), (MetricDescription)soughtFor));
    }

    public Collection<MeasurementSpecification> getMeasurementSpecificationsForProcessingType(EClass processingTypeEClass) {
        Objects.requireNonNull(processingTypeEClass, "Given EClass object must not be null.");
        if (!MonitorRepositoryPackage.Literals.PROCESSING_TYPE.isSuperTypeOf(processingTypeEClass)) {
            throw new IllegalArgumentException("Given EClass object does not represent a " + MonitorRepositoryPackage.Literals.PROCESSING_TYPE.getName() + "!");
        }
        return this.filterMeasurementSpecifications(m -> processingTypeEClass.isInstance((Object)m.getProcessingType()));
    }

    private Collection<MeasurementSpecification> filterMeasurementSpecifications(Predicate<? super MeasurementSpecification> predicate) {
        assert (predicate != null);
        MonitorRepository monitorRepositoryModel = (MonitorRepository)this.pcmPartitionManager.findModel(MonitorRepositoryPackage.eINSTANCE.getMonitorRepository());
        if (monitorRepositoryModel != null) {
            return monitorRepositoryModel.getMonitors().stream().filter(Monitor::isActivated).flatMap(monitor -> monitor.getMeasurementSpecifications().stream()).filter(predicate).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return Collections.emptyList();
    }

    private void initResponseTimeMeasurements() {
        for (MeasurementSpecification responseTimeMeasurementSpec : this.getMeasurementSpecificationsForMetricDescription((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC)) {
            MeasuringPoint measuringPoint = responseTimeMeasurementSpec.getMonitor().getMeasuringPoint();
            List<Probe> probes = this.createStartAndStopProbe(measuringPoint, this.simuComModel);
            this.calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration((Probe)probes.get(0), (Probe)probes.get(1)));
        }
    }

    protected List<Probe> createStartAndStopProbe(MeasuringPoint measuringPoint, SimuComModel simuComModel) {
        ArrayList<Probe> probeList = new ArrayList<Probe>(2);
        probeList.add((Probe)new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)simuComModel.getSimulationControl()));
        probeList.add((Probe)new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)simuComModel.getSimulationControl()));
        this.currentTimeProbes.put(MonitorRepositoryUtil.getMeasurementIdentifier(measuringPoint), Collections.unmodifiableList(probeList));
        return probeList;
    }

    protected boolean entityIsAlreadyInstrumented(EObject modelElement) {
        return this.currentTimeProbes.containsKey(((Entity)modelElement).getId());
    }

    private <T extends Entity> void startMeasurement(ModelElementPassedEvent<T> event) {
        if (this.currentTimeProbes.containsKey(((Entity)event.getModelElement()).getId()) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(((Entity)event.getModelElement()).getId()).get(0).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    private <T extends Entity> void endMeasurement(ModelElementPassedEvent<T> event) {
        if (this.currentTimeProbes.containsKey(((Entity)event.getModelElement()).getId()) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(((Entity)event.getModelElement()).getId()).get(1).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    @Override
    public <T extends System, R extends ProvidedRole, S extends Signature> void beginSystemOperationCallInterpretation(SystemOperationPassedEvent<T, R, S> event) {
        String key = this.calcSystemOperationMeasuringPointId(event);
        if (this.currentTimeProbes.containsKey(key) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(key).get(0).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    @Override
    public <T extends System, R extends ProvidedRole, S extends Signature> void endSystemOperationCallInterpretation(SystemOperationPassedEvent<T, R, S> event) {
        String key = this.calcSystemOperationMeasuringPointId(event);
        if (this.currentTimeProbes.containsKey(key) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(key).get(1).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    @Override
    public <T extends AssemblyContext, R extends ProvidedRole, S extends Signature> void beginAssemblyProvidedOperationCallInterpretation(AssemblyProvidedOperationPassedEvent<T, R, S> event) {
        String key = this.calcAssemblyProvidedOperationMeasuringPointId(event);
        if (this.currentTimeProbes.containsKey(key) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(key).get(0).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    @Override
    public <T extends AssemblyContext, R extends ProvidedRole, S extends Signature> void endAssemblyProvidedOperationCallInterpretation(AssemblyProvidedOperationPassedEvent<T, R, S> event) {
        String key = this.calcAssemblyProvidedOperationMeasuringPointId(event);
        if (this.currentTimeProbes.containsKey(key) && this.simulationIsRunning()) {
            this.currentTimeProbes.get(key).get(1).takeMeasurement(event.getThread().getRequestContext());
        }
    }

    protected abstract void initReconfigurationTimeMeasurement();

    private boolean simulationIsRunning() {
        return this.simuComModel.getSimulationControl().isRunning();
    }

    private String calcSystemOperationMeasuringPointId(SystemOperationPassedEvent event) {
        return String.valueOf(event.getSystem().getId()) + "::" + event.getProvidedRole().getId() + "::" + event.getSignature().getId();
    }

    private String calcAssemblyProvidedOperationMeasuringPointId(AssemblyProvidedOperationPassedEvent event) {
        return String.valueOf(event.getAssemblyContext().getId()) + "::" + event.getProvidedRole().getId() + "::" + event.getSignature().getId();
    }
}

