/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectivePackage;
import org.palladiosimulator.servicelevelobjective.edp2.mappers.SLOViolationEDP2DatasourceMapper;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class EvaluateResultsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private final Logger LOGGER = Logger.getLogger(EvaluateResultsJob.class);
    private final SimuLizarWorkflowConfiguration configuration;
    private ExperimentSetting experimentSetting;
    private EList<ServiceLevelObjective> serviceLevelObjectives;

    @Inject
    public EvaluateResultsJob(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor progressMonitor) throws JobFailedException, UserCanceledException {
        this.serviceLevelObjectives = this.filterSloRepo().getServicelevelobjectives();
        if (this.serviceLevelObjectives == null) {
            this.LOGGER.info((Object)"No Service level objectives provided. Skipping evaluation of experiment data");
        } else {
            String repositoryId = (String)this.configuration.getAttributes().get("EDP2RepositoryID");
            String basename = this.configuration.getSimulationConfiguration().getNameBase();
            String variation = this.configuration.getSimulationConfiguration().getVariationId();
            progressMonitor.beginTask("SLO Validation", 0);
            Repository repository = RepositoryManager.getRepositoryFromUUID((String)repositoryId);
            ExperimentGroup experimentGroup = this.getExperimentGroup(repository, basename);
            this.experimentSetting = this.getExperimentSetting(experimentGroup, variation);
            this.LOGGER.info((Object)("Evaluating data in repository " + repository.getId() + " in experiment run " + basename));
            int lastExperiment = this.experimentSetting.getExperimentRuns().size() - 1;
            this.experimentSetting.getExperimentRuns().get(lastExperiment);
            double[] sloViolations = this.computeSloViolations();
            if (sloViolations[1] == 0.0) {
                this.LOGGER.info((Object)"THE STATE WITH NO SLO VIOLATIONS WAS REACHED.");
            }
            this.LOGGER.info((Object)(String.valueOf(sloViolations[0]) + " Measurements evaluated for " + sloViolations[1] + " Service Level Objectives. " + sloViolations[2] + " Failed." + " Average fulfillment grade:  " + sloViolations[3]));
            progressMonitor.done();
        }
    }

    private ServiceLevelObjectiveRepository filterSloRepo() {
        PCMResourceSetPartition partition = (PCMResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition");
        if (partition == null) {
            return null;
        }
        EClass targetType = ServicelevelObjectivePackage.eINSTANCE.getServiceLevelObjectiveRepository();
        List sloRepos = partition.getElement(targetType);
        return sloRepos.isEmpty() ? null : (ServiceLevelObjectiveRepository)sloRepos.get(0);
    }

    public String getName() {
        return "Evaluating Analysis Results";
    }

    private double[] computeSloViolations() {
        int lastExperiment = this.experimentSetting.getExperimentRuns().size() - 1;
        ExperimentRun experimentRun = (ExperimentRun)this.experimentSetting.getExperimentRuns().get(lastExperiment);
        double totalMeasurements = 0.0;
        double sloViolations = 0.0;
        double sloGradeSum = 0.0;
        double numberOfSlos = 0.0;
        for (ServiceLevelObjective serviceLevelObjective : this.serviceLevelObjectives) {
            numberOfSlos += 1.0;
            Measurement measurement = this.findMeasurement((List<Measurement>)experimentRun.getMeasurement(), serviceLevelObjective);
            RawMeasurements rawMeasurements = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements();
            HashMap<String, ServiceLevelObjective> properties = new HashMap<String, ServiceLevelObjective>(1);
            properties.put("serviceLevelObjective", serviceLevelObjective);
            Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(rawMeasurements);
            MetricDescription metricDescription = dataSource.getMetricDesciption();
            SLOViolationEDP2DatasourceMapper sloMapper = new SLOViolationEDP2DatasourceMapper((IDataSource)dataSource, metricDescription);
            sloMapper.setProperties(properties);
            totalMeasurements += (double)dataSource.getDataStream().size();
            HashMap evaluatedGrades = sloMapper.getMapping();
            for (Map.Entry entry : evaluatedGrades.entrySet()) {
                sloGradeSum += ((Double)entry.getValue()).doubleValue();
                if ((Double)entry.getValue() != 0.0) continue;
                sloViolations += 1.0;
            }
        }
        double[] result = new double[4];
        if (numberOfSlos > 0.0) {
            result[0] = totalMeasurements / numberOfSlos;
        }
        result[1] = numberOfSlos;
        result[2] = sloViolations;
        result[3] = totalMeasurements > 0.0 ? sloGradeSum / totalMeasurements : 0.0;
        return result;
    }

    private Measurement findMeasurement(List<Measurement> measurementList, ServiceLevelObjective serviceLevelObjective) {
        for (Measurement measurement : measurementList) {
            String sloMeasuringPoint;
            String measureMeasuringPoint;
            if (!this.containsMetric(measurement.getMeasuringType().getMetric(), serviceLevelObjective.getMeasurementSpecification().getMetricDescription()) || !(measureMeasuringPoint = measurement.getMeasuringType().getMeasuringPoint().getStringRepresentation()).equals(sloMeasuringPoint = serviceLevelObjective.getMeasurementSpecification().getMonitor().getMeasuringPoint().getStringRepresentation())) continue;
            return measurement;
        }
        throw new RuntimeException("Measurement for SLO \"" + serviceLevelObjective.getName() + "\" not found");
    }

    private boolean containsMetric(MetricDescription metric, MetricDescription metricToCheckFor) {
        if (metric == metricToCheckFor || metric.getId().equals(metricToCheckFor.getId())) {
            return true;
        }
        if (metric instanceof MetricSetDescription) {
            for (MetricDescription subMetric : ((MetricSetDescription)metric).getSubsumedMetrics()) {
                if (!this.containsMetric(subMetric, metricToCheckFor)) continue;
                return true;
            }
        }
        return false;
    }

    private ExperimentGroup getExperimentGroup(Repository repository, String purpose) {
        for (ExperimentGroup experimentGroup : repository.getExperimentGroups()) {
            if (!experimentGroup.getPurpose().equals(purpose)) continue;
            return experimentGroup;
        }
        throw new IllegalArgumentException("Could not find experiment group with purpose \"" + purpose + "\"");
    }

    private ExperimentSetting getExperimentSetting(ExperimentGroup experimentGroup, String experimentSettingDescription) {
        for (ExperimentSetting expSetting : experimentGroup.getExperimentSettings()) {
            if (!expSetting.getDescription().equals(experimentSettingDescription)) continue;
            return expSetting;
        }
        throw new IllegalArgumentException("Could not find experiment setting for variation \"" + experimentSettingDescription + "\"");
    }
}

