/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.simucomframework.ExperimentRunner;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simulation.SimulationResult;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class RunInterpreterJob
extends SequentialJob {
    private static final Logger LOGGER = Logger.getLogger(RunInterpreterJob.class);
    private final Provider<SimuComModel> simuComModelProvider;

    @Inject
    public RunInterpreterJob(Provider<SimuComModel> simuComModelProvider) {
        this.simuComModelProvider = simuComModelProvider;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        LOGGER.debug((Object)"Starting Simulizar simulation...");
        SimuComModel simuComModel = (SimuComModel)this.simuComModelProvider.get();
        simuComModel.getSimulationControl().addStopCondition(() -> ((IProgressMonitor)monitor).isCanceled());
        double simRealTimeNano = ExperimentRunner.run((SimuComModel)simuComModel);
        LOGGER.debug((Object)("Finished Simulation. Simulator took " + simRealTimeNano / Math.pow(10.0, 9.0) + " real time seconds"));
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        SimuComModel simuComModel = (SimuComModel)this.simuComModelProvider.get();
        if (!SimulationResult.OK.equals((Object)simuComModel.getErrorStatus())) {
            throw new RuntimeException("The simulation was aborted due to an exception during interpretation.", simuComModel.getErrorThrowable());
        }
    }

    public String getName() {
        return "Run SimuLizar Interpreter Job";
    }
}

