/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.BlackboardAwareJobProxy;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.ValidatePCMModelsJob;
import org.palladiosimulator.simulizar.di.component.interfaces.AnalysisRuntimeComponent;
import org.palladiosimulator.simulizar.launcher.jobs.EvaluateResultsJob;
import org.palladiosimulator.simulizar.launcher.jobs.LoadSimuLizarModelsIntoBlackboardJob;
import org.palladiosimulator.simulizar.launcher.jobs.ModelCompletionsJob;
import org.palladiosimulator.simulizar.launcher.jobs.ResolveModelPartitionsJob;
import org.palladiosimulator.simulizar.launcher.jobs.SimuLizarPrepareBlackboardJob;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class SimuLizarRootJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IBlackboardInteractingJob<MDSDBlackboard> {
    @Inject
    public SimuLizarRootJob(SimuLizarWorkflowConfiguration configuration, MDSDBlackboard blackboard, Provider<SimuLizarPrepareBlackboardJob> prepareBlackboardJob, Provider<LoadSimuLizarModelsIntoBlackboardJob> modelLoadJob, Provider<ModelCompletionsJob> modelCompletionsJob, AnalysisRuntimeComponent.Factory runtimeComponentFactory) {
        super(false);
        this.setBlackboard((Blackboard)blackboard);
        this.addSuppliedJob("Prepare blackboard", () -> prepareBlackboardJob.get());
        this.addSuppliedJob("Load models into blackboard", () -> modelLoadJob.get());
        this.addJob((IJob)new ResolveModelPartitionsJob());
        this.addJob((IJob)new ValidatePCMModelsJob((AbstractPCMWorkflowRunConfiguration)configuration));
        this.addSuppliedJob("Run registered model completions", () -> modelCompletionsJob.get());
        this.addSuppliedJob("Run simulizar runtime", () -> runtimeComponentFactory.create().runtimeJob());
        if (configuration.getServiceLevelObjectivesFile() != null && !configuration.getServiceLevelObjectivesFile().isBlank()) {
            this.addEvaluateResultsJob(configuration);
        }
    }

    protected void addEvaluateResultsJob(SimuLizarWorkflowConfiguration configuration) {
        this.addJob((IJob)new EvaluateResultsJob(configuration));
    }

    protected void addSuppliedJob(String jobName, Supplier<IJob> jobSupplier) {
        this.addJob((IJob)new BlackboardAwareJobProxy(jobName, jobSupplier));
    }
}

