/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.modelobserver;

import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import de.uka.ipd.sdq.stoex.StoexPackage;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.Workload;
import org.palladiosimulator.simulizar.modelobserver.AbstractUsageModelObserver;
import org.palladiosimulator.simulizar.scopes.SimulationRuntimeScope;
import org.palladiosimulator.simulizar.usagemodel.SimulatedUsageModels;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;

@SimulationRuntimeScope
public class UsageModelSyncer
extends AbstractUsageModelObserver {
    private static final Logger LOGGER = Logger.getLogger(UsageModelSyncer.class);
    private final SimulatedUsageModels usageModels;

    @Inject
    public UsageModelSyncer(@PCMPartitionManager.Global PCMResourceSetPartition globalPCMInstance, SimulatedUsageModels usageModels) {
        super(globalPCMInstance);
        this.usageModels = usageModels;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.globalPCMInstance.getUsageModel().getUsageScenario_UsageModel().forEach(us -> this.usageModels.createAndAddWorkloadDriver((UsageScenario)us));
    }

    @Override
    protected void add(Notification notification) {
        if (UsagemodelPackage.eINSTANCE.getUsageModel().isInstance(notification.getNotifier()) && UsagemodelPackage.eINSTANCE.getUsageModel_UsageScenario_UsageModel().equals(notification.getFeature())) {
            this.syncUsageScenarioAddition(notification);
        } else {
            LOGGER.error((Object)"Usage model changed...But no resync strategy is known. Simulation results most likely are wrong.");
        }
    }

    @Override
    protected void remove(Notification notification) {
        if (UsagemodelPackage.eINSTANCE.getUsageModel().isInstance(notification.getNotifier()) && UsagemodelPackage.eINSTANCE.getUsageModel_UsageScenario_UsageModel().equals(notification.getFeature())) {
            this.syncUsageScenarioRemoval(notification);
        } else {
            LOGGER.error((Object)"Usage model changed...But no resync strategy is known. Simulation results most likely are wrong.");
        }
    }

    @Override
    protected void set(Notification notification) {
        if (UsagemodelPackage.eINSTANCE.getClosedWorkload().isInstance(notification.getNotifier()) && notification.getFeature() == UsagemodelPackage.eINSTANCE.getClosedWorkload_Population()) {
            this.syncClosedWorkloadPopulationChange(notification);
        } else if (CorePackage.eINSTANCE.getPCMRandomVariable().isInstance(notification.getNotifier()) && ((EObject)notification.getNotifier()).eContainer() instanceof ClosedWorkload && notification.getFeature() == StoexPackage.eINSTANCE.getRandomVariable_Specification()) {
            this.syncClosedWorkloadThinkTimeChange(notification);
        } else if (CorePackage.eINSTANCE.getPCMRandomVariable().isInstance(notification.getNotifier()) && ((EObject)notification.getNotifier()).eContainer() instanceof OpenWorkload && notification.getFeature() == StoexPackage.eINSTANCE.getRandomVariable_Specification()) {
            this.syncOpenWorkloadInterarrivalTimeChange(notification);
        } else if (!(CorePackage.eINSTANCE.getPCMRandomVariable().isInstance(notification.getNotifier()) && ParameterPackage.eINSTANCE.getVariableCharacterisation().isInstance((Object)((EObject)notification.getNotifier()).eContainer()) || UsagemodelPackage.eINSTANCE.getUsageScenario().isInstance(notification.getNotifier()) && notification.getFeature() == UsagemodelPackage.eINSTANCE.getUsageScenario_UsageModel_UsageScenario() && notification.getOldValue() != null && notification.getNewValue() == null)) {
            LOGGER.error((Object)"Usage model changed...But no resync strategy is known. Simulation results most likely are wrong.");
        }
    }

    private void syncClosedWorkloadPopulationChange(Notification notification) {
        ClosedWorkload workload = (ClosedWorkload)notification.getNotifier();
        this.closedWorkloadPopulationChange((Workload)workload, notification.getNewIntValue());
    }

    private void syncClosedWorkloadThinkTimeChange(Notification notification) {
        ClosedWorkload workload = (ClosedWorkload)((EObject)notification.getNotifier()).eContainer();
        this.closedWorkloadThinkTimeChange((Workload)workload, notification.getNewStringValue());
    }

    private void syncOpenWorkloadInterarrivalTimeChange(Notification notification) {
        OpenWorkload workload = (OpenWorkload)((EObject)notification.getNotifier()).eContainer();
        this.openWorkloadInterarrivalTimeChange((Workload)workload, notification.getNewStringValue());
    }

    private void openWorkloadInterarrivalTimeChange(Workload workload, String newInterarrivalTime) {
        LOGGER.debug((Object)("Setting open workload interarrival time to " + newInterarrivalTime));
        this.usageModels.getOpenWorkloadDriver((OpenWorkload)workload).setInterarrivalTime(newInterarrivalTime);
    }

    private void closedWorkloadPopulationChange(Workload workload, int newPopulation) {
        LOGGER.debug((Object)("Setting closed workload population to " + newPopulation));
        this.usageModels.getClosedWorkloadDriver((ClosedWorkload)workload).setPopulation(newPopulation);
    }

    private void closedWorkloadThinkTimeChange(Workload workload, String newThinkTime) {
        LOGGER.debug((Object)("Setting closed workload think time to " + newThinkTime));
        this.usageModels.getClosedWorkloadDriver((ClosedWorkload)workload).setThinkTime(newThinkTime);
    }

    private void syncUsageScenarioAddition(Notification notification) {
        LOGGER.debug((Object)"Initializing execution of new usage scenario");
        IWorkloadDriver newDriver = this.usageModels.createAndAddWorkloadDriver((UsageScenario)notification.getNewValue());
        newDriver.run();
        LOGGER.debug((Object)"Execution of new usage scenario started");
    }

    private void syncUsageScenarioRemoval(Notification notification) {
        LOGGER.debug((Object)"Stopping execution of specific usage scenario");
        this.usageModels.cancelAndUnregisterWorkloadDriver(((UsageScenario)notification.getOldValue()).getWorkload_UsageScenario());
        LOGGER.debug((Object)"Execution of new usage scenario started");
    }
}

