/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simulizar.entity.EntityReference;
import org.palladiosimulator.simulizar.usagemodel.PeriodicallyTriggeredUsageEvolver;
import org.palladiosimulator.simulizar.utils.PCMPartitionManager;
import tools.descartes.dlim.generator.ModelEvaluator;

public class LoopingUsageEvolver
extends PeriodicallyTriggeredUsageEvolver {
    static final Logger LOGGER = Logger.getLogger(LoopingUsageEvolver.class);
    private final double simulationTimeOffset;

    @AssistedInject
    public LoopingUsageEvolver(@Assisted double firstOccurrence, @Assisted double delay, @Assisted double simulationTimeOffset, @Assisted EntityReference<UsageScenario> evolvedScenario, @PCMPartitionManager.Global PCMResourceSetPartition pcmPartition, ISimEventFactory simEventFactory, ISimulationTimeProvider timeProvider) {
        super(firstOccurrence, delay, evolvedScenario, pcmPartition, simEventFactory, timeProvider);
        if (!this.getCorrespondingUsage().isRepeatingPattern()) {
            throw new IllegalArgumentException("The corresponding usage model must contain a repeating pattern.");
        }
        this.simulationTimeOffset = simulationTimeOffset;
    }

    @Override
    protected double getNewRate(ModelEvaluator evaluator) {
        return evaluator.getArrivalRateAtTime(LoopingUsageEvolver.floorMod(this.getCurrentTime() - this.simulationTimeOffset, this.getDLIMFinalDuration()));
    }

    private static double floorMod(double x, double y) {
        return x - Math.floor(x / y) * y;
    }
}

