/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simulizar.entity.EntityReference;
import org.palladiosimulator.simulizar.entity.EntityReferenceFactory;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityManager;
import org.palladiosimulator.simulizar.scopes.SimulationRuntimeScope;
import org.palladiosimulator.simulizar.usagemodel.LoopingUsageEvolverFactory;
import org.palladiosimulator.simulizar.usagemodel.PeriodicallyTriggeredUsageEvolver;
import org.palladiosimulator.simulizar.usagemodel.StretchedUsageEvolverFactory;
import org.scaledl.usageevolution.Usage;

@SimulationRuntimeScope
public class UsageEvolverFacade
implements RuntimeStateEntityManager {
    protected Map<Usage, PeriodicallyTriggeredUsageEvolver> usageEvolvers;
    private final ISimulationControl simulationControl;
    private final LoopingUsageEvolverFactory loopingFactory;
    private final StretchedUsageEvolverFactory stretchedFactory;
    private final EntityReferenceFactory<UsageScenario> usageScenarioReferenceFactory;

    @Inject
    public UsageEvolverFacade(ISimulationControl simulationControl, LoopingUsageEvolverFactory loopingFactory, StretchedUsageEvolverFactory stretchedFactory, EntityReferenceFactory<UsageScenario> usageScenarioReferenceFactory) {
        this.simulationControl = simulationControl;
        this.loopingFactory = loopingFactory;
        this.stretchedFactory = stretchedFactory;
        this.usageEvolvers = new HashMap<Usage, PeriodicallyTriggeredUsageEvolver>();
        this.usageScenarioReferenceFactory = usageScenarioReferenceFactory;
    }

    public void startUsageEvolution(Usage usage) {
        this.usageEvolvers.put(usage, this.createUsageEvolver(usage));
    }

    public void stopUsageEvolution(Usage usage) {
        this.usageEvolvers.remove(usage).stop();
    }

    protected PeriodicallyTriggeredUsageEvolver createUsageEvolver(Usage usage) {
        double timePerStep = 1.0;
        if (usage.getEvolutionStepWidth() != 0.0) {
            timePerStep = usage.getEvolutionStepWidth();
        }
        double simulationTimeOffset = 0.0;
        if (this.simulationControl.isRunning()) {
            simulationTimeOffset = this.simulationControl.getCurrentSimulationTime();
        }
        EntityReference<UsageScenario> ref = this.usageScenarioReferenceFactory.createCached(usage.getScenario());
        if (usage.isRepeatingPattern()) {
            return this.loopingFactory.create(0.0, timePerStep, simulationTimeOffset, ref);
        }
        return this.stretchedFactory.create(0.0, timePerStep, ref);
    }
}

