/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.interpreter;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.core.usage.IScenarioRunner;
import de.uka.ipd.sdq.simucomframework.usage.OpenWorkloadUser;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcess;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcessListener;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.simulizar.action.context.ContextFactory;
import org.palladiosimulator.simulizar.action.context.ExecutionContext;
import org.palladiosimulator.simulizar.action.core.AbstractAdaptationBehavior;
import org.palladiosimulator.simulizar.action.core.AdaptationBehavior;
import org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository;
import org.palladiosimulator.simulizar.action.core.AdaptationStep;
import org.palladiosimulator.simulizar.action.core.ControllerCall;
import org.palladiosimulator.simulizar.action.core.EnactAdaptationStep;
import org.palladiosimulator.simulizar.action.core.GuardedStep;
import org.palladiosimulator.simulizar.action.core.GuardedTransition;
import org.palladiosimulator.simulizar.action.core.NestedAdaptationBehavior;
import org.palladiosimulator.simulizar.action.core.ResourceDemandingStep;
import org.palladiosimulator.simulizar.action.core.StateTransformingStep;
import org.palladiosimulator.simulizar.action.core.util.CoreSwitch;
import org.palladiosimulator.simulizar.action.instance.RoleSet;
import org.palladiosimulator.simulizar.action.interpreter.AbstractStateTransformation;
import org.palladiosimulator.simulizar.action.interpreter.ExecutionContextKeeper;
import org.palladiosimulator.simulizar.action.interpreter.TransientEffectExecutionResult;
import org.palladiosimulator.simulizar.action.interpreter.TransientEffectQVTOExecutor;
import org.palladiosimulator.simulizar.action.interpreter.TransientEffectQVTOExecutorUtil;
import org.palladiosimulator.simulizar.action.interpreter.notifications.AdaptationBehaviorExecutedNotification;
import org.palladiosimulator.simulizar.action.interpreter.notifications.AdaptationStepExecutedNotification;
import org.palladiosimulator.simulizar.action.interpreter.util.TransientEffectTransformationCacheKeeper;
import org.palladiosimulator.simulizar.action.mapping.ControllerMapping;
import org.palladiosimulator.simulizar.action.mapping.Mapping;
import org.palladiosimulator.simulizar.action.parameter.ControllerCallInputVariableUsage;
import org.palladiosimulator.simulizar.action.parameter.ControllerCallInputVariableUsageCollection;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.interpreter.listener.EventResult;
import org.palladiosimulator.simulizar.reconfiguration.ReconfigurationProcess;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.QVToModelCache;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class TransientEffectInterpreter
extends CoreSwitch<TransientEffectExecutionResult> {
    private static final Logger LOGGER = Logger.getLogger(TransientEffectInterpreter.class);
    private static final String STATE_TRANSFORMING_EXT_POINT_ID = "org.palladiosimulator.simulizar.action.stratetransformation";
    private static final String STATE_TRANSFORMING_CLASS_NAME = "class";
    private static final ExecutionContext DEFAULT_EXECUTION_CONTEXT = ContextFactory.eINSTANCE.createExecutionContext();
    private final SimuLizarRuntimeState state;
    private final ReconfigurationProcess associatedReconfigurationProcess;
    private final RoleSet roleSet;
    private final ControllerCallInputVariableUsageCollection controllerCallsInputVariableUsages;
    private final boolean isAsync;
    private Optional<ExecutionContext> executionContext;
    private final IResourceTableManager resourceTableManager;
    private final SimulatedThreadComponent.Factory simulatedThreadComponentFactory;

    TransientEffectInterpreter(SimuLizarRuntimeState state, RoleSet set, ControllerCallInputVariableUsageCollection controllerCallsInputVariableUsages, AdaptationBehaviorRepository repository, boolean executeAsync, Optional<ExecutionContext> executionContext, IResourceTableManager resourceTableManager) {
        this.state = state;
        this.associatedReconfigurationProcess = this.state.getReconfigurator().getReconfigurationProcess();
        this.roleSet = set;
        this.isAsync = executeAsync;
        this.controllerCallsInputVariableUsages = Objects.requireNonNull(controllerCallsInputVariableUsages);
        this.executionContext = executionContext;
        this.resourceTableManager = resourceTableManager;
        this.simulatedThreadComponentFactory = state.getSimulatedThreadComponentFactory();
    }

    private AsyncInterpretationProcess createAsyncProcess(AdaptationBehavior behaviorToInterpret) {
        final AsyncInterpretationProcess asyncInterpretationProcess = new AsyncInterpretationProcess(this.executionContext, behaviorToInterpret);
        asyncInterpretationProcess.addProcessListener(new ISimProcessListener(){

            public void notifyTerminated(ISimProcess process) {
                ExecutionContextKeeper.getInstance().removeContextProcessMapping(asyncInterpretationProcess.getCorrespondingContext(), asyncInterpretationProcess);
            }

            public void notifySuspending(ISimProcess process) {
            }

            public void notifyResuming(ISimProcess process) {
            }
        });
        return asyncInterpretationProcess;
    }

    private SimuComSimProcess obtainExecutingProcessForContext() {
        assert (!this.isAsync);
        Object interpreterProcess = null;
        ExecutionContext context = this.executionContext.orElse(DEFAULT_EXECUTION_CONTEXT);
        interpreterProcess = context.getId().equals(DEFAULT_EXECUTION_CONTEXT.getId()) ? this.associatedReconfigurationProcess : ExecutionContextKeeper.getInstance().getProcessForContext(context).orElseThrow(() -> new RuntimeException("Invalid context for synchronous execution of adaptation behavior:\nCorresponding process does not exist or has already terminated!"));
        return interpreterProcess;
    }

    @Override
    public TransientEffectExecutionResult caseAdaptationBehavior(AdaptationBehavior adaptationBehavior) {
        TransientEffectExecutionResult result;
        if (this.isAsync) {
            AsyncInterpretationProcess asyncProcess = this.createAsyncProcess(adaptationBehavior);
            ExecutionContextKeeper.getInstance().addContextProcessMapping(asyncProcess.getCorrespondingContext(), asyncProcess);
            this.executionContext = Optional.of(asyncProcess.getCorrespondingContext());
            asyncProcess.activate();
            LOGGER.debug((Object)"Scheduled process for async interpretation of adaptation behavior.");
            result = new TransientEffectExecutionResult(EventResult.SUCCESS, asyncProcess.getCorrespondingContext());
        } else {
            LOGGER.debug((Object)("Synchronous execution of adaptation behavior \"" + adaptationBehavior.getEntityName() + "\" is taking place."));
            boolean successful = this.executeAdaptationSteps((Collection<AdaptationStep>)adaptationBehavior.getAdaptationSteps(), this.obtainExecutingProcessForContext());
            if (successful) {
                this.forwardReconfigurationNotification((Notification)new AdaptationBehaviorExecutedNotification(adaptationBehavior));
                LOGGER.debug((Object)("Synchronous execution of adaptation behavior \"" + adaptationBehavior.getEntityName() + "\" successfully done."));
            } else {
                LOGGER.warn((Object)("Synchronous execution of adaptation behavior \"" + adaptationBehavior.getEntityName() + "\" finished with failures."));
            }
            result = new TransientEffectExecutionResult(EventResult.fromBoolean((boolean)successful), this.executionContext.orElse(DEFAULT_EXECUTION_CONTEXT));
        }
        return result;
    }

    private Boolean executeAdaptationSteps(Collection<AdaptationStep> adaptationSteps, SimuComSimProcess executingProcess) {
        assert (adaptationSteps != null && executingProcess != null);
        InternalSwitch executingSwitch = new InternalSwitch(executingProcess);
        return adaptationSteps.stream().reduce(true, (result, action) -> (Boolean)executingSwitch.doSwitch((EObject)action), Boolean::logicalAnd);
    }

    private void forwardReconfigurationNotification(Notification notification) {
        this.associatedReconfigurationProcess.appendReconfigurationNotification(notification);
    }

    private static AbstractStateTransformation getStateTransformation(String extensionId) {
        Optional<IExtension> stateTransformingExtension = Arrays.stream(Platform.getExtensionRegistry().getExtensionPoint(STATE_TRANSFORMING_EXT_POINT_ID).getExtensions()).filter(extension -> extension.getUniqueIdentifier().equals(extensionId)).findAny();
        IExtension extension2 = stateTransformingExtension.orElseThrow(() -> new IllegalStateException("No state transformation registered for State Transforming Step " + extensionId));
        IConfigurationElement[] iConfigurationElementArray = extension2.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                return (AbstractStateTransformation)element.createExecutableExtension(STATE_TRANSFORMING_CLASS_NAME);
            }
            catch (CoreException e) {
                LOGGER.error((Object)e.getStackTrace());
                ++n2;
            }
        }
        throw new IllegalStateException("No state transformation registered for State Transforming Step " + extensionId);
    }

    private final class AsyncInterpretationProcess
    extends SimuComSimProcess {
        private final AdaptationBehavior behaviorToInterpret;
        private final ExecutionContext correspondingContext;

        private AsyncInterpretationProcess(Optional<ExecutionContext> context, AdaptationBehavior behaviorToInterpret) {
            super(TransientEffectInterpreter.this.state.getModel(), "SimuComSimProcess For Async Action Interpretation", TransientEffectInterpreter.this.resourceTableManager);
            this.correspondingContext = context.orElseGet(ContextFactory.eINSTANCE::createExecutionContext);
            this.behaviorToInterpret = behaviorToInterpret;
        }

        protected void internalLifeCycle() {
            LOGGER.debug((Object)("Async execution of adaptation behavior \"" + this.behaviorToInterpret.getEntityName() + "\" is taking place."));
            boolean result = TransientEffectInterpreter.this.executeAdaptationSteps((Collection<AdaptationStep>)this.behaviorToInterpret.getAdaptationSteps(), this);
            if (result) {
                LOGGER.debug((Object)("Async execution of adaptation behavior \"" + this.behaviorToInterpret.getEntityName() + "\" successfully done."));
            } else {
                LOGGER.warn((Object)("Async execution of adaptation behavior \"" + this.behaviorToInterpret.getEntityName() + "\" finished with failures."));
            }
        }

        private ExecutionContext getCorrespondingContext() {
            return this.correspondingContext;
        }
    }

    private final class InternalSwitch
    extends CoreSwitch<Boolean> {
        private final SimuComSimProcess executingProcess;
        private final TransientEffectQVTOExecutor qvtoExecutor;
        private final Map<ControllerCall, List<VariableUsage>> inputVariableUsagesPerControllerCall;

        private InternalSwitch(SimuComSimProcess executingProcess) {
            this.executingProcess = executingProcess;
            QVToModelCache availableModels = new QVToModelCache(Objects.requireNonNull(TransientEffectInterpreter.this.state.getPCMPartitionManager()));
            this.qvtoExecutor = new TransientEffectQVTOExecutor(TransientEffectTransformationCacheKeeper.getTransformationCacheForRuntimeState(TransientEffectInterpreter.this.state), availableModels.snapshot());
            this.inputVariableUsagesPerControllerCall = TransientEffectInterpreter.this.controllerCallsInputVariableUsages.getControllerCallInputVariableUsages().stream().collect(Collectors.groupingBy(ControllerCallInputVariableUsage::getCorrespondingControllerCall, Collectors.mapping(ControllerCallInputVariableUsage::getVariableUsage, Collectors.toList())));
            this.qvtoExecutor.addTransformationParameters(TransientEffectInterpreter.this.roleSet, TransientEffectInterpreter.this.executionContext.orElse(DEFAULT_EXECUTION_CONTEXT));
        }

        @Override
        public Boolean caseNestedAdaptationBehavior(NestedAdaptationBehavior nestedAdaptationBehavior) {
            return TransientEffectInterpreter.this.executeAdaptationSteps((Collection<AdaptationStep>)nestedAdaptationBehavior.getAdaptationSteps(), this.executingProcess);
        }

        @Override
        public Boolean caseGuardedTransition(GuardedTransition guardedTransition) {
            this.qvtoExecutor.enableForTransformationExecution(guardedTransition);
            TransientEffectQVTOExecutorUtil.validateGuardedTransition(this.qvtoExecutor, guardedTransition);
            return this.qvtoExecutor.executeGuardedTransition(guardedTransition, TransientEffectInterpreter.this.resourceTableManager);
        }

        @Override
        public Boolean caseGuardedStep(GuardedStep guardedStep) {
            Optional<NestedAdaptationBehavior> branchToExecute = guardedStep.getGuardedTransitions().stream().filter(this::caseGuardedTransition).findFirst().map(GuardedTransition::getNestedAdaptationBehavior);
            return branchToExecute.map(arg_0 -> ((InternalSwitch)this).doSwitch(arg_0)).orElse(false);
        }

        @Override
        public Boolean caseStateTransformingStep(StateTransformingStep stateTransformingStep) {
            this.qvtoExecutor.enableForTransformationExecution(stateTransformingStep);
            String extensionId = stateTransformingStep.getId();
            AbstractStateTransformation transformation = TransientEffectInterpreter.getStateTransformation(extensionId);
            transformation.setSimulationState(TransientEffectInterpreter.this.state);
            return transformation.execute(TransientEffectInterpreter.this.roleSet);
        }

        @Override
        public Boolean caseAbstractAdaptationBehavior(AbstractAdaptationBehavior abstractAdaptationBehavior) {
            throw new AssertionError((Object)"AbstractAdaptationBehavior is abstract, this case should not be reached at all!");
        }

        @Override
        public Boolean caseAdaptationStep(AdaptationStep step) {
            throw new AssertionError((Object)"AdaptationStep is abstract, this case should not be reached at all!");
        }

        @Override
        public Boolean caseResourceDemandingStep(ResourceDemandingStep resourceDemandingStep) {
            this.qvtoExecutor.enableForTransformationExecution(resourceDemandingStep);
            Mapping mapping = this.executeResourceDemandingStep(resourceDemandingStep).orElseThrow(() -> new RuntimeException("Controller Completion transformation failed!"));
            LinkedList<OpenWorkloadUser> users = new LinkedList<OpenWorkloadUser>();
            SimuComModel model = TransientEffectInterpreter.this.state.getMainContext().getModel();
            for (ControllerMapping controllerMapping : mapping.getControllerMappings()) {
                ControllerCall call = controllerMapping.getMappedCall();
                List<Probe> usageStartStopProbes = Collections.unmodifiableList(Arrays.asList(new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)model.getSimulationControl()), new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)model.getSimulationControl())));
                OpenWorkloadUser user = new OpenWorkloadUser(model, String.valueOf(resourceDemandingStep.getEntityName()) + " " + call.getEntityName(), this.createAndScheduleControllerScenarioRunner(controllerMapping), usageStartStopProbes, TransientEffectInterpreter.this.resourceTableManager);
                users.add(user);
                user.startUserLife();
            }
            while (this.checkIfUsersRun(users)) {
                this.executingProcess.passivate();
            }
            return true;
        }

        @Override
        public Boolean caseEnactAdaptationStep(EnactAdaptationStep enactAdaptationStep) {
            this.qvtoExecutor.enableForTransformationExecution(enactAdaptationStep);
            TransientEffectQVTOExecutorUtil.validateEnactAdaptationStep(this.qvtoExecutor, enactAdaptationStep);
            URI adaptationStepUri = URI.createURI((String)enactAdaptationStep.getAdaptationStepURI());
            QvtoModelTransformation adaptationStep = this.qvtoExecutor.getTransformationByUri(adaptationStepUri).get();
            Map configParams = Collections.emptyMap();
            boolean result = this.qvtoExecutor.executeTransformation(adaptationStep, TransientEffectInterpreter.this.resourceTableManager, configParams);
            if (result && !TransientEffectInterpreter.this.isAsync) {
                TransientEffectInterpreter.this.forwardReconfigurationNotification((Notification)new AdaptationStepExecutedNotification(enactAdaptationStep));
            }
            return result;
        }

        private IScenarioRunner createAndScheduleControllerScenarioRunner(ControllerMapping controllerMapping) {
            ControllerCall mappedCall = controllerMapping.getMappedCall();
            Collection variableUsages = this.inputVariableUsagesPerControllerCall.getOrDefault(mappedCall, Collections.emptyList());
            return process -> {
                LOGGER.info((Object)("Start executing the controller scenario ('" + mappedCall.getEntityName() + "')!"));
                UsageScenario usageScenario = UsagemodelFactory.eINSTANCE.createUsageScenario();
                ScenarioBehaviour behaviour = UsagemodelFactory.eINSTANCE.createScenarioBehaviour();
                usageScenario.setScenarioBehaviour_UsageScenario(behaviour);
                EList actions = behaviour.getActions_ScenarioBehaviour();
                Start start = UsagemodelFactory.eINSTANCE.createStart();
                EntryLevelSystemCall sysCall = UsagemodelFactory.eINSTANCE.createEntryLevelSystemCall();
                Stop stop = UsagemodelFactory.eINSTANCE.createStop();
                actions.add(start);
                actions.add(sysCall);
                actions.add(stop);
                sysCall.setOperationSignature__EntryLevelSystemCall(mappedCall.getCalledSignature());
                sysCall.setProvidedRole_EntryLevelSystemCall(controllerMapping.getControllerRole());
                sysCall.getInputParameterUsages_EntryLevelSystemCall().addAll(variableUsages);
                start.setSuccessor((AbstractUserAction)sysCall);
                sysCall.setSuccessor((AbstractUserAction)stop);
                TransientEffectInterpreter.this.simulatedThreadComponentFactory.create(TransientEffectInterpreter.this.state.getMainContext(), process).interpreterFacade().submit((EObject)usageScenario);
                this.executingProcess.scheduleAt(0.0);
                LOGGER.info((Object)("Execution of the controller scenario ('" + mappedCall.getEntityName() + "') finished!"));
            };
        }

        private boolean checkIfUsersRun(Collection<OpenWorkloadUser> users) {
            return users.stream().anyMatch(u -> !u.isTerminated());
        }

        private Optional<Mapping> executeResourceDemandingStep(ResourceDemandingStep resourceDemandingStep) {
            assert (resourceDemandingStep != null);
            Repository repository = ((ControllerCall)resourceDemandingStep.getControllerCalls().get(0)).getComponent().getRepository__RepositoryComponent();
            TransientEffectQVTOExecutorUtil.validateResourceDemandingStep(this.qvtoExecutor, resourceDemandingStep);
            return this.qvtoExecutor.executeControllerCompletion(repository, resourceDemandingStep.getControllerCompletionURI(), TransientEffectInterpreter.this.resourceTableManager);
        }
    }
}

