/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.extension;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.palladiosimulator.simulizar.test.commons.annotation.RunSimulationJob;
import org.palladiosimulator.simulizar.test.commons.extension.SimuLizarTestExtensionCommons;

public class RunSimulationJobExtension
implements BeforeEachCallback,
AfterEachCallback {
    public void beforeEach(ExtensionContext context) throws Exception {
        if (AnnotationSupport.findAnnotation((Optional)context.getElement(), RunSimulationJob.class).isPresent()) {
            IJob job = SimuLizarTestExtensionCommons.getObjectFromStore(context, IJob.class).orElseThrow(() -> new IllegalArgumentException("Cannot run simulation without a simulation job present. Check your annotation setup!"));
            if (job instanceof IBlackboardInteractingJob) {
                MDSDBlackboard blackboard = SimuLizarTestExtensionCommons.getObjectFromStore(context, MDSDBlackboard.class).orElseThrow(() -> new IllegalArgumentException("Simulation job requires blackboard. No MDSDBlackboard registered."));
                ((IBlackboardInteractingJob)job).setBlackboard((Blackboard)blackboard);
            }
            NullProgressMonitor monitor = new NullProgressMonitor();
            job.execute((IProgressMonitor)monitor);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (AnnotationSupport.findAnnotation((Optional)context.getElement(), RunSimulationJob.class).isPresent()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            SimuLizarTestExtensionCommons.getObjectFromStore(context, IJob.class).orElseThrow(() -> new IllegalStateException("No job was registered. There was an error during initialization.")).cleanup((IProgressMonitor)monitor);
        }
    }
}

