/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.hamcrest;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;
import org.palladiosimulator.simulizar.test.commons.hamcrest.BucketMatcher;

public final class Matchers {
    private Matchers() {
    }

    public static <T> Matcher<T> firstMeasurementMatchesDifferentlyThanTheRest(final Matcher<T> firstValue, final Matcher<T> remainderValue) {
        return new BaseMatcher<T>(){
            boolean firstElementHasBeenSeen = false;

            public boolean matches(Object actual) {
                boolean matches = this.firstElementHasBeenSeen ? remainderValue.matches(actual) : firstValue.matches(actual);
                this.firstElementHasBeenSeen |= matches;
                return matches;
            }

            public void describeTo(Description description) {
                if (this.firstElementHasBeenSeen) {
                    description.appendText("all but first element match ");
                    remainderValue.describeTo(description);
                } else {
                    description.appendText("first element matches ");
                    firstValue.describeTo(description);
                }
            }
        };
    }

    public static <Q extends Quantity> Matcher<Measure<?, Q>> asDoubleIn(final Unit<Q> unit, final Matcher<? super Double> contentMatcher) {
        return new TypeSafeMatcher<Measure<?, Q>>(Measure.class){

            public void describeTo(Description description) {
                contentMatcher.describeTo(description);
                description.appendText(String.valueOf(unit.toString()) + " ");
            }

            protected boolean matchesSafely(Measure<?, Q> item) {
                return contentMatcher.matches((Object)item.doubleValue(unit));
            }
        };
    }

    public static <T> BucketMatcher<T> withProbability(Matcher<Double> probabilityMatcher, Matcher<? super T> bucketMatcher) {
        return new BucketMatcher<T>(probabilityMatcher, bucketMatcher);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<? extends T>> match(BucketMatcher<? super T> ... bucketMatchers) {
        final LinkedHashMap matcherCounts = new LinkedHashMap();
        Arrays.asList(bucketMatchers).forEach(matcher -> {
            Long l = matcherCounts.put(matcher, 0L);
        });
        return new TypeSafeDiagnosingMatcher<Iterable<? extends T>>(){
            long count = 0L;

            protected boolean matchesSafely(Iterable<? extends T> item, Description mismatchDescription) {
                for (Object it : item) {
                    Optional<BucketMatcher> matchingMatcher = matcherCounts.keySet().stream().filter(m -> m.getBucketMatcher().matches(it)).findFirst();
                    if (matchingMatcher.isEmpty()) {
                        mismatchDescription.appendText("an item was " + it.toString());
                        return false;
                    }
                    ++this.count;
                    matcherCounts.merge(matchingMatcher.get(), 1L, (oldValue, one) -> oldValue + one);
                }
                for (BucketMatcher matcher : matcherCounts.keySet()) {
                    double probability = (double)((Long)matcherCounts.get(matcher)).longValue() * 1.0 / (double)this.count;
                    if (matcher.getPercentileMatcher().matches((Object)probability)) continue;
                    mismatchDescription.appendText("the probability of bucket (");
                    matcher.getBucketMatcher().describeTo(mismatchDescription);
                    mismatchDescription.appendText(") was " + probability);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("(", "\nor ", ")", matcherCounts.keySet());
            }
        };
    }
}

