/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.util;

import de.uka.ipd.sdq.simucomframework.core.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResource;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedResourceContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIn;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class SimuLizarMockUtils {
    public static Map<Class<?>, Object> setUpMockRuntimeStateForModelObserving(PCMResourceSetPartition pcmInstance, boolean initializeRegistry) {
        PCMPartitionManager partitionManagerMock = (PCMPartitionManager)Mockito.mock(PCMPartitionManager.class);
        SimuLizarRuntimeState runtimeStateMock = (SimuLizarRuntimeState)Mockito.mock(SimuLizarRuntimeState.class);
        SimuComModel simuComModelMock = (SimuComModel)Mockito.mock(SimuComModel.class);
        Mockito.lenient().when((Object)partitionManagerMock.getGlobalPCMModel()).thenReturn((Object)pcmInstance);
        Mockito.lenient().when((Object)runtimeStateMock.getPCMPartitionManager()).thenReturn((Object)partitionManagerMock);
        Mockito.lenient().when((Object)runtimeStateMock.getModel()).thenReturn((Object)simuComModelMock);
        ResourceRegistry resourceRegistry = SimuLizarMockUtils.setUpMockRegistry(pcmInstance, simuComModelMock);
        Mockito.lenient().when((Object)simuComModelMock.getResourceRegistry()).thenReturn((Object)resourceRegistry);
        if (initializeRegistry) {
            pcmInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment().stream().forEach(rc -> {
                SimulatedResourceContainer asrc = (SimulatedResourceContainer)resourceRegistry.createResourceContainer(rc.getId());
                rc.getActiveResourceSpecifications_ResourceContainer().stream().forEach(prs -> asrc.addActiveResourceWithoutCalculators(prs, null, rc.getId(), prs.getSchedulingPolicy().getId()));
            });
            pcmInstance.getResourceEnvironment().getLinkingResources__ResourceEnvironment().stream().forEach(lr -> {
                SimulatedLinkingResourceContainer slrc = (SimulatedLinkingResourceContainer)resourceRegistry.createLinkingResourceContainer(lr.getId());
                slrc.addActiveResourceWithoutCalculators(lr, lr.getId());
            });
            Mockito.clearInvocations((Object[])new ResourceRegistry[]{resourceRegistry});
        }
        return Map.of(PCMResourceSetPartition.class, pcmInstance, PCMPartitionManager.class, partitionManagerMock, SimuLizarRuntimeState.class, runtimeStateMock, SimuComModel.class, simuComModelMock, ResourceRegistry.class, resourceRegistry);
    }

    private static ResourceRegistry setUpMockRegistry(final PCMResourceSetPartition partition, SimuComModel simuComModel) {
        final ResourceRegistry res = (ResourceRegistry)Mockito.spy((Object)new ResourceRegistry(simuComModel));
        ((ResourceRegistry)Mockito.lenient().doAnswer((Answer)new Answer<AbstractSimulatedResourceContainer>(){

            public AbstractSimulatedResourceContainer answer(InvocationOnMock invocation) throws Throwable {
                SimulatedResourceContainer src = partition.getResourceEnvironment().getResourceContainer_ResourceEnvironment().stream().filter(c -> c.getId().equals(invocation.getArgument(0))).findAny().map(SimuLizarMockUtils::access$0).orElseGet(() -> (SimulatedResourceContainer)Assertions.fail((String)"Create method called with invalid model element"));
                res.addResourceContainer(src);
                return src;
            }
        }).when((Object)res)).createResourceContainer(Mockito.anyString());
        ((ResourceRegistry)Mockito.lenient().doAnswer((Answer)new Answer<AbstractSimulatedResourceContainer>(){

            public AbstractSimulatedResourceContainer answer(InvocationOnMock invocation) throws Throwable {
                SimulatedLinkingResourceContainer src = partition.getResourceEnvironment().getLinkingResources__ResourceEnvironment().stream().filter(c -> c.getId().equals(invocation.getArgument(0))).findAny().map(SimuLizarMockUtils::access$1).orElseGet(() -> (SimulatedLinkingResourceContainer)Assertions.fail((String)"Create method called with invalid model element"));
                res.addLinkingResourceContainer(src);
                return src;
            }
        }).when((Object)res)).createLinkingResourceContainer(Mockito.anyString());
        return res;
    }

    private static SimulatedResourceContainer createMock(final ResourceContainer rc) {
        SimulatedResourceContainer src = (SimulatedResourceContainer)Mockito.mock(SimulatedResourceContainer.class);
        final HashMap mockResources = new HashMap();
        Mockito.lenient().when((Object)src.getResourceContainerID()).thenReturn((Object)rc.getId());
        Mockito.lenient().when((Object)src.addActiveResourceWithoutCalculators((ProcessingResourceSpecification)Mockito.any(), (String[])Mockito.any(), (String)Mockito.eq((Object)rc.getId()), Mockito.anyString())).thenAnswer((Answer)new Answer<ScheduledResource>(){

            public ScheduledResource answer(InvocationOnMock invocation) throws Throwable {
                ProcessingResourceSpecification prs = (ProcessingResourceSpecification)invocation.getArgument(0);
                MatcherAssert.assertThat((Object)((ProcessingResourceSpecification)invocation.getArgument(0)), (Matcher)IsIn.isIn((Collection)rc.getActiveResourceSpecifications_ResourceContainer()));
                ScheduledResource sr = (ScheduledResource)Mockito.mock(ScheduledResource.class);
                mockResources.put(prs.getActiveResourceType_ActiveResourceSpecification().getId(), sr);
                return sr;
            }
        });
        Mockito.lenient().when((Object)src.getAllActiveResources()).thenReturn(mockResources);
        return src;
    }

    private static SimulatedLinkingResourceContainer createMock(final LinkingResource lr) {
        SimulatedLinkingResourceContainer src = (SimulatedLinkingResourceContainer)Mockito.mock(SimulatedLinkingResourceContainer.class);
        final HashMap mockResources = new HashMap();
        Mockito.lenient().when((Object)src.getResourceContainerID()).thenReturn((Object)lr.getId());
        ((SimulatedLinkingResourceContainer)Mockito.lenient().doAnswer((Answer)new Answer<SimulatedLinkingResource>(){

            public SimulatedLinkingResource answer(InvocationOnMock invocation) throws Throwable {
                MatcherAssert.assertThat((Object)lr, (Matcher)CoreMatchers.equalTo((Object)((LinkingResource)invocation.getArgument(0))));
                SimulatedLinkingResource sr = (SimulatedLinkingResource)Mockito.mock(SimulatedLinkingResource.class);
                mockResources.put(lr.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getId(), sr);
                return sr;
            }
        }).when((Object)src)).addActiveResourceWithoutCalculators((LinkingResource)Mockito.any(), Mockito.anyString());
        Mockito.lenient().when((Object)src.getAllActiveResources()).thenReturn(mockResources);
        return src;
    }

    static /* synthetic */ SimulatedResourceContainer access$0(ResourceContainer resourceContainer) {
        return SimuLizarMockUtils.createMock(resourceContainer);
    }

    static /* synthetic */ SimulatedLinkingResourceContainer access$1(LinkingResource linkingResource) {
        return SimuLizarMockUtils.createMock(linkingResource);
    }
}

