/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.ui.configuration;

import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.ProtocomFileNamesInputTab;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.simulizar.launcher.SimulizarConstants;
import org.palladiosimulator.simulizar.ui.configuration.extensions.AbstractExtensionFileInputConfigurationBuilder;
import org.palladiosimulator.simulizar.ui.configuration.extensions.ExtensionFileInputConfiguration;
import org.palladiosimulator.simulizar.ui.configuration.extensions.ExtensionInputType;

public class InterpreterFileNamesInputTab
extends ProtocomFileNamesInputTab {
    private static final String EXTENSION_POINT_ID = "org.palladiosimulator.simulizar.ui.configuration.fileinput";
    private static final String EXTENSION_POINT_ATTRIBUTE = "fileInputConfigurationBuilder";
    protected Text monitorRepositoryFile;
    protected Text reconfigurationRulesFolder;
    protected Text usageEvolutionFile;
    protected Text serviceLevelObjectivesFile;
    private final Map<ExtensionFileInputConfiguration, Text> extensionFileFolderInputTexts = new HashMap<ExtensionFileInputConfiguration, Text>();

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.extensionFileFolderInputTexts.clear();
        this.monitorRepositoryFile = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Optional: Monitor Repository File", (String[])SimulizarConstants.MONITORING_SPECIFICATION_FILE_EXTENSION, (Text)this.monitorRepositoryFile, (String)"Select Monitor Repository File", (Shell)this.getShell(), (String)"");
        this.reconfigurationRulesFolder = new Text(this.container, 2052);
        TabHelper.createFolderInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Optional: Reconfiguration Rules folder", (Text)this.reconfigurationRulesFolder, (String)"Select Reconfiguration Rules Folder", (Shell)this.getShell(), (String)"");
        this.serviceLevelObjectivesFile = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Optional: Service Level Objectives File", (String[])SimulizarConstants.SERVICELEVELOBJECTIVEREPOSITORY_FILE_EXTENSION, (Text)this.serviceLevelObjectivesFile, (String)"Select Service Level Objective Repository File", (Shell)this.getShell(), (String)"");
        this.usageEvolutionFile = new Text(this.container, 2052);
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)"Optional: Usage Evolution File", (String[])SimulizarConstants.USAGEEVOLUTION_FILE_EXTENSION, (Text)this.usageEvolutionFile, (String)"Select Usage Evolution File", (Shell)this.getShell(), (String)"");
        this.createInputSectionsForExtensions();
    }

    private void createInputSectionsForExtensions() {
        List extensions = ExtensionHelper.getExecutableExtensions((String)EXTENSION_POINT_ID, (String)EXTENSION_POINT_ATTRIBUTE);
        for (AbstractExtensionFileInputConfigurationBuilder extension : extensions) {
            ExtensionFileInputConfiguration config = extension.buildConfiguration();
            Text inputText = new Text(this.container, 2052);
            this.extensionFileFolderInputTexts.put(config, inputText);
            String groupLabel = config.getPropertyByKey("groupLabel", String.class);
            String dialogTitle = config.getPropertyByKey("dialogTitle", String.class);
            String defaultUri = config.getPropertyByKey("defaultUri", String.class);
            ExtensionInputType inputType = config.getPropertyByKey("inputType", ExtensionFileInputConfiguration.DefaultPropertyKeys.EXPECTED_INPUT_TYPE_DATA_TYPE);
            if (inputType == ExtensionInputType.FILE) {
                String[] fileExtensionRestrictions = config.getPropertyByKey("fileRestrictions", ExtensionFileInputConfiguration.DefaultPropertyKeys.EXPECTED_FILE_RESTRICTIONS_DATA_TYPE);
                TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)groupLabel, (String[])fileExtensionRestrictions, (Text)inputText, (String)dialogTitle, (Shell)this.getShell(), (String)defaultUri);
                continue;
            }
            TabHelper.createFolderInputSection((Composite)this.container, (ModifyListener)this.modifyListener, (String)groupLabel, (Text)inputText, (String)dialogTitle, (Shell)this.getShell(), (String)defaultUri);
        }
    }

    private void setTextFromConfigAttribute(Text textWidget, ILaunchConfiguration config, String attributeName, String defaultValue) {
        try {
            textWidget.setText(config.getAttribute(attributeName, defaultValue));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)attributeName, (String)e.getMessage());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.setTextFromConfigAttribute(this.monitorRepositoryFile, configuration, "monitorRepositoryFile", "");
        this.setTextFromConfigAttribute(this.reconfigurationRulesFolder, configuration, "reconfigurationRulesFolder", "");
        this.setTextFromConfigAttribute(this.serviceLevelObjectivesFile, configuration, "serviceLevelObjectiveRepositoryFile", "");
        this.setTextFromConfigAttribute(this.usageEvolutionFile, configuration, "usageEvolutionFile", "");
        for (Map.Entry<ExtensionFileInputConfiguration, Text> entry : this.extensionFileFolderInputTexts.entrySet()) {
            String defaultUri = entry.getKey().getPropertyByKey("defaultUri", String.class);
            String configAttributeName = entry.getKey().getPropertyByKey("configAttribute", String.class);
            this.setTextFromConfigAttribute(entry.getValue(), configuration, configAttributeName, defaultUri);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("monitorRepositoryFile", this.monitorRepositoryFile.getText());
        configuration.setAttribute("reconfigurationRulesFolder", this.reconfigurationRulesFolder.getText());
        configuration.setAttribute("serviceLevelObjectiveRepositoryFile", this.serviceLevelObjectivesFile.getText());
        configuration.setAttribute("usageEvolutionFile", this.usageEvolutionFile.getText());
        for (Map.Entry<ExtensionFileInputConfiguration, Text> entry : this.extensionFileFolderInputTexts.entrySet()) {
            String configAttributeName = entry.getKey().getPropertyByKey("configAttribute", String.class);
            configuration.setAttribute(configAttributeName, entry.getValue().getText());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("monitorRepositoryFile", "");
        configuration.setAttribute("reconfigurationRulesFolder", "");
        configuration.setAttribute("serviceLevelObjectiveRepositoryFile", "");
        configuration.setAttribute("usageEvolutionFile", "");
        for (ExtensionFileInputConfiguration extensionConfig : this.extensionFileFolderInputTexts.keySet()) {
            String defaultUri = extensionConfig.getPropertyByKey("defaultUri", String.class);
            String configAttributeName = extensionConfig.getPropertyByKey("configAttribute", String.class);
            configuration.setAttribute(configAttributeName, defaultUri);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }
}

