/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.core.entity;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.simulizar.core.entity.EntityReferenceFactory;
import org.palladiosimulator.simulizar.core.entity.InterpretableLocationReference;

public class EntityReference<EntityType extends Entity>
implements InterpretableLocationReference {
    private final String id;
    private Class<EntityType> entityClass;
    private WeakHashMap<ResourceSet, EntityType> elementCache;

    EntityReference(String id, Class<EntityType> entityClass) {
        this.id = id;
        this.entityClass = entityClass;
        this.elementCache = new WeakHashMap();
    }

    public EntityType getModelElement(PCMResourceSetPartition partition) {
        return (EntityType)((Entity)this.getModelElementIfPresent(partition).orElseThrow(() -> new IllegalStateException("Referenced element not present in resource set partition.")));
    }

    public Optional<EntityType> getModelElementIfPresent(PCMResourceSetPartition partition) {
        Iterator<EntityType> iter;
        Optional<Entity> result = Optional.ofNullable((Entity)this.elementCache.get(partition.getResourceSet()));
        if (result.isEmpty() && (iter = this.retrieveModelElements(partition)).hasNext()) {
            result = Optional.of((Entity)iter.next());
            this.elementCache.put(partition.getResourceSet(), result.get());
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    protected Iterator<EntityType> retrieveModelElements(PCMResourceSetPartition partition) {
        return Iterators.filter((Iterator)Iterators.filter((Iterator)partition.getResourceSet().getAllContents(), this.entityClass), it -> it.getId().equals(this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityClass == null ? 0 : this.entityClass.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityReference other = (EntityReference)obj;
        if (this.entityClass == null ? other.entityClass != null : !this.entityClass.equals(other.entityClass)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public boolean isLocationIdentifiedBy(EntityReference<?> ... entityReferences) {
        if (entityReferences == null || entityReferences.length != 1) {
            return false;
        }
        return entityReferences[0].equals(this);
    }

    @Override
    public String getLocationIdentifier() {
        return this.id;
    }

    public static abstract class AbstractEntityReferenceFactory<EntityType extends Entity>
    implements EntityReferenceFactory<EntityType> {
        @Override
        public EntityReference<EntityType> createCached(EntityType entity) {
            EntityReference ref = this.create(entity.getId());
            ref.elementCache.put(entity.eResource().getResourceSet(), entity);
            return ref;
        }
    }
}

