/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reliability.interpreter;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import org.eclipse.emf.ecore.util.Switch;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.util.ReliabilitySwitch;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RDSeffSwitchContributionFactory;
import org.palladiosimulator.simulizar.interpreter.result.InterpretationIssue;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;
import org.palladiosimulator.simulizar.reliability.interpreter.issue.FailureOccurredIssue;

public class RDSeffReliabilityInterpreter
extends ReliabilitySwitch<InterpreterResult> {
    public static final String FAILURE_PROBABILITY_RANDOM_DRAW = "__RDSEFF_INTERPRETER_INTERNAL_ACTION_FAILURE_PROBABILITY_RANDOM_DRAW";
    public static final String FAILURE_PROBABILITY_ACCUMULATOR = "__RDSEFF_INTERPRETER_INTERNAL_ACTION_FAILURE_PROBABILITY_ACCUMULATOR";
    private final IRandomGenerator randomNumberGenerator;
    private final InterpreterDefaultContext context;

    @AssistedInject
    public RDSeffReliabilityInterpreter(IRandomGenerator randomNumberGenerator, @Assisted InterpreterDefaultContext context) {
        this.randomNumberGenerator = randomNumberGenerator;
        this.context = context;
    }

    public InterpreterResult caseInternalFailureOccurrenceDescription(InternalFailureOccurrenceDescription object) {
        double randVar = 0.0;
        double accumulator = 0.0;
        double newAccumulator = 0.0;
        InterpreterResult result = InterpreterResult.OK;
        try {
            randVar = (Double)this.context.getStack().currentStackFrame().getValue(FAILURE_PROBABILITY_RANDOM_DRAW);
            newAccumulator = accumulator = ((Double)this.context.getStack().currentStackFrame().getValue(FAILURE_PROBABILITY_ACCUMULATOR)).doubleValue();
        }
        catch (ValueNotInFrameException e) {
            randVar = this.randomNumberGenerator.random();
            this.context.getStack().currentStackFrame().addValue(FAILURE_PROBABILITY_RANDOM_DRAW, (Object)randVar);
        }
        newAccumulator += object.getFailureProbability();
        if (accumulator <= randVar && newAccumulator > randVar) {
            result = InterpreterResult.of((InterpretationIssue)new FailureOccurredIssue((FailureType)object.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription()));
        }
        this.context.getStack().currentStackFrame().addValue(FAILURE_PROBABILITY_ACCUMULATOR, (Object)newAccumulator);
        return result;
    }

    @AssistedFactory
    public static interface Factory
    extends RDSeffSwitchContributionFactory {
        default public Switch<InterpreterResult> createRDSeffSwitch(InterpreterDefaultContext context, RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch) {
            return this.create(context);
        }

        public RDSeffReliabilityInterpreter create(InterpreterDefaultContext var1);
    }
}

