package org.palladiosimulator.simulizar.test.commons.models;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;

@SuppressWarnings("all")
public class ResourceEnvironmentTestModels extends TestModelBase {
  /**
   * Creates a fully equipped PCMResourceSetPartition with a resource environment of two resource
   * containers and on linking resource.
   */
  public static class WithTwoContainersAndOneLink implements Supplier<PCMResourceSetPartition> {
    @Override
    public PCMResourceSetPartition get() {
      PCMResourceSetPartition _xblockexpression = null;
      {
        ProcessingResourceType _createProcessingResourceType = TestModelBase.rtf.createProcessingResourceType();
        final Procedure1<ProcessingResourceType> _function = (ProcessingResourceType it) -> {
          it.setEntityName("CPU");
        };
        final ProcessingResourceType cpuType = ObjectExtensions.<ProcessingResourceType>operator_doubleArrow(_createProcessingResourceType, _function);
        final SchedulingPolicy sPolicy = TestModelBase.rtf.createSchedulingPolicy();
        CommunicationLinkResourceType _createCommunicationLinkResourceType = TestModelBase.rtf.createCommunicationLinkResourceType();
        final Procedure1<CommunicationLinkResourceType> _function_1 = (CommunicationLinkResourceType it) -> {
          it.setEntityName("Ethernet");
        };
        final CommunicationLinkResourceType linkType = ObjectExtensions.<CommunicationLinkResourceType>operator_doubleArrow(_createCommunicationLinkResourceType, _function_1);
        PCMResourceSetPartition _get = new TestModelBase.Empty().get();
        final Procedure1<PCMResourceSetPartition> _function_2 = (PCMResourceSetPartition it) -> {
          ResourceRepository _resourceTypeRepository = it.getResourceTypeRepository();
          final Procedure1<ResourceRepository> _function_3 = (ResourceRepository it_1) -> {
            EList<ResourceType> _availableResourceTypes_ResourceRepository = it_1.getAvailableResourceTypes_ResourceRepository();
            _availableResourceTypes_ResourceRepository.add(cpuType);
            EList<ResourceType> _availableResourceTypes_ResourceRepository_1 = it_1.getAvailableResourceTypes_ResourceRepository();
            _availableResourceTypes_ResourceRepository_1.add(linkType);
            EList<SchedulingPolicy> _schedulingPolicies__ResourceRepository = it_1.getSchedulingPolicies__ResourceRepository();
            _schedulingPolicies__ResourceRepository.add(sPolicy);
          };
          ObjectExtensions.<ResourceRepository>operator_doubleArrow(_resourceTypeRepository, _function_3);
          ResourceEnvironment _resourceEnvironment = it.getResourceEnvironment();
          final Procedure1<ResourceEnvironment> _function_4 = (ResourceEnvironment it_1) -> {
            EList<ResourceContainer> _resourceContainer_ResourceEnvironment = it_1.getResourceContainer_ResourceEnvironment();
            ResourceContainer _createResourceContainer = TestModelBase.ref.createResourceContainer();
            final Procedure1<ResourceContainer> _function_5 = (ResourceContainer it_2) -> {
              it_2.setId("CA");
              it_2.setEntityName("Container A");
              EList<ProcessingResourceSpecification> _activeResourceSpecifications_ResourceContainer = it_2.getActiveResourceSpecifications_ResourceContainer();
              ProcessingResourceSpecification _createProcessingResourceSpecification = TestModelBase.ref.createProcessingResourceSpecification();
              final Procedure1<ProcessingResourceSpecification> _function_6 = (ProcessingResourceSpecification it_3) -> {
                it_3.setId("A1");
                it_3.setActiveResourceType_ActiveResourceSpecification(cpuType);
                it_3.setSchedulingPolicy(sPolicy);
                it_3.setProcessingRate_ProcessingResourceSpecification(TestModelBase.stoex("1000"));
              };
              ProcessingResourceSpecification _doubleArrow = ObjectExtensions.<ProcessingResourceSpecification>operator_doubleArrow(_createProcessingResourceSpecification, _function_6);
              _activeResourceSpecifications_ResourceContainer.add(_doubleArrow);
            };
            ResourceContainer _doubleArrow = ObjectExtensions.<ResourceContainer>operator_doubleArrow(_createResourceContainer, _function_5);
            _resourceContainer_ResourceEnvironment.add(_doubleArrow);
            EList<ResourceContainer> _resourceContainer_ResourceEnvironment_1 = it_1.getResourceContainer_ResourceEnvironment();
            ResourceContainer _createResourceContainer_1 = TestModelBase.ref.createResourceContainer();
            final Procedure1<ResourceContainer> _function_6 = (ResourceContainer it_2) -> {
              it_2.setId("CB");
              it_2.setEntityName("Container B");
              EList<ProcessingResourceSpecification> _activeResourceSpecifications_ResourceContainer = it_2.getActiveResourceSpecifications_ResourceContainer();
              ProcessingResourceSpecification _createProcessingResourceSpecification = TestModelBase.ref.createProcessingResourceSpecification();
              final Procedure1<ProcessingResourceSpecification> _function_7 = (ProcessingResourceSpecification it_3) -> {
                it_3.setId("B1");
                it_3.setActiveResourceType_ActiveResourceSpecification(cpuType);
                it_3.setSchedulingPolicy(sPolicy);
                it_3.setProcessingRate_ProcessingResourceSpecification(TestModelBase.stoex("1000"));
              };
              ProcessingResourceSpecification _doubleArrow_1 = ObjectExtensions.<ProcessingResourceSpecification>operator_doubleArrow(_createProcessingResourceSpecification, _function_7);
              _activeResourceSpecifications_ResourceContainer.add(_doubleArrow_1);
            };
            ResourceContainer _doubleArrow_1 = ObjectExtensions.<ResourceContainer>operator_doubleArrow(_createResourceContainer_1, _function_6);
            _resourceContainer_ResourceEnvironment_1.add(_doubleArrow_1);
            EList<LinkingResource> _linkingResources__ResourceEnvironment = it_1.getLinkingResources__ResourceEnvironment();
            LinkingResource _createLinkingResource = TestModelBase.ref.createLinkingResource();
            final Procedure1<LinkingResource> _function_7 = (LinkingResource it_2) -> {
              it_2.setId("LC1");
              it_2.setEntityName("Link 1");
              CommunicationLinkResourceSpecification _createCommunicationLinkResourceSpecification = TestModelBase.ref.createCommunicationLinkResourceSpecification();
              final Procedure1<CommunicationLinkResourceSpecification> _function_8 = (CommunicationLinkResourceSpecification it_3) -> {
                it_3.setId("L1");
                it_3.setCommunicationLinkResourceType_CommunicationLinkResourceSpecification(linkType);
                it_3.setThroughput_CommunicationLinkResourceSpecification(TestModelBase.stoex("1000"));
                it_3.setLatency_CommunicationLinkResourceSpecification(TestModelBase.stoex("100"));
              };
              CommunicationLinkResourceSpecification _doubleArrow_2 = ObjectExtensions.<CommunicationLinkResourceSpecification>operator_doubleArrow(_createCommunicationLinkResourceSpecification, _function_8);
              it_2.setCommunicationLinkResourceSpecifications_LinkingResource(_doubleArrow_2);
            };
            LinkingResource _doubleArrow_2 = ObjectExtensions.<LinkingResource>operator_doubleArrow(_createLinkingResource, _function_7);
            _linkingResources__ResourceEnvironment.add(_doubleArrow_2);
            EList<ResourceContainer> _connectedResourceContainers_LinkingResource = it_1.getLinkingResources__ResourceEnvironment().get(0).getConnectedResourceContainers_LinkingResource();
            EList<ResourceContainer> _resourceContainer_ResourceEnvironment_2 = it_1.getResourceContainer_ResourceEnvironment();
            Iterables.<ResourceContainer>addAll(_connectedResourceContainers_LinkingResource, _resourceContainer_ResourceEnvironment_2);
          };
          ObjectExtensions.<ResourceEnvironment>operator_doubleArrow(_resourceEnvironment, _function_4);
        };
        _xblockexpression = ObjectExtensions.<PCMResourceSetPartition>operator_doubleArrow(_get, _function_2);
      }
      return _xblockexpression;
    }
  }

  public static class WithThreeContainersAndTwoLinks implements Supplier<PCMResourceSetPartition> {
    @Override
    public PCMResourceSetPartition get() {
      PCMResourceSetPartition _get = new ResourceEnvironmentTestModels.WithTwoContainersAndOneLink().get();
      final Procedure1<PCMResourceSetPartition> _function = (PCMResourceSetPartition it) -> {
        final ProcessingResourceType cpuType = IterableExtensions.<ProcessingResourceType>head(Iterables.<ProcessingResourceType>filter(it.getResourceTypeRepository().getAvailableResourceTypes_ResourceRepository(), ProcessingResourceType.class));
        final SchedulingPolicy sPolicy = IterableExtensions.<SchedulingPolicy>head(it.getResourceTypeRepository().getSchedulingPolicies__ResourceRepository());
        final CommunicationLinkResourceType linkType = IterableExtensions.<CommunicationLinkResourceType>head(Iterables.<CommunicationLinkResourceType>filter(it.getResourceTypeRepository().getAvailableResourceTypes_ResourceRepository(), CommunicationLinkResourceType.class));
        ResourceEnvironment _resourceEnvironment = it.getResourceEnvironment();
        final Procedure1<ResourceEnvironment> _function_1 = (ResourceEnvironment it_1) -> {
          EList<ResourceContainer> _resourceContainer_ResourceEnvironment = it_1.getResourceContainer_ResourceEnvironment();
          ResourceContainer _createResourceContainer = TestModelBase.ref.createResourceContainer();
          final Procedure1<ResourceContainer> _function_2 = (ResourceContainer it_2) -> {
            it_2.setId("CC");
            it_2.setEntityName("Container C");
            EList<ProcessingResourceSpecification> _activeResourceSpecifications_ResourceContainer = it_2.getActiveResourceSpecifications_ResourceContainer();
            ProcessingResourceSpecification _createProcessingResourceSpecification = TestModelBase.ref.createProcessingResourceSpecification();
            final Procedure1<ProcessingResourceSpecification> _function_3 = (ProcessingResourceSpecification it_3) -> {
              it_3.setId("C1");
              it_3.setActiveResourceType_ActiveResourceSpecification(cpuType);
              it_3.setSchedulingPolicy(sPolicy);
              it_3.setProcessingRate_ProcessingResourceSpecification(TestModelBase.stoex("1000"));
            };
            ProcessingResourceSpecification _doubleArrow = ObjectExtensions.<ProcessingResourceSpecification>operator_doubleArrow(_createProcessingResourceSpecification, _function_3);
            _activeResourceSpecifications_ResourceContainer.add(_doubleArrow);
          };
          ResourceContainer _doubleArrow = ObjectExtensions.<ResourceContainer>operator_doubleArrow(_createResourceContainer, _function_2);
          _resourceContainer_ResourceEnvironment.add(_doubleArrow);
          LinkingResource _createLinkingResource = TestModelBase.ref.createLinkingResource();
          final Procedure1<LinkingResource> _function_3 = (LinkingResource it_2) -> {
            it_2.setId("LC2");
            it_2.setEntityName("Link 2");
            CommunicationLinkResourceSpecification _createCommunicationLinkResourceSpecification = TestModelBase.ref.createCommunicationLinkResourceSpecification();
            final Procedure1<CommunicationLinkResourceSpecification> _function_4 = (CommunicationLinkResourceSpecification it_3) -> {
              it_3.setId("L2");
              it_3.setCommunicationLinkResourceType_CommunicationLinkResourceSpecification(linkType);
              it_3.setThroughput_CommunicationLinkResourceSpecification(TestModelBase.stoex("1000"));
              it_3.setLatency_CommunicationLinkResourceSpecification(TestModelBase.stoex("100"));
            };
            CommunicationLinkResourceSpecification _doubleArrow_1 = ObjectExtensions.<CommunicationLinkResourceSpecification>operator_doubleArrow(_createCommunicationLinkResourceSpecification, _function_4);
            it_2.setCommunicationLinkResourceSpecifications_LinkingResource(_doubleArrow_1);
          };
          final LinkingResource link2 = ObjectExtensions.<LinkingResource>operator_doubleArrow(_createLinkingResource, _function_3);
          EList<LinkingResource> _linkingResources__ResourceEnvironment = it_1.getLinkingResources__ResourceEnvironment();
          _linkingResources__ResourceEnvironment.add(link2);
          EList<ResourceContainer> _connectedResourceContainers_LinkingResource = link2.getConnectedResourceContainers_LinkingResource();
          final Function1<ResourceContainer, Boolean> _function_4 = (ResourceContainer it_2) -> {
            return Boolean.valueOf(Collections.<String>unmodifiableSet(CollectionLiterals.<String>newHashSet("CB", "CC")).contains(it_2.getId()));
          };
          Iterable<ResourceContainer> _filter = IterableExtensions.<ResourceContainer>filter(it_1.getResourceContainer_ResourceEnvironment(), _function_4);
          Iterables.<ResourceContainer>addAll(_connectedResourceContainers_LinkingResource, _filter);
        };
        ObjectExtensions.<ResourceEnvironment>operator_doubleArrow(_resourceEnvironment, _function_1);
      };
      return ObjectExtensions.<PCMResourceSetPartition>operator_doubleArrow(_get, _function);
    }
  }
}
