/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.util;

import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.workflow.configuration.IJobConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.test.commons.annotation.SetConfigProperty;
import org.palladiosimulator.simulizar.test.commons.annotation.SimulationConfig;
import org.palladiosimulator.simulizar.test.commons.extension.SimuLizarTestExtensionCommons;
import org.palladiosimulator.simulizar.test.commons.util.SimuLizarTestUtils;

public class SimuLizarWorkflowConfigurationProvider
implements Supplier<IJobConfiguration> {
    final Repository edp2Repository;
    final SimulationConfig annotation;
    final List<SetConfigProperty> additionalConfig;

    public SimuLizarWorkflowConfigurationProvider(ExtensionContext context) {
        this.annotation = (SimulationConfig)AnnotationSupport.findAnnotation((Optional)context.getElement(), SimulationConfig.class).orElseThrow(() -> new IllegalArgumentException("This provider expects a SimulationConfig annotation to be (meta-)present"));
        this.additionalConfig = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), SetConfigProperty.class);
        this.edp2Repository = SimuLizarTestExtensionCommons.getObjectFromStore(context, Repository.class).orElseThrow(() -> new IllegalArgumentException("No EDP2 repository initialized. Please make sure to annotate your test accordingly."));
    }

    @Override
    public SimuLizarWorkflowConfiguration get() {
        Map<String, Object> properties = SimuLizarTestUtils.createDefaultSimulationProperties();
        properties.put("EDP2RepositoryID", this.edp2Repository.getId());
        properties.put("simulateFailures", this.annotation.simulateReliability());
        properties.put("simulateLinkingResources", this.annotation.simulateLinkingResource());
        properties.put("simulateThroughputOfLinkingResources", this.annotation.simulateLinkThroughput());
        properties.put("maximumMeasurementCount", this.annotation.maxMeasurements());
        properties.put("simTime", this.annotation.maxSimTime());
        this.additionalConfig.forEach(prop -> {
            String string = properties.put(prop.id(), prop.value());
        });
        SimuLizarWorkflowConfiguration simulizarConfiguration = new SimuLizarWorkflowConfiguration(properties);
        simulizarConfiguration.setSimuComConfiguration(new SimuComConfig(properties, false, null));
        Optional.ofNullable(properties.get("reconfigurationRulesFolder")).ifPresent(o -> simulizarConfiguration.setReconfigurationRulesFolder(o.toString()));
        return simulizarConfiguration;
    }
}

